/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.gui.pos;

import buildcraft.lib.expression.api.IConstantNode;
import buildcraft.lib.expression.node.value.NodeConstantDouble;
import buildcraft.lib.gui.pos.AreaCallable;
import buildcraft.lib.gui.pos.GuiRectangle;
import buildcraft.lib.gui.pos.IGuiPosition;
import buildcraft.lib.gui.pos.PositionAbsolute;
import buildcraft.lib.gui.pos.PositionCallable;
import java.util.function.DoubleSupplier;

public interface IGuiArea
extends IGuiPosition {
    public double getWidth();

    public double getHeight();

    default public double getCenterX() {
        return this.getX() + this.getWidth() / 2.0;
    }

    default public double getCenterY() {
        return this.getY() + this.getHeight() / 2.0;
    }

    default public double getEndX() {
        return this.getX() + this.getWidth();
    }

    default public double getEndY() {
        return this.getY() + this.getHeight();
    }

    default public boolean contains(double x, double y) {
        double tx = this.getX();
        double ty = this.getY();
        double w = this.getWidth();
        double h = this.getHeight();
        if (x < tx || x >= tx + w) {
            return false;
        }
        return !(y < ty) && !(y >= ty + h);
    }

    default public boolean contains(IGuiPosition position) {
        return this.contains(position.getX(), position.getY());
    }

    default public boolean contains(IGuiArea element) {
        if (element.getX() < this.getX() || element.getEndX() >= this.getEndX()) {
            return false;
        }
        return !(element.getY() < this.getY()) && !(element.getEndY() >= this.getEndY());
    }

    default public String rectangleToString() {
        return "[x = " + this.getX() + ", y = " + this.getY() + ", w = " + this.getWidth() + ", h = " + this.getHeight() + "]";
    }

    default public GuiRectangle asImmutable() {
        return new GuiRectangle(this.getX(), this.getY(), this.getWidth(), this.getHeight());
    }

    default public IGuiPosition getCenter() {
        return this.getPosition(0, 0);
    }

    default public IGuiPosition getEnd() {
        return this.getPosition(1, 1);
    }

    default public IGuiPosition getCenterTop() {
        return this.getPosition(0, 0);
    }

    default public IGuiPosition getPosition(int partX, int partY) {
        DoubleSupplier x;
        DoubleSupplier doubleSupplier = partX < 0 ? this::getX : (x = partX > 0 ? this::getEndX : this::getCenterX);
        DoubleSupplier y = partY < 0 ? this::getY : (partY > 0 ? this::getEndY : this::getCenterY);
        return new PositionCallable(x, y);
    }

    @Override
    default public IGuiArea offset(IGuiPosition by) {
        if (by instanceof PositionAbsolute && by.getX() == 0.0 && by.getY() == 0.0) {
            return this;
        }
        return this.offset(by::getX, by::getY);
    }

    @Override
    default public IGuiArea offset(double x, DoubleSupplier y) {
        if (y instanceof IConstantNode) {
            return this.offset(x, y.getAsDouble());
        }
        return this.offset((DoubleSupplier)NodeConstantDouble.of(x), y);
    }

    @Override
    default public IGuiArea offset(DoubleSupplier x, double y) {
        if (x instanceof IConstantNode) {
            return this.offset(x.getAsDouble(), y);
        }
        return this.offset(x, (DoubleSupplier)NodeConstantDouble.of(y));
    }

    @Override
    default public IGuiArea offset(DoubleSupplier x, DoubleSupplier y) {
        return IGuiArea.create(() -> this.getX() + x.getAsDouble(), () -> this.getY() + y.getAsDouble(), this::getWidth, this::getHeight);
    }

    @Override
    default public IGuiArea offset(double x, double y) {
        if (x == 0.0 && y == 0.0) {
            return this;
        }
        return IGuiArea.create(() -> this.getX() + x, () -> this.getY() + y, this::getWidth, this::getHeight);
    }

    default public IGuiArea resize(double newWidth, double newHeight) {
        return IGuiArea.create(this::getX, this::getY, () -> newWidth, () -> newHeight);
    }

    default public IGuiArea resize(DoubleSupplier newWidth, DoubleSupplier newHeight) {
        return IGuiArea.create(this::getX, this::getY, newWidth, newHeight);
    }

    default public IGuiArea expand(double by) {
        return this.expand(by, by);
    }

    default public IGuiArea expand(double dX, double dY) {
        return IGuiArea.create(() -> this.getX() - dX, () -> this.getY() - dY, () -> this.getWidth() + dX * 2.0, () -> this.getHeight() + dY * 2.0);
    }

    default public IGuiArea expand(DoubleSupplier by) {
        if (by instanceof IConstantNode) {
            return this.expand(by.getAsDouble());
        }
        return this.expand(by, by);
    }

    default public IGuiArea expand(DoubleSupplier dX, DoubleSupplier dY) {
        if (dX instanceof IConstantNode && dY instanceof IConstantNode) {
            return this.expand(dX.getAsDouble(), dY.getAsDouble());
        }
        return IGuiArea.create(() -> this.getX() - dX.getAsDouble(), () -> this.getY() - dY.getAsDouble(), () -> this.getWidth() + dX.getAsDouble() * 2.0, () -> this.getHeight() + dY.getAsDouble() * 2.0);
    }

    default public IGuiArea offsetToOrigin() {
        return IGuiArea.create(() -> 0.0, () -> 0.0, this::getWidth, this::getHeight);
    }

    public static IGuiArea create(DoubleSupplier width, DoubleSupplier height) {
        if (width instanceof IConstantNode && height instanceof IConstantNode) {
            return new GuiRectangle(width.getAsDouble(), height.getAsDouble());
        }
        return new AreaCallable(width, height);
    }

    public static IGuiArea create(DoubleSupplier x, DoubleSupplier y, DoubleSupplier width, DoubleSupplier height) {
        if (x instanceof IConstantNode && y instanceof IConstantNode && width instanceof IConstantNode && height instanceof IConstantNode) {
            return new GuiRectangle(x.getAsDouble(), y.getAsDouble(), width.getAsDouble(), height.getAsDouble());
        }
        return new AreaCallable(x, y, width, height);
    }

    public static IGuiArea create(IGuiPosition pos, double width, double height) {
        if (pos instanceof PositionAbsolute) {
            return new GuiRectangle(pos.getX(), pos.getY(), width, height);
        }
        return new AreaCallable(pos::getX, pos::getY, () -> width, () -> height);
    }
}

