/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.lib.misc.data;

public class AverageInt {
    public int[] data;
    public int pos;
    public int precise;
    public int averageRaw;
    public int tickValue;

    public AverageInt(int precise) {
        this.precise = precise;
        this.clear();
    }

    public void clear() {
        this.data = new int[this.precise];
        this.pos = 0;
    }

    public double getAverage() {
        double avg = 0.0;
        int[] nArray = this.data;
        int n = nArray.length;
        for (int i = 0; i < n; ++i) {
            double d = nArray[i];
            avg += d;
        }
        return avg / (double)this.precise;
    }

    public void tick(int value) {
        this.internalTick(this.tickValue + value);
        this.tickValue = 0;
    }

    public void tick() {
        this.internalTick(this.tickValue);
        this.tickValue = 0;
    }

    private void internalTick(int value) {
        ++this.pos;
        this.pos %= this.precise;
        int oldValue = this.data[this.pos];
        this.data[this.pos] = value;
        if (this.pos == 0) {
            this.averageRaw = 0;
            for (int iValue : this.data) {
                this.averageRaw += iValue;
            }
        } else {
            this.averageRaw = this.averageRaw - oldValue + value;
        }
    }

    public void push(int value) {
        this.tickValue += value;
    }

    public String toString() {
        return String.valueOf(this.getAverage());
    }
}

