/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.gate;

import buildcraft.lib.misc.LocaleUtil;
import buildcraft.silicon.gate.EnumGateLogic;
import buildcraft.silicon.gate.EnumGateMaterial;
import java.util.Objects;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;

public class GateVariant {
    public final EnumGateLogic logic;
    public final EnumGateMaterial material;
    public final int numSlots;
    public final int numTriggerArgs;
    public final int numActionArgs;
    private final int hash;

    public GateVariant(EnumGateLogic logic, EnumGateMaterial material) {
        this.logic = logic;
        this.material = material;
        this.numSlots = material.numSlots;
        this.numTriggerArgs = material.triggerArgs;
        this.numActionArgs = material.actionArgs;
        this.hash = Objects.hash(new Object[]{logic, material});
    }

    public GateVariant(NBTTagCompound nbt) {
        this.logic = EnumGateLogic.getByOrdinal(nbt.func_74771_c("logic"));
        this.material = EnumGateMaterial.getByOrdinal(nbt.func_74771_c("material"));
        this.numSlots = this.material.numSlots;
        this.numTriggerArgs = this.material.triggerArgs;
        this.numActionArgs = this.material.actionArgs;
        this.hash = Objects.hash(new Object[]{this.logic, this.material});
    }

    public NBTTagCompound writeToNBT() {
        NBTTagCompound nbt = new NBTTagCompound();
        nbt.func_74774_a("logic", (byte)this.logic.ordinal());
        nbt.func_74774_a("material", (byte)this.material.ordinal());
        return nbt;
    }

    public GateVariant(PacketBuffer buffer) {
        this.logic = EnumGateLogic.getByOrdinal(buffer.readUnsignedByte());
        this.material = EnumGateMaterial.getByOrdinal(buffer.readUnsignedByte());
        this.numSlots = this.material.numSlots;
        this.numTriggerArgs = this.material.triggerArgs;
        this.numActionArgs = this.material.actionArgs;
        this.hash = Objects.hash(new Object[]{this.logic, this.material});
    }

    public void writeToBuffer(PacketBuffer buffer) {
        buffer.writeByte(this.logic.ordinal());
        buffer.writeByte(this.material.ordinal());
    }

    public String getVariantName() {
        return this.material.tag + "_" + this.logic.tag;
    }

    public String getLocalizedName() {
        if (this.material == EnumGateMaterial.BASIC) {
            return LocaleUtil.localize("gate.name.basic");
        }
        String gateName = LocaleUtil.localize("gate.name");
        String materialName = LocaleUtil.localize("gate.material." + this.material.tag);
        String logicName = LocaleUtil.localize("gate.logic." + this.logic.tag);
        return String.format(gateName, materialName, logicName);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass() != this.getClass()) {
            return false;
        }
        GateVariant other = (GateVariant)obj;
        return other.logic == this.logic && other.material == this.material;
    }

    public int hashCode() {
        return this.hash;
    }
}

