/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.silicon.tile;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.recipes.IngredientStack;
import buildcraft.api.recipes.IntegrationRecipe;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.lib.recipe.IntegrationRecipeRegistry;
import buildcraft.lib.tile.item.ItemHandlerManager;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import buildcraft.silicon.tile.TileLaserTableBase;
import com.google.common.collect.ImmutableList;
import java.io.IOException;
import java.util.Collection;
import java.util.List;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class TileIntegrationTable
extends TileLaserTableBase {
    public final ItemHandlerSimple invTarget;
    public final ItemHandlerSimple invToIntegrate;
    public final ItemHandlerSimple invResult;
    public IntegrationRecipe recipe;

    public TileIntegrationTable() {
        this.invTarget = this.itemManager.addInvHandler("target", 1, ItemHandlerManager.EnumAccess.BOTH, EnumPipePart.VALUES);
        this.invToIntegrate = this.itemManager.addInvHandler("toIntegrate", 8, ItemHandlerManager.EnumAccess.BOTH, EnumPipePart.VALUES);
        this.invResult = this.itemManager.addInvHandler("result", 1, ItemHandlerManager.EnumAccess.INSERT, EnumPipePart.VALUES);
    }

    private boolean extract(IngredientStack item, ImmutableList<IngredientStack> items, boolean simulate) {
        ItemStack targetStack = this.invTarget.getStackInSlot(0);
        if (targetStack.func_190926_b()) {
            return false;
        }
        if (!StackUtil.contains(item, targetStack)) {
            return false;
        }
        if (!this.extract(this.invToIntegrate, (Collection<IngredientStack>)items, simulate, true)) {
            return false;
        }
        if (!simulate) {
            targetStack.func_190920_e(targetStack.func_190916_E() - item.count);
            this.invTarget.setStackInSlot(0, targetStack);
        }
        return true;
    }

    private boolean isSpaceEnough(ItemStack stack) {
        ItemStack output = this.invResult.getStackInSlot(0);
        return output.func_190926_b() || StackUtil.canMerge(stack, output) && stack.func_190916_E() + output.func_190916_E() <= stack.func_77976_d();
    }

    private void updateRecipe() {
        ItemStack output;
        if (this.recipe != null && !(output = this.getOutput()).func_190926_b() && this.extract(this.recipe.getCenterStack(), this.recipe.getRequirements(output), true)) {
            return;
        }
        this.recipe = IntegrationRecipeRegistry.INSTANCE.getRecipeFor(this.invTarget.getStackInSlot(0), this.invToIntegrate.stacks);
    }

    public ItemStack getOutput() {
        return this.recipe != null ? this.recipe.getOutput(this.invTarget.getStackInSlot(0), this.invToIntegrate.stacks) : ItemStack.field_190927_a;
    }

    @Override
    public long getTarget() {
        ItemStack output = this.getOutput();
        return this.recipe != null && this.isSpaceEnough(output) ? this.recipe.getRequiredMicroJoules() : 0L;
    }

    @Override
    public void func_73660_a() {
        super.func_73660_a();
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.updateRecipe();
        if (this.getTarget() > 0L && this.power >= this.getTarget()) {
            ItemStack output = this.getOutput();
            this.extract(this.recipe.getCenterStack(), this.recipe.getRequirements(output), false);
            ItemStack result = this.invResult.getStackInSlot(0);
            if (!result.func_190926_b()) {
                result = result.func_77946_l();
                result.func_190920_e(result.func_190916_E() + output.func_190916_E());
            } else {
                result = output.func_77946_l();
            }
            this.invResult.setStackInSlot(0, result);
            this.power -= this.getTarget();
        }
        this.sendNetworkGuiUpdate(NET_GUI_DATA);
    }

    @Override
    public NBTTagCompound func_189515_b(NBTTagCompound nbt) {
        super.func_189515_b(nbt);
        if (this.recipe != null) {
            nbt.func_74778_a("recipe", this.recipe.name.toString());
        }
        return nbt;
    }

    @Override
    public void func_145839_a(NBTTagCompound nbt) {
        super.func_145839_a(nbt);
        this.recipe = nbt.func_74764_b("recipe") ? this.lookupRecipe(nbt.func_74779_i("recipe")) : null;
    }

    @Override
    public void writePayload(int id, PacketBufferBC buffer, Side side) {
        super.writePayload(id, buffer, side);
        if (id == NET_GUI_DATA) {
            buffer.writeBoolean(this.recipe != null);
            if (this.recipe != null) {
                buffer.func_180714_a(this.recipe.name.toString());
            }
        }
    }

    @Override
    public void readPayload(int id, PacketBufferBC buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(id, buffer, side, ctx);
        if (id == NET_GUI_DATA) {
            this.recipe = buffer.readBoolean() ? this.lookupRecipe(buffer.readString()) : null;
        }
    }

    @Override
    public void getDebugInfo(List<String> left, List<String> right, EnumFacing side) {
        super.getDebugInfo(left, right, side);
        left.add("recipe - " + this.recipe);
        left.add("target - " + this.getTarget());
    }

    private IntegrationRecipe lookupRecipe(String name) {
        return IntegrationRecipeRegistry.INSTANCE.getRecipe(new ResourceLocation(name));
    }
}

