/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.net;

import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeFlow;
import buildcraft.lib.BCLibProxy;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.pipe.flow.PipeFlowItems;
import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;

public class MessageMultiPipeItem
implements IMessage {
    private static final int MAX_ITEMS_PER_PIPE = 10;
    private static final int MAX_POSITIONS = 4000;
    public final Map<BlockPos, List<TravellingItemData>> items = new HashMap<BlockPos, List<TravellingItemData>>();
    public static final IMessageHandler<MessageMultiPipeItem, IMessage> HANDLER = (message, ctx) -> {
        World world = BCLibProxy.getProxy().getClientWorld();
        if (world == null) {
            return null;
        }
        for (Map.Entry<BlockPos, List<TravellingItemData>> entry : message.items.entrySet()) {
            BlockPos pos = entry.getKey();
            TileEntity tile = world.func_175625_s(pos);
            if (!(tile instanceof IPipeHolder)) continue;
            IPipe pipe = ((IPipeHolder)tile).getPipe();
            if (pipe == null) {
                return null;
            }
            PipeFlow flow = pipe.getFlow();
            if (!(flow instanceof PipeFlowItems)) continue;
            ((PipeFlowItems)flow).handleClientReceviedItems(entry.getValue());
        }
        return null;
    };

    public void fromBytes(ByteBuf buffer) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc(buffer);
        int blockCount = buf.readShort();
        for (int b = 0; b < blockCount; ++b) {
            BlockPos pos = buf.func_179259_c();
            ArrayList<TravellingItemData> posItems = new ArrayList<TravellingItemData>();
            this.items.put(pos, posItems);
            int itemCount = buf.readUnsignedByte();
            for (int i = 0; i < itemCount; ++i) {
                posItems.add(new TravellingItemData(buf));
            }
        }
    }

    public void toBytes(ByteBuf buffer) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc(buffer);
        int blockCount = Math.min(this.items.size(), 4000);
        buf.writeShort(blockCount);
        int blockIndex = 0;
        for (Map.Entry<BlockPos, List<TravellingItemData>> entry : this.items.entrySet()) {
            buf.func_179255_a(entry.getKey());
            List<TravellingItemData> list = entry.getValue();
            int itemCount = Math.min(list.size(), 10);
            buf.writeByte(itemCount);
            for (int i = 0; i < itemCount; ++i) {
                list.get(i).toBuffer(buf);
            }
            if (++blockIndex < blockCount) continue;
            break;
        }
    }

    public void append(BlockPos pos, int stackId, byte stackCount, boolean toCenter, EnumFacing side, EnumDyeColor colour, byte timeToDest) {
        List<TravellingItemData> list = this.items.get(pos);
        if (list == null) {
            if (this.items.size() >= 4000) {
                return;
            }
            list = new ArrayList<TravellingItemData>();
            this.items.put(pos, list);
        }
        if (list.size() >= 10) {
            return;
        }
        list.add(new TravellingItemData(stackId, stackCount, toCenter, side, colour, timeToDest));
    }

    public static class TravellingItemData {
        public final int stackId;
        public final byte stackCount;
        public final boolean toCenter;
        public final EnumFacing side;
        @Nullable
        public final EnumDyeColor colour;
        public final byte timeToDest;

        public TravellingItemData(int stackId, byte stackCount, boolean toCenter, EnumFacing side, EnumDyeColor colour, byte timeToDest) {
            this.stackId = stackId;
            this.stackCount = stackCount;
            this.toCenter = toCenter;
            this.side = side;
            this.colour = colour;
            this.timeToDest = timeToDest;
        }

        TravellingItemData(PacketBufferBC buf) {
            this.stackId = buf.func_150792_a();
            this.stackCount = buf.readByte();
            this.toCenter = buf.readBoolean();
            this.side = buf.func_179257_a(EnumFacing.class);
            this.colour = MessageUtil.readEnumOrNull((ByteBuf)buf, EnumDyeColor.class);
            this.timeToDest = buf.readByte();
        }

        void toBuffer(PacketBufferBC buf) {
            buf.func_150787_b(this.stackId);
            buf.writeByte(this.stackCount);
            buf.writeBoolean(this.toCenter);
            buf.writeEnumValue((Enum<?>)this.side);
            MessageUtil.writeEnumOrNull((ByteBuf)buf, this.colour);
            buf.writeByte(this.timeToDest);
        }
    }
}

