/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.net;

import buildcraft.lib.BCLibProxy;
import buildcraft.lib.net.PacketBufferBC;
import buildcraft.transport.pipe.flow.PipeFlowPower;
import buildcraft.transport.tile.TilePipeHolder;
import io.netty.buffer.ByteBuf;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;

public class PacketPowerUpdate
implements IMessage {
    public static final IMessageHandler<PacketPowerUpdate, IMessage> HANDLER = (message, ctx) -> {
        World world = BCLibProxy.getProxy().getClientWorld();
        if (world == null) {
            return null;
        }
        if (!world.func_175667_e(message.pos)) {
            return null;
        }
        TileEntity entity = world.func_175625_s(message.pos);
        if (!(entity instanceof TilePipeHolder)) {
            return null;
        }
        TilePipeHolder pipe = (TilePipeHolder)entity;
        if (pipe.getPipe() == null) {
            return null;
        }
        if (!(pipe.getPipe().flow instanceof PipeFlowPower)) {
            return null;
        }
        ((PipeFlowPower)pipe.getPipe().flow).handlePowerPacket((PacketPowerUpdate)message);
        return null;
    };
    public boolean overload;
    public int[] displayPower;
    public short[] displayFlow;
    public BlockPos pos;

    public PacketPowerUpdate() {
    }

    public PacketPowerUpdate(BlockPos pos) {
        this.pos = pos;
    }

    public void fromBytes(ByteBuf buffer) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc(buffer);
        this.displayPower = new int[6];
        this.displayFlow = new short[6];
        this.overload = buf.readBoolean();
        for (int i = 0; i < this.displayPower.length; ++i) {
            this.displayPower[i] = buf.readUnsignedByte();
            this.displayFlow[i] = buf.readByte();
        }
        this.pos = BlockPos.func_177969_a((long)buf.readLong());
    }

    public void toBytes(ByteBuf buffer) {
        PacketBufferBC buf = PacketBufferBC.asPacketBufferBc(buffer);
        buf.writeBoolean(this.overload);
        for (int i = 0; i < this.displayPower.length; ++i) {
            buf.writeByte(this.displayPower[i]);
            buf.writeByte(this.displayFlow[i]);
        }
        buf.writeLong(this.pos.func_177986_g());
    }
}

