/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IStackFilter;
import buildcraft.api.transport.IItemPluggable;
import buildcraft.api.transport.pipe.IFlowFluid;
import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.lib.inventory.filter.ArrayFluidFilter;
import buildcraft.lib.inventory.filter.DelegatingItemHandlerFilter;
import buildcraft.lib.inventory.filter.InvertedFluidFilter;
import buildcraft.lib.inventory.filter.InvertedStackFilter;
import buildcraft.lib.inventory.filter.StackFilter;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import buildcraft.transport.BCTransportConfig;
import buildcraft.transport.BCTransportGuis;
import buildcraft.transport.pipe.behaviour.PipeBehaviourWood;
import java.io.IOException;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.items.IItemHandlerModifiable;

public class PipeBehaviourEmerald
extends PipeBehaviourWood {
    public final ItemHandlerSimple filters = new ItemHandlerSimple(9, this::onSlotChanged);
    public FilterMode filterMode = FilterMode.WHITE_LIST;
    public int currentFilter = 0;
    public boolean filterValid = false;

    public PipeBehaviourEmerald(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviourEmerald(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.filters.deserializeNBT(nbt.func_74775_l("filters"));
        this.filterMode = FilterMode.get(nbt.func_74771_c("mode"));
        this.currentFilter = nbt.func_74771_c("currentFilter") % this.filters.getSlots();
        this.filterValid = !this.filters.extract(StackFilter.ALL, 1, 1, true).func_190926_b();
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74782_a("filters", (NBTBase)this.filters.serializeNBT());
        nbt.func_74774_a("mode", (byte)this.filterMode.ordinal());
        nbt.func_74774_a("currentFilter", (byte)this.currentFilter);
        return nbt;
    }

    @Override
    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(buffer, side, ctx);
        if (side == Side.CLIENT) {
            this.filterMode = FilterMode.get(buffer.readUnsignedByte());
            this.currentFilter = buffer.readUnsignedByte() % this.filters.getSlots();
            this.filterValid = buffer.readBoolean();
        }
    }

    @Override
    public void writePayload(PacketBuffer buffer, Side side) {
        super.writePayload(buffer, side);
        if (side == Side.SERVER) {
            buffer.writeByte(this.filterMode.ordinal());
            buffer.writeByte(this.currentFilter);
            buffer.writeBoolean(this.filterValid);
        }
    }

    @Override
    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (player.func_70093_af()) {
            return super.onPipeActivate(player, trace, hitX, hitY, hitZ, part);
        }
        ItemStack held = player.func_184614_ca();
        if (!held.func_190926_b() && held.func_77973_b() instanceof IItemPluggable) {
            return false;
        }
        if (!player.field_70170_p.field_72995_K) {
            BCTransportGuis.PIPE_EMERALD.openGui(player, this.pipe.getHolder().getPipePos());
        }
        return true;
    }

    private void onSlotChanged(IItemHandlerModifiable itemHandler, int slot, ItemStack before, ItemStack after) {
        if (!after.func_190926_b()) {
            if (!this.filterValid) {
                this.currentFilter = slot;
                this.filterValid = true;
            }
        } else if (slot == this.currentFilter) {
            this.advanceFilter();
        }
    }

    private IStackFilter getStackFilter() {
        switch (this.filterMode) {
            default: {
                if (this.filters.extract(s -> true, 1, 1, true).func_190926_b()) {
                    return s -> true;
                }
                return new DelegatingItemHandlerFilter(StackUtil::isMatchingItemOrList, this.filters);
            }
            case BLACK_LIST: {
                return new InvertedStackFilter(new DelegatingItemHandlerFilter(StackUtil::isMatchingItemOrList, this.filters));
            }
            case ROUND_ROBIN: 
        }
        return comparison -> {
            ItemStack filter = this.filters.getStackInSlot(this.currentFilter);
            return StackUtil.isMatchingItemOrList(filter, comparison);
        };
    }

    @Override
    protected long extract(long power, boolean simulate) {
        if (power > 0L) {
            if (this.pipe.getFlow() instanceof IFlowItems) {
                int extracted;
                IFlowItems flow = (IFlowItems)((Object)this.pipe.getFlow());
                int maxItems = (int)(power / BCTransportConfig.mjPerItem);
                if (maxItems > 64) {
                    maxItems = 64;
                }
                if (maxItems > 0 && (extracted = this.extractItems(flow, this.getCurrentDir(), maxItems, simulate)) > 0) {
                    return power - (long)extracted * BCTransportConfig.mjPerItem;
                }
            } else if (this.pipe.getFlow() instanceof IFlowFluid) {
                FluidStack extracted;
                IFlowFluid flow = (IFlowFluid)((Object)this.pipe.getFlow());
                int maxMillibuckets = (int)(power / BCTransportConfig.mjPerMillibucket);
                if (maxMillibuckets > 80) {
                    maxMillibuckets = 80;
                }
                if (maxMillibuckets > 0 && (extracted = this.extractFluid(flow, this.getCurrentDir(), maxMillibuckets, simulate)) != null && extracted.amount > 0) {
                    return power - (long)extracted.amount * BCTransportConfig.mjPerMillibucket;
                }
            }
        }
        return power;
    }

    @Override
    protected int extractItems(IFlowItems flow, EnumFacing dir, int count, boolean simulate) {
        int extracted;
        if (this.filters.getStackInSlot(this.currentFilter).func_190926_b()) {
            this.advanceFilter();
        }
        if ((extracted = flow.tryExtractItems(1, this.getCurrentDir(), null, this.getStackFilter(), simulate)) > 0 & this.filterMode == FilterMode.ROUND_ROBIN && !simulate) {
            this.advanceFilter();
        }
        return extracted;
    }

    @Override
    protected FluidStack extractFluid(IFlowFluid flow, EnumFacing dir, int millibuckets, boolean simulate) {
        if (this.filters.getStackInSlot(this.currentFilter).func_190926_b()) {
            this.advanceFilter();
        }
        switch (this.filterMode) {
            default: {
                if (this.filters.extract(s -> true, 1, 1, true).func_190926_b()) {
                    return flow.tryExtractFluid(millibuckets, dir, null, simulate);
                }
                ActionResult<FluidStack> result = flow.tryExtractFluidAdv(millibuckets, dir, new ArrayFluidFilter(this.filters.stacks), simulate);
                FluidStack extracted = (FluidStack)result.func_188398_b();
                if (result.func_188397_a() != EnumActionResult.PASS) {
                    return extracted;
                }
                if (extracted.amount <= 0) {
                    for (int i = 0; i < this.filters.getSlots(); ++i) {
                        ItemStack stack = this.filters.getStackInSlot(i);
                        if (stack.func_190926_b() || (extracted = flow.tryExtractFluid(millibuckets, dir, FluidUtil.getFluidContained((ItemStack)stack), simulate)) == null || extracted.amount <= 0) continue;
                        return extracted;
                    }
                }
                return null;
            }
            case BLACK_LIST: {
                InvertedFluidFilter filter = new InvertedFluidFilter(new ArrayFluidFilter(this.filters.stacks));
                return (FluidStack)flow.tryExtractFluidAdv(millibuckets, dir, filter, simulate).func_188398_b();
            }
            case ROUND_ROBIN: 
        }
        return null;
    }

    private void advanceFilter() {
        int lastFilter = this.currentFilter;
        this.filterValid = false;
        do {
            ++this.currentFilter;
            if (this.currentFilter >= this.filters.getSlots()) {
                this.currentFilter = 0;
            }
            if (this.filters.getStackInSlot(this.currentFilter).func_190926_b()) continue;
            this.filterValid = true;
            break;
        } while (this.currentFilter != lastFilter);
        if (lastFilter != this.currentFilter) {
            this.pipe.getHolder().scheduleNetworkGuiUpdate(IPipeHolder.PipeMessageReceiver.BEHAVIOUR);
        }
    }

    public static enum FilterMode {
        WHITE_LIST,
        BLACK_LIST,
        ROUND_ROBIN;


        public static FilterMode get(int index) {
            switch (index) {
                default: {
                    return WHITE_LIST;
                }
                case 1: {
                    return BLACK_LIST;
                }
                case 2: 
            }
            return ROUND_ROBIN;
        }
    }
}

