/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.core.EnumPipePart;
import buildcraft.api.core.IStackFilter;
import buildcraft.api.transport.pipe.IFlowItems;
import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.IPipeHolder;
import buildcraft.api.transport.pipe.PipeEventActionActivate;
import buildcraft.api.transport.pipe.PipeEventStatement;
import buildcraft.lib.misc.MessageUtil;
import buildcraft.lib.misc.NBTUtilBC;
import buildcraft.lib.misc.StackUtil;
import buildcraft.lib.tile.item.ItemHandlerSimple;
import buildcraft.transport.BCTransportGuis;
import buildcraft.transport.BCTransportStatements;
import buildcraft.transport.pipe.behaviour.PipeBehaviourWood;
import buildcraft.transport.statements.ActionExtractionPreset;
import io.netty.buffer.ByteBuf;
import java.io.IOException;
import java.util.Collections;
import java.util.EnumMap;
import java.util.EnumSet;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PipeBehaviourEmzuli
extends PipeBehaviourWood {
    public final EnumMap<SlotIndex, EnumDyeColor> slotColours = new EnumMap(SlotIndex.class);
    public final ItemHandlerSimple invFilters = new ItemHandlerSimple(4, null);
    private final EnumSet<SlotIndex> activeSlots;
    private final byte[] activatedTtl = new byte[SlotIndex.VALUES.length];
    private SlotIndex currentSlot = null;
    private final IStackFilter filter = this::filterMatches;

    public PipeBehaviourEmzuli(IPipe pipe) {
        super(pipe);
        this.activeSlots = EnumSet.noneOf(SlotIndex.class);
    }

    public PipeBehaviourEmzuli(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
        this.invFilters.deserializeNBT(nbt.func_74775_l("Filters"));
        this.activeSlots = NBTUtilBC.readEnumSet(nbt.func_74781_a("activeSlots"), SlotIndex.class);
        this.currentSlot = NBTUtilBC.readEnum(nbt.func_74781_a("currentSlot"), SlotIndex.class);
        for (SlotIndex index : SlotIndex.VALUES) {
            byte c = nbt.func_74771_c("slotColors[" + index.ordinal() + "]");
            if (c <= 0 || c > 16) continue;
            this.slotColours.put(index, EnumDyeColor.func_176764_b((int)(c - 1)));
        }
    }

    @Override
    public NBTTagCompound writeToNbt() {
        NBTTagCompound nbt = super.writeToNbt();
        nbt.func_74782_a("Filters", (NBTBase)this.invFilters.serializeNBT());
        nbt.func_74782_a("activeSlots", NBTUtilBC.writeEnumSet(this.activeSlots, SlotIndex.class));
        nbt.func_74782_a("currentSlot", NBTUtilBC.writeEnum(this.currentSlot));
        for (SlotIndex index : SlotIndex.VALUES) {
            EnumDyeColor c = this.slotColours.get((Object)index);
            nbt.func_74774_a("slotColors[" + index.ordinal() + "]", (byte)(c == null ? 0 : c.func_176765_a() + 1));
        }
        return nbt;
    }

    @Override
    public void readPayload(PacketBuffer buffer, Side side, MessageContext ctx) throws IOException {
        super.readPayload(buffer, side, ctx);
        if (side == Side.CLIENT) {
            for (SlotIndex index : SlotIndex.VALUES) {
                EnumDyeColor colour = MessageUtil.readEnumOrNull((ByteBuf)buffer, EnumDyeColor.class);
                if (colour == null) {
                    this.slotColours.remove((Object)index);
                    continue;
                }
                this.slotColours.put(index, colour);
            }
            this.activeSlots.clear();
            this.activeSlots.addAll(MessageUtil.readEnumSet((ByteBuf)buffer, SlotIndex.class));
            this.currentSlot = MessageUtil.readEnumOrNull((ByteBuf)buffer, SlotIndex.class);
        }
    }

    @Override
    public void writePayload(PacketBuffer buffer, Side side) {
        super.writePayload(buffer, side);
        if (side == Side.SERVER) {
            for (SlotIndex index : SlotIndex.VALUES) {
                MessageUtil.writeEnumOrNull((ByteBuf)buffer, (Enum)this.slotColours.get((Object)index));
            }
            MessageUtil.writeEnumSet((ByteBuf)buffer, this.activeSlots, SlotIndex.class);
            MessageUtil.writeEnumOrNull((ByteBuf)buffer, this.currentSlot);
        }
    }

    @Override
    protected int extractItems(IFlowItems flow, EnumFacing dir, int count, boolean simulate) {
        if (this.currentSlot == null && this.activeSlots.size() > 0) {
            this.currentSlot = this.getNextSlot();
        }
        if (this.currentSlot == null) {
            return 0;
        }
        int extracted = flow.tryExtractItems(count, dir, this.slotColours.get((Object)this.currentSlot), this.filter, simulate);
        if (extracted > 0 && !simulate) {
            this.currentSlot = this.getNextSlot();
            this.pipe.getHolder().scheduleNetworkUpdate(IPipeHolder.PipeMessageReceiver.BEHAVIOUR);
        }
        return extracted;
    }

    private boolean filterMatches(@Nonnull ItemStack stack) {
        if (this.currentSlot == null) {
            return false;
        }
        ItemStack current = this.invFilters.getStackInSlot(this.currentSlot.ordinal());
        return StackUtil.isMatchingItemOrList(current, stack);
    }

    @Override
    public void onTick() {
        super.onTick();
        if (this.pipe.getHolder().getPipeWorld().field_72995_K) {
            return;
        }
        for (SlotIndex index : SlotIndex.VALUES) {
            byte val = this.activatedTtl[index.ordinal()];
            if (val > 0) {
                this.activatedTtl[index.ordinal()] = val = (byte)(val - 1);
            }
            if (val != 0) continue;
            this.activeSlots.remove((Object)index);
            if (this.currentSlot != index) continue;
            this.currentSlot = this.getNextSlot();
            this.pipe.getHolder().scheduleNetworkUpdate(IPipeHolder.PipeMessageReceiver.BEHAVIOUR);
        }
    }

    private SlotIndex getNextSlot() {
        SlotIndex current = this.currentSlot == null ? SlotIndex.CROSS : this.currentSlot;
        int i = SlotIndex.VALUES.length;
        while (i-- > 0) {
            if (!this.activeSlots.contains((Object)(current = current.next())) || this.invFilters.getStackInSlot(current.ordinal()).func_190926_b()) continue;
            return current;
        }
        return null;
    }

    public SlotIndex getCurrentSlot() {
        return this.currentSlot;
    }

    public EnumSet<SlotIndex> getActiveSlots() {
        return this.activeSlots;
    }

    @Override
    public boolean onPipeActivate(EntityPlayer player, RayTraceResult trace, float hitX, float hitY, float hitZ, EnumPipePart part) {
        if (player.func_70093_af()) {
            return super.onPipeActivate(player, trace, hitX, hitY, hitZ, part);
        }
        if (player.func_70613_aW()) {
            BCTransportGuis.PIPE_EMZULI.openGui(player, this.pipe.getHolder().getPipePos());
        }
        return true;
    }

    @Override
    public void addActions(PipeEventStatement.AddActionInternal event) {
        super.addActions(event);
        Collections.addAll(event.actions, BCTransportStatements.ACTION_EXTRACTION_PRESET);
    }

    @Override
    public void onActionActivate(PipeEventActionActivate event) {
        super.onActionActivate(event);
        if (event.action instanceof ActionExtractionPreset) {
            ActionExtractionPreset preset = (ActionExtractionPreset)event.action;
            this.activeSlots.add(preset.index);
            this.activatedTtl[preset.index.ordinal()] = 2;
        }
    }

    public static enum SlotIndex {
        SQUARE(EnumDyeColor.RED),
        CIRCLE(EnumDyeColor.GREEN),
        TRIANGLE(EnumDyeColor.BLUE),
        CROSS(EnumDyeColor.YELLOW);

        public static final SlotIndex[] VALUES;
        public final EnumDyeColor colour;

        private SlotIndex(EnumDyeColor colour) {
            this.colour = colour;
        }

        public SlotIndex next() {
            switch (this) {
                case SQUARE: {
                    return CIRCLE;
                }
                case CIRCLE: {
                    return TRIANGLE;
                }
                case TRIANGLE: {
                    return CROSS;
                }
                case CROSS: {
                    return SQUARE;
                }
            }
            throw new IllegalStateException("Unknown SlotIndex - " + (Object)((Object)this) + " - " + this.ordinal());
        }

        static {
            VALUES = SlotIndex.values();
        }
    }
}

