/*
 * Decompiled with CFR 0.152.
 */
package buildcraft.transport.pipe.behaviour;

import buildcraft.api.transport.pipe.IPipe;
import buildcraft.api.transport.pipe.PipeBehaviour;
import buildcraft.transport.pipe.behaviour.PipeBehaviourDirectional;
import buildcraft.transport.pipe.flow.PipeFlowPower;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class PipeBehaviourWoodPower
extends PipeBehaviourDirectional {
    public PipeBehaviourWoodPower(IPipe pipe) {
        super(pipe);
    }

    public PipeBehaviourWoodPower(IPipe pipe, NBTTagCompound nbt) {
        super(pipe, nbt);
    }

    @Override
    protected boolean canFaceDirection(EnumFacing dir) {
        return dir != null && this.pipe.getConnectedType(dir) == IPipe.ConnectedType.TILE;
    }

    @Override
    public boolean canConnect(EnumFacing face, PipeBehaviour other) {
        return !(other instanceof PipeBehaviourWoodPower) && other.pipe.getFlow() instanceof PipeFlowPower;
    }

    @Override
    public boolean canConnect(EnumFacing face, TileEntity other) {
        return other.hasCapability(CapabilityEnergy.ENERGY, face.func_176734_d());
    }

    @Override
    public int getTextureIndex(EnumFacing face) {
        if (face == null) {
            return 0;
        }
        if (this.pipe.getConnectedPipe(face) != null) {
            return 0;
        }
        TileEntity tile = this.pipe.getConnectedTile(face);
        if (tile == null) {
            return 0;
        }
        IEnergyStorage recv = (IEnergyStorage)tile.getCapability(CapabilityEnergy.ENERGY, face.func_176734_d());
        return recv == null ? 1 : (recv.canExtract() ? 0 : 1);
    }
}

