/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.asm.util;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import org.objectweb.asm.Attribute;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.Handle;
import org.objectweb.asm.Label;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.util.Printer;
import org.objectweb.asm.util.Textifier;
import org.objectweb.asm.util.TraceClassVisitor;

public class ASMHelper {
    private static final String HEXES = "0123456789ABCDEF";

    public static String getContentForMethod(ClassReader classReader, String methodName, boolean newLine) {
        return ASMHelper.getContentForMethod(classReader, methodName, "", newLine);
    }

    public static String getContentForMethod(ClassReader classReader, String methodName, String desc, boolean newLine) {
        StringWriter stringWriter = new StringWriter();
        PrintWriter printWriter = new PrintWriter(stringWriter);
        TraceClassVisitor traceClassVisitor = new TraceClassVisitor(null, (Printer)new MethodTextifier(), printWriter);
        FilterClassVisitor myClassVisitor = new FilterClassVisitor(traceClassVisitor, methodName, desc);
        classReader.accept((ClassVisitor)myClassVisitor, 2);
        BufferedReader reader = new BufferedReader(new StringReader(stringWriter.toString()));
        StringBuilder builder = new StringBuilder();
        try {
            String line;
            while ((line = reader.readLine()) != null) {
                String oldLine = line = line.trim();
                line = line + " ";
                while (!oldLine.equals(line)) {
                    oldLine = line;
                    line = line.trim();
                    line = line.replace("\t", " ");
                    line = line.replace("  ", " ");
                }
                builder.append(" ");
                builder.append(line);
                if (!newLine) continue;
                builder.append(System.lineSeparator());
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return builder.toString();
    }

    public static String getCheckSumForMethod(ClassReader classReader, String methodName) {
        return ASMHelper.getCheckSumForMethod(classReader, methodName, "");
    }

    public static String getCheckSumForMethod(ClassReader classReader, String methodName, String desc) {
        String result2 = ASMHelper.getContentForMethod(classReader, methodName, desc, false);
        if (result2.isEmpty()) {
            throw new NoSuchMethodError();
        }
        return ASMHelper.toSHA1(result2.getBytes());
    }

    public static String toSHA1(byte[] convertme) {
        MessageDigest md = null;
        try {
            md = MessageDigest.getInstance("SHA-1");
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return ASMHelper.getHex(md.digest(convertme));
    }

    private static String getHex(byte[] raw) {
        if (raw == null) {
            return null;
        }
        StringBuilder hex = new StringBuilder(2 * raw.length);
        for (byte b : raw) {
            hex.append(HEXES.charAt((b & 0xF0) >> 4)).append(HEXES.charAt(b & 0xF));
        }
        return hex.toString();
    }

    private static class MethodTextifier
    extends Printer {
        public MethodTextifier() {
            super(262144);
        }

        public void visit(int version, int access, String name, String signature, String superName, String[] interfaces) {
        }

        public void visitSource(String file, String debug) {
        }

        public void visitOuterClass(String owner, String name, String desc) {
        }

        public Textifier visitClassAnnotation(String desc, boolean visible) {
            return new Textifier();
        }

        public void visitClassAttribute(Attribute attr) {
        }

        public void visitInnerClass(String name, String outerName, String innerName, int access) {
        }

        public Textifier visitField(int access, String name, String desc, String signature, Object value) {
            return new Textifier();
        }

        public Textifier visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            Textifier t = new Textifier();
            this.text.add(t.getText());
            return t;
        }

        public void visitClassEnd() {
        }

        public void visit(String name, Object value) {
        }

        public void visitEnum(String name, String desc, String value) {
        }

        public Textifier visitAnnotation(String name, String desc) {
            return new Textifier();
        }

        public Textifier visitArray(String name) {
            return new Textifier();
        }

        public void visitAnnotationEnd() {
        }

        public Textifier visitFieldAnnotation(String desc, boolean visible) {
            return new Textifier();
        }

        public void visitFieldAttribute(Attribute attr) {
            this.visitAttribute(attr);
        }

        public void visitFieldEnd() {
        }

        public Textifier visitAnnotationDefault() {
            return new Textifier();
        }

        public Textifier visitMethodAnnotation(String desc, boolean visible) {
            return new Textifier();
        }

        public Textifier visitParameterAnnotation(int parameter, String desc, boolean visible) {
            return new Textifier();
        }

        public void visitMethodAttribute(Attribute attr) {
        }

        public void visitCode() {
        }

        public void visitFrame(int type, int nLocal, Object[] local, int nStack, Object[] stack) {
        }

        public void visitInsn(int opcode) {
        }

        public void visitIntInsn(int opcode, int operand) {
        }

        public void visitVarInsn(int opcode, int var) {
        }

        public void visitTypeInsn(int opcode, String type) {
        }

        public void visitFieldInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitMethodInsn(int opcode, String owner, String name, String desc) {
        }

        public void visitInvokeDynamicInsn(String name, String desc, Handle bsm, Object ... bsmArgs) {
        }

        public void visitJumpInsn(int opcode, Label label) {
        }

        public void visitLabel(Label label) {
        }

        public void visitLdcInsn(Object cst) {
        }

        public void visitIincInsn(int var, int increment) {
        }

        public void visitTableSwitchInsn(int min, int max, Label dflt, Label ... labels) {
        }

        public void visitLookupSwitchInsn(Label dflt, int[] keys2, Label[] labels) {
        }

        public void visitMultiANewArrayInsn(String desc, int dims) {
        }

        public void visitTryCatchBlock(Label start, Label end, Label handler, String type) {
        }

        public void visitLocalVariable(String name, String desc, String signature, Label start, Label end, int index) {
        }

        public void visitLineNumber(int line, Label start) {
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }

        public void visitMethodEnd() {
        }

        public void visitAttribute(Attribute attr) {
        }
    }

    private static class FilterMaxVisitMethodVisitor
    extends MethodVisitor {
        public FilterMaxVisitMethodVisitor(MethodVisitor mv) {
            super(262144, mv);
        }

        public void visitMaxs(int maxStack, int maxLocals) {
        }
    }

    private static class FilterClassVisitor
    extends ClassVisitor {
        private final String methodName;
        private final String methodDesc;

        public FilterClassVisitor(TraceClassVisitor traceClassVisitor, String methodName, String desc) {
            super(262144, (ClassVisitor)traceClassVisitor);
            this.methodName = methodName;
            this.methodDesc = desc;
        }

        public MethodVisitor visitMethod(int access, String name, String desc, String signature, String[] exceptions) {
            if (this.methodName.equals(name) && (this.methodDesc.isEmpty() || this.methodDesc.equals(desc))) {
                return new FilterMaxVisitMethodVisitor(super.visitMethod(access, name, desc, signature, exceptions));
            }
            return null;
        }
    }
}

