/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.commands.abstracts;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import logisticspipes.commands.abstracts.ICommandHandler;
import logisticspipes.commands.chathelper.MorePageDisplay;
import logisticspipes.commands.exception.CommandNotFoundException;
import logisticspipes.commands.exception.DuplicatedCommandException;
import logisticspipes.commands.exception.MissingArgumentException;
import logisticspipes.commands.exception.PermissionDeniedException;
import logisticspipes.utils.string.ChatColor;
import net.minecraft.command.ICommandSender;

public abstract class SubCommandHandler
implements ICommandHandler {
    private final List<ICommandHandler> subCommands = new ArrayList<ICommandHandler>();

    public SubCommandHandler() {
        this.registerSubCommands();
    }

    public abstract void registerSubCommands();

    protected final void registerSubCommand(ICommandHandler newHandler) {
        List<String> newCommands = Arrays.asList(newHandler.getNames());
        for (ICommandHandler handler : this.subCommands) {
            for (String command2 : handler.getNames()) {
                if (!newCommands.contains(command2)) continue;
                throw new DuplicatedCommandException();
            }
        }
        this.subCommands.add(newHandler);
    }

    public final void displayHelp(ICommandSender sender) {
        MorePageDisplay display = new MorePageDisplay(new String[]{"|< Help - " + this.getNames()[0] + " - Page: %/$ >|"}, sender);
        for (ICommandHandler command2 : this.subCommands) {
            if (command2.getDescription()[0].startsWith("#")) continue;
            boolean first2 = true;
            String prefix = (Object)((Object)(command2 instanceof SubCommandHandler ? ChatColor.BLUE : ChatColor.YELLOW)) + command2.getNames()[0] + (Object)((Object)ChatColor.RESET) + ": ";
            for (int d = 0; d < command2.getDescription().length; ++d) {
                display.append(prefix + command2.getDescription()[d], !first2);
                prefix = "    ";
                first2 = false;
            }
            if (command2 instanceof SubCommandHandler) {
                display.append("      " + (Object)((Object)ChatColor.GRAY) + "- add " + (Object)((Object)ChatColor.YELLOW) + "help" + (Object)((Object)ChatColor.GRAY) + " to see the subcommands", true);
            }
            first2 = true;
            if (command2.getNames().length > 1) {
                for (int i = 1; i < command2.getNames().length; ++i) {
                    display.append((first2 ? "  alias: - " : "         - ") + (Object)((Object)ChatColor.GOLD) + command2.getNames()[i] + "", true);
                    first2 = false;
                }
            }
            display.append("", true);
        }
        display.display(sender);
    }

    @Override
    public final void executeCommand(ICommandSender sender, String[] args2) {
        if (args2.length < 1) {
            throw new MissingArgumentException();
        }
        String command2 = args2[0];
        if (command2.equalsIgnoreCase("help")) {
            this.displayHelp(sender);
            return;
        }
        for (ICommandHandler handler : this.subCommands) {
            if (!Arrays.asList(handler.getNames()).contains(command2)) continue;
            if (!handler.isCommandUsableBy(sender)) {
                throw new PermissionDeniedException();
            }
            String[] newArgs = Arrays.copyOfRange(args2, 1, args2.length);
            handler.executeCommand(sender, newArgs);
            return;
        }
        throw new CommandNotFoundException();
    }
}

