/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import logisticspipes.interfaces.IGUIChannelInformationReceiver;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.pipe.InvSysConContentRequest;
import logisticspipes.network.packets.pipe.InvSysConOpenSelectChannelPopupPacket;
import logisticspipes.network.packets.pipe.InvSysConResistance;
import logisticspipes.pipes.PipeItemsInvSysConnector;
import logisticspipes.proxy.MainProxy;
import logisticspipes.routing.channels.ChannelInformation;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.InputBar;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.item.ItemStackRenderer;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import network.rs485.logisticspipes.util.TextUtil;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;
import org.lwjgl.opengl.GL11;

public class GuiInvSysConnector
extends LogisticsBaseGuiScreen
implements IGUIChannelInformationReceiver {
    private static final String PREFIX = "gui.invsyscon.";
    private int page = 0;
    private final List<ItemIdentifierStack> _allItems = new ArrayList<ItemIdentifierStack>();
    private final PipeItemsInvSysConnector pipe;
    private InputBar resistanceCountBar;
    private ChannelInformation connectedChannel = null;

    public GuiInvSysConnector(EntityPlayer player, PipeItemsInvSysConnector pipe) {
        super(180, 220, 0, 0);
        DummyContainer dummy = new DummyContainer((IInventory)player.field_71071_by, null);
        dummy.addNormalSlotsForPlayerInventory(10, 135);
        this.field_147002_h = dummy;
        this.pipe = pipe;
    }

    @Override
    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new SmallGuiButton(0, this.field_147003_i + 120, this.field_147009_r + 67, 10, 10, "<"));
        this.field_146292_n.add(new SmallGuiButton(1, this.field_147003_i + 160, this.field_147009_r + 67, 10, 10, ">"));
        this.field_146292_n.add(new SmallGuiButton(2, this.field_147003_i + 68, this.field_147009_r + 67, 46, 10, TextUtil.translate("gui.invsyscon.Refresh", new String[0])));
        this.field_146292_n.add(new SmallGuiButton(3, this.field_147003_i + 80, this.field_147009_r + 55, 10, 10, "<"));
        this.field_146292_n.add(new SmallGuiButton(4, this.field_147003_i + 120, this.field_147009_r + 55, 10, 10, ">"));
        this.field_146292_n.add(new SmallGuiButton(5, this.field_147003_i + 140, this.field_147009_r + 55, 30, 10, TextUtil.translate("gui.invsyscon.Save", new String[0])));
        this.field_146292_n.add(new SmallGuiButton(6, this.field_147003_i + 130, this.field_147009_r + 20, 40, 10, TextUtil.translate("gui.invsyscon.Change", new String[0])));
        if (this.resistanceCountBar == null) {
            this.resistanceCountBar = new InputBar(this.field_146289_q, this, this.field_147003_i + 90, this.field_147009_r + 55, 30, 12, false, true, InputBar.Align.CENTER);
            this.resistanceCountBar.minNumber = 0;
            this.resistanceCountBar.setInteger(this.pipe.resistance);
        }
        this.resistanceCountBar.reposition(this.field_147003_i + 90, this.field_147009_r + 55, 30, 12);
        this.refreshPacket();
    }

    @Override
    public void closeGui() throws IOException {
        super.closeGui();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i, this.field_147009_r, this.right, this.bottom, this.field_73735_i, true);
        GuiGraphics.drawPlayerInventoryBackground(this.field_146297_k, this.field_147003_i + 10, this.field_147009_r + 135);
        this.field_146297_k.field_71466_p.func_78276_b(TextUtil.translate("gui.invsyscon.InventorySystemConnector", new String[0]), this.field_147003_i + 5, this.field_147009_r + 6, 0x404040);
        this.drawRect(this.field_147003_i + 9, this.field_147009_r + 78, this.field_147003_i + 170, this.field_147009_r + 132, Color.GREY);
        this.field_146297_k.field_71466_p.func_78276_b(TextUtil.translate("gui.invsyscon.ConnectionInformation", new String[0]) + ":", this.field_147003_i + 10, this.field_147009_r + 21, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(TextUtil.getTrimmedString(TextUtil.translate("gui.invsyscon.Channel", new String[0]) + ": " + (this.connectedChannel != null ? this.connectedChannel.getName() : "UNDEFINED"), 150, this.field_146289_q, "..."), this.field_147003_i + 15, this.field_147009_r + 38, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(TextUtil.translate("gui.invsyscon.Waitingfor", new String[0]) + ":", this.field_147003_i + 10, this.field_147009_r + 68, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(this.page + 1 + "/" + this.maxPage(), this.field_147003_i + 136, this.field_147009_r + 69, 0x404040);
        this.field_146297_k.field_71466_p.func_78276_b(TextUtil.translate("gui.invsyscon.Resistance", new String[0]) + ":", this.field_147003_i + 10, this.field_147009_r + 55, 0x404040);
        this.resistanceCountBar.func_146194_f();
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        ItemStackRenderer.renderItemIdentifierStackListIntoGui(this._allItems, null, this.page, 9, 79, 9, 27, 18, 18, 100.0f, ItemStackRenderer.DisplayAmount.ALWAYS);
        int ppi = 0;
        int column = 0;
        int row = 0;
        for (ItemIdentifierStack itemStack : this._allItems) {
            if (++ppi <= 27 * this.page || ppi > 27 * (this.page + 1)) continue;
            ItemStack st = itemStack.unsafeMakeNormalStack();
            int x = 9 + 18 * column + this.field_147003_i;
            int y = 79 + 18 * row + this.field_147009_r;
            GL11.glDisable((int)2896);
            int mouseX = Mouse.getX() * this.field_146294_l / this.field_146297_k.field_71443_c;
            int mouseY = this.field_146295_m - Mouse.getY() * this.field_146295_m / this.field_146297_k.field_71440_d - 1;
            if (x < mouseX && mouseX < x + 18 && y < mouseY && mouseY < y + 18) {
                GuiGraphics.displayItemToolTip(new Object[]{mouseX, mouseY, st, true}, this.field_73735_i, this.field_147003_i, this.field_147009_r, false);
            }
            if (++column < 9) continue;
            ++row;
            column = 0;
        }
    }

    private void refreshPacket() {
        MainProxy.sendPacketToServer(PacketHandler.getPacket(InvSysConContentRequest.class).setPosX(this.pipe.getX()).setPosY(this.pipe.getY()).setPosZ(this.pipe.getZ()));
    }

    private void pageDown() {
        this.page = this.page <= 0 ? this.maxPage() - 1 : --this.page;
    }

    private void pageUp() {
        this.page = this.page >= this.maxPage() - 1 ? 0 : ++this.page;
    }

    private int maxPage() {
        int i = (int)(Math.floor((float)this._allItems.size() / 27.0f) + (double)((float)this._allItems.size() % 27.0f != 0.0f ? 1 : 0));
        if (i <= 0) {
            i = 1;
        }
        return i;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        if (button.field_146127_k == 0) {
            this.pageDown();
        } else if (button.field_146127_k == 1) {
            this.pageUp();
        } else if (button.field_146127_k == 2) {
            this.refreshPacket();
        } else if (button.field_146127_k == 3) {
            this.resistanceCountBar.setInteger(this.resistanceCountBar.getInteger() - (Keyboard.isKeyDown((int)29) ? 10 : 1));
        } else if (button.field_146127_k == 4) {
            this.resistanceCountBar.setInteger(this.resistanceCountBar.getInteger() + 1);
        } else if (button.field_146127_k == 5) {
            this.pipe.resistance = this.resistanceCountBar.getInteger();
            MainProxy.sendPacketToServer(PacketHandler.getPacket(InvSysConResistance.class).setInteger(this.pipe.resistance).setPosX(this.pipe.getX()).setPosY(this.pipe.getY()).setPosZ(this.pipe.getZ()));
        } else if (button.field_146127_k == 6) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(InvSysConOpenSelectChannelPopupPacket.class).setTilePos(this.pipe.container));
        }
    }

    @Override
    protected void func_73864_a(int x, int y, int k) throws IOException {
        if (!this.resistanceCountBar.handleClick(x, y, k)) {
            super.func_73864_a(x, y, k);
        }
    }

    public void func_73869_a(char c, int i) throws IOException {
        if (!this.resistanceCountBar.handleKey(c, i)) {
            super.func_73869_a(c, i);
        }
    }

    public void handleContentAnswer(Collection<ItemIdentifierStack> allItems) {
        this._allItems.clear();
        this._allItems.addAll(allItems);
    }

    public void handleResistanceAnswer(int resistance) {
        this.resistanceCountBar.setInteger(resistance);
    }

    @Override
    public void handleChannelInformation(ChannelInformation channel, boolean flag) {
        if (this.getSubGui() instanceof IGUIChannelInformationReceiver) {
            ((IGUIChannelInformationReceiver)((Object)this.getSubGui())).handleChannelInformation(channel, flag);
        }
        if (flag) {
            this.connectedChannel = channel;
        } else if (this.connectedChannel != null && this.connectedChannel.getChannelIdentifier().equals(channel.getChannelIdentifier())) {
            this.connectedChannel = channel;
        }
    }
}

