/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui;

import java.io.IOException;
import java.util.Comparator;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import logisticspipes.LPItems;
import logisticspipes.blocks.LogisticsProgramCompilerTileEntity;
import logisticspipes.items.ItemLogisticsPipe;
import logisticspipes.items.ItemModule;
import logisticspipes.items.ItemUpgrade;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.block.CompilerTriggerTaskPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.InputBar;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.gui.TextListDisplay;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.util.TextUtil;
import org.lwjgl.input.Keyboard;
import org.lwjgl.input.Mouse;

public class GuiProgramCompiler
extends LogisticsBaseGuiScreen {
    private final LogisticsProgramCompilerTileEntity compiler;
    private final TextListDisplay.List categoryTextList;
    private final TextListDisplay.List programTextList;
    private final TextListDisplay categoryList;
    private final TextListDisplay programList;
    private final TextListDisplay programListLarge;
    private SmallGuiButton programmerButton;
    private InputBar search;

    public GuiProgramCompiler(EntityPlayer player, final LogisticsProgramCompilerTileEntity compiler) {
        super(180, 190, 0, 0);
        this.compiler = compiler;
        DummyContainer dummy = new DummyContainer((IInventory)player.field_71071_by, compiler.getInventory());
        dummy.addRestrictedSlot(0, (IInventory)compiler.getInventory(), 10, 10, LPItems.disk);
        dummy.addRestrictedSlot(1, (IInventory)compiler.getInventory(), 154, 10, LPItems.logisticsProgrammer);
        dummy.addNormalSlotsForPlayerInventory(10, 105);
        this.categoryTextList = new TextListDisplay.List(){

            @Override
            public int getSize() {
                if (compiler.getInventory().func_70301_a(0).func_190926_b()) {
                    return 0;
                }
                NBTTagList list = compiler.getNBTTagListForKey("compilerCategories");
                return (int)LogisticsProgramCompilerTileEntity.programByCategory.keySet().stream().filter(it -> StreamSupport.stream(list.spliterator(), false).noneMatch(nbtBase -> ((NBTTagString)nbtBase).func_150285_a_().equals(it.toString()))).count();
            }

            @Override
            public String getTextAt(int index) {
                if (compiler.getInventory().func_70301_a(0).func_190926_b()) {
                    return "";
                }
                NBTTagList list = compiler.getNBTTagListForKey("compilerCategories");
                return TextUtil.translate("gui.compiler." + (String)LogisticsProgramCompilerTileEntity.programByCategory.keySet().stream().filter(it -> StreamSupport.stream(list.spliterator(), false).noneMatch(nbtBase -> ((NBTTagString)nbtBase).func_150285_a_().equals(it.toString()))).skip(index).findFirst().map(it -> String.format("%s.%s", it.func_110624_b(), it.func_110623_a())).orElse(null), new String[0]);
            }

            @Override
            public int getTextColor(int index) {
                return 0xFFFFFF;
            }
        };
        this.categoryList = new TextListDisplay(this, 8, 30, 110, 104, 5, this.categoryTextList);
        this.programTextList = new TextListDisplay.List(){

            @Override
            public int getSize() {
                if (compiler.getInventory().func_70301_a(0).func_190926_b()) {
                    return 0;
                }
                NBTTagList list = compiler.getNBTTagListForKey("compilerCategories");
                return GuiProgramCompiler.this.getProgramListForSelectionIndex(list).size();
            }

            @Override
            public String getTextAt(int index) {
                if (compiler.getInventory().func_70301_a(0).func_190926_b()) {
                    return "";
                }
                NBTTagList list = compiler.getNBTTagListForKey("compilerCategories");
                ResourceLocation sel = (ResourceLocation)GuiProgramCompiler.this.getProgramListForSelectionIndex(list).get(index);
                Item selItem = (Item)Item.field_150901_e.func_82594_a((Object)sel);
                if (selItem != null) {
                    return TextUtil.translate(selItem.func_77658_a() + ".name", new String[0]);
                }
                return "UNDEFINED";
            }

            @Override
            public int getTextColor(int index) {
                if (compiler.getInventory().func_70301_a(0).func_190926_b()) {
                    return 0xFFFFFF;
                }
                NBTTagList list = compiler.getNBTTagListForKey("compilerCategories");
                ResourceLocation sel = (ResourceLocation)GuiProgramCompiler.this.getProgramListForSelectionIndex(list).get(index);
                NBTTagList listPrograms = compiler.getNBTTagListForKey("compilerPrograms");
                return StreamSupport.stream(listPrograms.spliterator(), false).anyMatch(it -> new ResourceLocation(((NBTTagString)it).func_150285_a_()).equals((Object)sel)) ? 0xAAFFAA : 0xFFAAAA;
            }
        };
        this.programList = new TextListDisplay(this, 80, 30, 8, 104, 5, this.programTextList);
        this.programListLarge = new TextListDisplay(this, 8, 30, 8, 104, 5, this.programTextList);
        this.field_147002_h = dummy;
    }

    @Override
    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new SmallGuiButton(0, this.field_147003_i + 8, this.field_147009_r + 90, 15, 10, "/\\"));
        this.field_146292_n.add(new SmallGuiButton(1, this.field_147003_i + 24, this.field_147009_r + 90, 15, 10, "\\/"));
        this.field_146292_n.add(new SmallGuiButton(2, this.field_147003_i + 40, this.field_147009_r + 90, 40, 10, "Unlock"));
        this.field_146292_n.add(new SmallGuiButton(3, this.field_147003_i + 100, this.field_147009_r + 90, 15, 10, "/\\"));
        this.field_146292_n.add(new SmallGuiButton(4, this.field_147003_i + 116, this.field_147009_r + 90, 15, 10, "\\/"));
        this.programmerButton = new SmallGuiButton(5, this.field_147003_i + 132, this.field_147009_r + 90, 40, 10, "Compile");
        this.field_146292_n.add(this.programmerButton);
        this.search = new InputBar(this.field_146289_q, this, this.field_147003_i + 30, this.field_147009_r + 11, 120, 16);
    }

    @Override
    public void closeGui() throws IOException {
        super.closeGui();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        super.func_146284_a(button);
        switch (button.field_146127_k) {
            case 0: {
                this.categoryList.scrollDown();
                break;
            }
            case 1: {
                this.categoryList.scrollUp();
                break;
            }
            case 2: {
                if (this.categoryList.getSelected() == -1) break;
                NBTTagList list = this.compiler.getNBTTagListForKey("compilerCategories");
                LogisticsProgramCompilerTileEntity.programByCategory.keySet().stream().filter(it -> StreamSupport.stream(list.spliterator(), false).noneMatch(nbtBase -> ((NBTTagString)nbtBase).func_150285_a_().equals(it.toString()))).skip(this.categoryList.getSelected()).findFirst().ifPresent(it -> MainProxy.sendPacketToServer(PacketHandler.getPacket(CompilerTriggerTaskPacket.class).setCategory((ResourceLocation)it).setType("category").setTilePos(this.compiler)));
                break;
            }
            case 3: {
                if (this.categoryTextList.getSize() == 0 && this.programTextList.getSize() != 0) {
                    this.programListLarge.scrollDown();
                    break;
                }
                this.programList.scrollDown();
                break;
            }
            case 4: {
                if (this.categoryTextList.getSize() == 0 && this.programTextList.getSize() != 0) {
                    this.programListLarge.scrollUp();
                    break;
                }
                this.programList.scrollUp();
                break;
            }
            case 5: {
                int selIndex = this.programList.getSelected();
                if (this.categoryTextList.getSize() == 0 && this.programTextList.getSize() != 0) {
                    selIndex = this.programListLarge.getSelected();
                }
                if (selIndex == -1) break;
                NBTTagList list = this.compiler.getNBTTagListForKey("compilerCategories");
                ResourceLocation sel = this.getProgramListForSelectionIndex(list).get(selIndex);
                NBTTagList listPrograms = this.compiler.getNBTTagListForKey("compilerPrograms");
                boolean flag = StreamSupport.stream(listPrograms.spliterator(), false).anyMatch(it -> new ResourceLocation(((NBTTagString)it).func_150285_a_()).equals((Object)sel));
                MainProxy.sendPacketToServer(PacketHandler.getPacket(CompilerTriggerTaskPacket.class).setCategory(sel).setType(flag ? "flash" : "program").setTilePos(this.compiler));
            }
        }
    }

    @Override
    protected void func_146976_a(float var1, int var2, int var3) {
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i, this.field_147009_r, this.right, this.bottom, this.field_73735_i, true);
        GuiGraphics.drawPlayerInventoryBackground(this.field_146297_k, this.field_147003_i + 10, this.field_147009_r + 105);
        GuiGraphics.drawSlotDiskBackground(this.field_146297_k, this.field_147003_i + 9, this.field_147009_r + 9);
        GuiGraphics.drawSlotProgrammerBackground(this.field_146297_k, this.field_147003_i + 153, this.field_147009_r + 9);
        if (this.compiler.getCurrentTask() != null) {
            this.field_146289_q.func_78276_b(TextUtil.translate("gui.compiler.processing", new String[0]), this.field_147003_i + 10, this.field_147009_r + 39, 0);
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)this.compiler.getCurrentTask());
            String name = item != null ? item.func_77658_a() + ".name" : "gui.compiler." + this.compiler.getCurrentTask().toString().replace(':', '.');
            String text = TextUtil.getTrimmedString(TextUtil.translate(name, new String[0]), 160, this.field_146289_q, "...");
            this.field_146289_q.func_78276_b(text, this.field_147003_i + 10, this.field_147009_r + 70, 0);
            this.drawRect(this.field_147003_i + 9, this.field_147009_r + 50, this.field_147003_i + 171, this.field_147009_r + 66, Color.BLACK);
            this.drawRect(this.field_147003_i + 10, this.field_147009_r + 51, this.field_147003_i + 170, this.field_147009_r + 65, Color.WHITE);
            this.drawRect(this.field_147003_i + 11, this.field_147009_r + 52, this.field_147003_i + 11 + (int)(158.0 * this.compiler.getTaskProgress()), this.field_147009_r + 64, Color.GREEN);
            if (!this.compiler.isWasAbleToConsumePower()) {
                this.field_146289_q.func_78276_b(TextUtil.translate("gui.compiler.nopower.1", new String[0]), this.field_147003_i + 68, this.field_147009_r + 10, 0);
                this.field_146289_q.func_78276_b(TextUtil.translate("gui.compiler.nopower.2", new String[0]), this.field_147003_i + 35, this.field_147009_r + 20, 0);
            }
            this.field_146292_n.forEach(b -> {
                b.field_146125_m = false;
            });
        } else {
            this.field_146292_n.forEach(b -> {
                b.field_146125_m = true;
            });
            if (this.categoryTextList.getSize() == 0 && this.programTextList.getSize() != 0) {
                this.field_146292_n.stream().limit(3L).forEach(b -> {
                    b.field_146125_m = false;
                });
                this.programListLarge.renderGuiBackground(var2, var3);
            } else {
                this.field_146292_n.stream().limit(3L).forEach(b -> {
                    b.field_146125_m = true;
                });
                this.categoryList.renderGuiBackground(var2, var3);
                this.programList.renderGuiBackground(var2, var3);
            }
            this.search.func_146194_f();
            int selIndex = this.programList.getSelected();
            if (this.categoryTextList.getSize() == 0 && this.programTextList.getSize() != 0) {
                selIndex = this.programListLarge.getSelected();
            }
            if (selIndex != -1) {
                NBTTagList list = this.compiler.getNBTTagListForKey("compilerCategories");
                ResourceLocation sel = this.getProgramListForSelectionIndex(list).get(selIndex);
                NBTTagList listPrograms = this.compiler.getNBTTagListForKey("compilerPrograms");
                if (StreamSupport.stream(listPrograms.spliterator(), false).anyMatch(it -> new ResourceLocation(((NBTTagString)it).func_150285_a_()).equals((Object)sel))) {
                    this.programmerButton.field_146126_j = "Flash";
                    this.programmerButton.field_146124_l = !this.compiler.getInventory().func_70301_a(1).func_190926_b();
                } else {
                    this.programmerButton.field_146126_j = "Compile";
                    this.programmerButton.field_146124_l = true;
                }
            }
        }
    }

    private List<ResourceLocation> getProgramListForSelectionIndex(NBTTagList list) {
        return StreamSupport.stream(list.spliterator(), false).flatMap(nbtBase -> LogisticsProgramCompilerTileEntity.programByCategory.get(new ResourceLocation(((NBTTagString)nbtBase).func_150285_a_())).stream()).filter(it -> TextUtil.translate(((Item)Item.field_150901_e.func_82594_a(it)).func_77658_a() + ".name", new String[0]).toLowerCase().contains(this.search.func_146179_b().toLowerCase())).sorted(Comparator.comparing(o -> this.getSortingClass((Item)Item.field_150901_e.func_82594_a((Object)((ResourceLocation)o)))).thenComparing(o -> TextUtil.translate(((Item)Item.field_150901_e.func_82594_a((Object)((ResourceLocation)o))).func_77658_a() + ".name", new String[0]).toLowerCase())).collect(Collectors.toList());
    }

    private int getSortingClass(Item object) {
        if (object instanceof ItemLogisticsPipe) {
            return 0;
        }
        if (object instanceof ItemModule) {
            return 1;
        }
        if (object instanceof ItemUpgrade) {
            return 2;
        }
        return 10;
    }

    @Override
    public void handleMouseInputSub() throws IOException {
        int wheel = Mouse.getDWheel() / 120;
        if (wheel == 0) {
            super.handleMouseInputSub();
        }
        if (this.compiler.getCurrentTask() == null) {
            if (this.categoryTextList.getSize() == 0 && this.programTextList.getSize() != 0) {
                if (wheel < 0) {
                    this.programListLarge.mouseScrollUp();
                } else if (wheel > 0) {
                    this.programListLarge.mouseScrollDown();
                }
            } else if (wheel < 0) {
                this.categoryList.mouseScrollUp();
                this.programList.mouseScrollUp();
            } else if (wheel > 0) {
                this.categoryList.mouseScrollDown();
                this.programList.mouseScrollDown();
            }
        }
    }

    protected void func_73869_a(char typedChar, int keyCode) throws IOException {
        if (this.compiler.getCurrentTask() == null) {
            if (!this.search.handleKey(typedChar, keyCode)) {
                super.func_73869_a(typedChar, keyCode);
            }
        } else {
            super.func_73869_a(typedChar, keyCode);
        }
    }

    @Override
    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        super.func_73864_a(par1, par2, par3);
        if (this.compiler.getCurrentTask() == null) {
            this.search.handleClick(par1, par2, par3);
            if (this.categoryTextList.getSize() == 0 && this.programTextList.getSize() != 0) {
                this.programListLarge.mouseClicked(par1, par2, par3);
            } else {
                this.categoryList.mouseClicked(par1, par2, par3);
                this.programList.mouseClicked(par1, par2, par3);
            }
        }
    }

    @Override
    protected void func_146979_b(int par1, int par2) {
        super.func_146979_b(par1, par2);
        if (this.compiler.getCurrentTask() == null) {
            if (this.categoryTextList.getSize() == 0 && this.programTextList.getSize() != 0) {
                this.programListLarge.renderGuiForeground();
            } else {
                this.categoryList.renderGuiForeground();
                this.programList.renderGuiForeground();
            }
        }
    }
}

