/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.orderer;

import java.io.IOException;
import java.util.Collection;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import logisticspipes.config.Configs;
import logisticspipes.gui.popup.GuiRequestPopup;
import logisticspipes.interfaces.ISpecialItemRenderer;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.orderer.RequestComponentPacket;
import logisticspipes.network.packets.orderer.RequestSubmitPacket;
import logisticspipes.proxy.MainProxy;
import logisticspipes.request.resources.IResource;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.GuiCheckBox;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.IItemSearch;
import logisticspipes.utils.gui.ISubGuiControler;
import logisticspipes.utils.gui.InputBar;
import logisticspipes.utils.gui.ItemDisplay;
import logisticspipes.utils.gui.LogisticsBaseGuiScreen;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ChatAllowedCharacters;
import org.lwjgl.input.Keyboard;

public abstract class GuiOrderer
extends LogisticsBaseGuiScreen
implements IItemSearch,
ISpecialItemRenderer {
    public final EntityPlayer _entityPlayer;
    public ItemDisplay itemDisplay;
    private InputBar search;
    protected String _title = "Request items";
    public final int xCoord;
    public final int yCoord;
    public final int zCoord;
    public int dimension;
    public static int dimensioncache;
    public static long cachetime;

    public GuiOrderer(int x, int y, int z, int dim, EntityPlayer entityPlayer) {
        super(220, 240, 0, 0);
        this.xCoord = x;
        this.yCoord = y;
        this.zCoord = z;
        this.dimension = cachetime + 100L < System.currentTimeMillis() ? dim : dimensioncache;
        this._entityPlayer = entityPlayer;
        this.field_147002_h = new DummyContainer((IInventory)entityPlayer.field_71071_by, null);
    }

    public abstract void refreshItems();

    public void handlePacket(Collection<ItemIdentifierStack> allItems) {
        this.itemDisplay.setItemList(allItems.stream().filter(Objects::nonNull).collect(Collectors.toList()));
    }

    @Override
    public void func_73866_w_() {
        Keyboard.enableRepeatEvents((boolean)true);
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new GuiButton(0, this.right - 55, this.bottom - 25, 50, 20, "Request"));
        this.field_146292_n.add(new SmallGuiButton(1, this.right - 15, this.field_147009_r + 5, 10, 10, ">"));
        this.field_146292_n.add(new SmallGuiButton(2, this.right - 90, this.field_147009_r + 5, 10, 10, "<"));
        this.field_146292_n.add(new SmallGuiButton(10, this.xCenter - 51, this.bottom - 15, 26, 10, "---"));
        this.field_146292_n.add(new SmallGuiButton(4, this.xCenter - 51, this.bottom - 26, 15, 10, "--"));
        this.field_146292_n.add(new SmallGuiButton(5, this.xCenter - 35, this.bottom - 26, 10, 10, "-"));
        this.field_146292_n.add(new SmallGuiButton(6, this.xCenter + 26, this.bottom - 26, 10, 10, "+"));
        this.field_146292_n.add(new SmallGuiButton(7, this.xCenter + 38, this.bottom - 26, 15, 10, "++"));
        this.field_146292_n.add(new SmallGuiButton(11, this.xCenter + 26, this.bottom - 15, 26, 10, "+++"));
        this.field_146292_n.add(new GuiCheckBox(8, this.field_147003_i + 9, this.bottom - 60, 14, 14, Configs.DISPLAY_POPUP));
        this.field_146292_n.add(new SmallGuiButton(20, this.xCenter - 13, this.bottom - 41, 26, 10, "Sort"));
        if (this.search == null) {
            this.search = new InputBar(this.field_146289_q, this, this.field_147003_i + 10, this.bottom - 78, this.field_146999_f - 20, 15);
        }
        this.search.reposition(this.field_147003_i + 10, this.bottom - 78, this.field_146999_f - 20, 15);
        if (this.itemDisplay == null) {
            this.itemDisplay = new ItemDisplay(this, this.field_146289_q, this, this, this.field_147003_i + 10, this.field_147009_r + 18, this.field_146999_f - 20, this.field_147000_g - 100, this.xCenter, this.bottom - 24, 49, new int[]{1, 10, 64, 64}, true);
        }
        this.itemDisplay.reposition(this.field_147003_i + 10, this.field_147009_r + 18, this.field_146999_f - 20, this.field_147000_g - 100, this.xCenter, this.bottom - 24);
    }

    @Override
    public void closeGui() throws IOException {
        super.closeGui();
        Keyboard.enableRepeatEvents((boolean)false);
    }

    public boolean func_73868_f() {
        return false;
    }

    @Override
    public void func_146976_a(float f, int i, int j) {
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.field_147003_i, this.field_147009_r, this.right, this.bottom, this.field_73735_i, true);
        this.field_146297_k.field_71466_p.func_78276_b(this._title, this.field_147003_i + this.field_146297_k.field_71466_p.func_78256_a(this._title) / 2, this.field_147009_r + 6, 0x404040);
        this.itemDisplay.renderPageNumber(this.right - 47, this.field_147009_r + 6);
        if (this.field_146292_n.get(9) instanceof GuiCheckBox && ((GuiCheckBox)((Object)this.field_146292_n.get(9))).getState()) {
            this.field_146297_k.field_71466_p.func_78276_b("Popup", this.field_147003_i + 25, this.bottom - 56, 0x404040);
        } else {
            this.field_146297_k.field_71466_p.func_78276_b("Popup", this.field_147003_i + 25, this.bottom - 56, Color.getValue(Color.GREY));
        }
        this.itemDisplay.renderAmount(this.getStackAmount());
        this.search.func_146194_f();
        this.itemDisplay.renderSortMode(this.xCenter, this.bottom - 52);
        this.itemDisplay.renderItemArea(this.field_73735_i);
    }

    @Override
    public void func_146979_b(int par1, int par2) {
        if (super.hasSubGui()) {
            return;
        }
        GuiGraphics.displayItemToolTip(this.itemDisplay.getToolTip(), (Gui)this, this.field_73735_i, this.field_147003_i, this.field_147009_r);
    }

    @Override
    public boolean itemSearched(ItemIdentifier item) {
        if (this.search.isEmpty()) {
            return true;
        }
        if (this.isSearched(item.getFriendlyName().toLowerCase(Locale.US), this.search.func_146179_b().toLowerCase(Locale.US))) {
            return true;
        }
        Map enchantIdLvlMap = EnchantmentHelper.func_82781_a((ItemStack)item.unsafeMakeNormalStack(1));
        for (Map.Entry e : enchantIdLvlMap.entrySet()) {
            String enchantname = ((Enchantment)e.getKey()).func_77320_a();
            if (enchantname == null || !this.isSearched(enchantname.toLowerCase(Locale.US), this.search.func_146179_b().toLowerCase(Locale.US))) continue;
            return true;
        }
        return false;
    }

    private boolean isSearched(String value, String search) {
        boolean flag = true;
        for (String s : search.split(" ")) {
            if (value.contains(s)) continue;
            flag = false;
            break;
        }
        return flag;
    }

    @Override
    protected void func_73864_a(int i, int j, int k) throws IOException {
        this.itemDisplay.handleClick(i, j, k);
        this.search.handleClick(i, j, k);
        super.func_73864_a(i, j, k);
    }

    @Override
    public void handleMouseInputSub() throws IOException {
        this.itemDisplay.handleMouse();
        super.handleMouseInputSub();
    }

    public void handleRequestAnswer(Collection<IResource> items, boolean error, ISubGuiControler control, EntityPlayer player) {
        while (control.hasSubGui()) {
            control = control.getSubGui();
        }
        if (error) {
            control.setSubGui(new GuiRequestPopup(this._entityPlayer, "You are missing:", items));
        } else {
            control.setSubGui(new GuiRequestPopup(this._entityPlayer, "Request successful!", items));
        }
    }

    public void handleSimulateAnswer(Collection<IResource> used, Collection<IResource> missing, ISubGuiControler control, EntityPlayer player) {
        while (control.hasSubGui()) {
            control = control.getSubGui();
        }
        control.setSubGui(new GuiRequestPopup(this._entityPlayer, "Components: ", used, "Missing: ", missing));
    }

    protected void func_146284_a(GuiButton guibutton) throws IOException {
        if (guibutton.field_146127_k == 0 && this.itemDisplay.getSelectedItem() != null) {
            ItemIdentifierStack stack = this.itemDisplay.getSelectedItem().getItem().makeStack(this.itemDisplay.getRequestCount());
            MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestSubmitPacket.class).setStack(stack).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord).setDimension(this.dimension));
            this.refreshItems();
        } else if (guibutton.field_146127_k == 1) {
            this.itemDisplay.nextPage();
        } else if (guibutton.field_146127_k == 2) {
            this.itemDisplay.prevPage();
        } else if (guibutton.field_146127_k == 3) {
            this.refreshItems();
        } else if (guibutton.field_146127_k == 10) {
            this.itemDisplay.sub(3);
        } else if (guibutton.field_146127_k == 4) {
            this.itemDisplay.sub(2);
        } else if (guibutton.field_146127_k == 5) {
            this.itemDisplay.sub(1);
        } else if (guibutton.field_146127_k == 6) {
            this.itemDisplay.add(1);
        } else if (guibutton.field_146127_k == 7) {
            this.itemDisplay.add(2);
        } else if (guibutton.field_146127_k == 11) {
            this.itemDisplay.add(3);
        } else if (guibutton.field_146127_k == 8) {
            GuiCheckBox button = (GuiCheckBox)guibutton;
            Configs.DISPLAY_POPUP = button.change();
            Configs.savePopupState();
        } else if (guibutton.field_146127_k == 13 && this.itemDisplay.getSelectedItem() != null) {
            ItemIdentifierStack stack = this.itemDisplay.getSelectedItem().getItem().makeStack(this.itemDisplay.getRequestCount());
            MainProxy.sendPacketToServer(PacketHandler.getPacket(RequestComponentPacket.class).setStack(stack).setPosX(this.xCoord).setPosY(this.yCoord).setPosZ(this.zCoord).setDimension(this.dimension));
        } else if (guibutton.field_146127_k == 20) {
            this.itemDisplay.cycle();
        }
        super.func_146284_a(guibutton);
    }

    protected int getStackAmount() {
        return 64;
    }

    protected void func_73869_a(char c, int i) throws IOException {
        if (this.search.func_146206_l()) {
            if (!this.search.isEmpty() && this.search.handleKey(c, i)) {
                return;
            }
        } else if (GuiScreen.func_175283_s() && ChatAllowedCharacters.func_71566_a((char)c)) {
            this.itemDisplay.setFocused(false);
            this.search.func_146195_b(true);
            this.search.func_146180_a("");
            this.search.handleKey(c, i);
            return;
        }
        if (!(this.itemDisplay.keyTyped(c, i) || i != 1 && this.search.handleKey(c, i))) {
            super.func_73869_a(c, i);
        }
    }

    @Override
    public void resetSubGui() {
        super.resetSubGui();
        this.refreshItems();
    }
}

