/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.gui.popup;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import logisticspipes.gui.popup.SelectItemOutOfList;
import logisticspipes.network.PacketHandler;
import logisticspipes.network.packets.NEISetCraftingRecipe;
import logisticspipes.network.packets.pipe.FindMostLikelyRecipeComponents;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.Color;
import logisticspipes.utils.gui.GuiGraphics;
import logisticspipes.utils.gui.SimpleGraphics;
import logisticspipes.utils.gui.SmallGuiButton;
import logisticspipes.utils.gui.SubGuiScreen;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.NonNullList;
import network.rs485.logisticspipes.util.TextUtil;

public class GuiRecipeImport
extends SubGuiScreen {
    private final TileEntity tile;
    private final Candidates[] grid = new Candidates[9];
    private final List<Candidates> list;
    private Object[] tooltip = null;

    public GuiRecipeImport(TileEntity tile, ItemStack[][] stacks) {
        super(150, 200, 0, 0);
        this.tile = tile;
        this.list = new ArrayList<Candidates>();
        for (int i = 0; i < 9; ++i) {
            if (stacks[i] == null) continue;
            TreeSet<ItemIdentifierStack> part = new TreeSet<ItemIdentifierStack>();
            ArrayList<ItemIdentifierStack> order = new ArrayList<ItemIdentifierStack>();
            for (ItemStack stack : stacks[i]) {
                ItemIdentifierStack iStack = ItemIdentifierStack.getFromStack(stack);
                part.add(iStack);
                order.add(iStack);
            }
            Candidates candidate = new Candidates(part);
            boolean found = false;
            for (Candidates test : this.list) {
                if (!test.set.equals(part)) continue;
                candidate = test;
                found = true;
                break;
            }
            if (!found) {
                candidate.order = order;
                if (order.size() > 1) {
                    this.list.add(candidate);
                }
            }
            this.grid[i] = candidate;
        }
    }

    @Override
    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.field_146292_n.add(new SmallGuiButton(0, this.guiLeft + 100, this.guiTop + 180, 40, 10, "Done"));
        this.field_146292_n.add(new SmallGuiButton(1, this.guiLeft + 10, this.guiTop + 180, 60, 10, "Most likely"));
        int x = 0;
        int y = 0;
        for (Candidates candidate : this.list) {
            this.field_146292_n.add(new SmallGuiButton(10 + x + y * 3, this.guiLeft + 38 + x * 40, this.guiTop + 88 + y * 40, 15, 10, "/\\"));
            this.field_146292_n.add(new SmallGuiButton(20 + x + y * 3, this.guiLeft + 38 + x * 40, this.guiTop + 98 + y * 40, 15, 10, "\\/"));
            if (++x <= 2) continue;
            x = 0;
            ++y;
        }
    }

    @Override
    protected void renderToolTips(int mouseX, int mouseY, float par3) {
        GuiGraphics.displayItemToolTip(this.tooltip, (Gui)this, this.field_73735_i, this.guiLeft, this.guiTop);
    }

    @Override
    protected void drawGuiContainerForegroundLayer(int mouseX, int mouseY) {
        int y;
        int x;
        this.field_146289_q.func_175065_a(TextUtil.translate("misc.selectOreDict", new String[0]), (float)(this.guiLeft + 10), (float)(this.guiTop + 6), 0x404040, false);
        this.tooltip = null;
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 3; ++y) {
                if (this.grid[x + y * 3] == null) continue;
                ItemIdentifierStack stack = this.grid[x + y * 3].order.get(this.grid[x + y * 3].pos);
                ItemStack itemStack = stack.makeNormalStack();
                FontRenderer font = itemStack.func_77973_b().getFontRenderer(itemStack);
                if (font == null) {
                    font = this.field_146289_q;
                }
                this.field_146296_j.func_180450_b(itemStack, this.guiLeft + 45 + x * 18, this.guiTop + 20 + y * 18);
                this.field_146296_j.func_180453_a(font, itemStack, this.guiLeft + 45 + x * 18, this.guiTop + 20 + y * 18, null);
                if (this.guiLeft + 45 + x * 18 >= mouseX || mouseX >= this.guiLeft + 45 + x * 18 + 16 || this.guiTop + 20 + y * 18 >= mouseY || mouseY >= this.guiTop + 20 + y * 18 + 16 || this.hasSubGui()) continue;
                SimpleGraphics.drawGradientRect(this.guiLeft + 45 + x * 18, this.guiTop + 20 + y * 18, this.guiLeft + 45 + x * 18 + 16, this.guiTop + 20 + y * 18 + 16, Color.WHITE_50, Color.WHITE_50, 0.0);
                this.tooltip = new Object[]{this.guiLeft + mouseX, this.guiTop + mouseY, itemStack};
            }
        }
        x = 0;
        y = 0;
        for (Candidates candidate : this.list) {
            ItemIdentifierStack stack = candidate.order.get(candidate.pos);
            ItemStack itemStack = stack.makeNormalStack();
            FontRenderer font = itemStack.func_77973_b().getFontRenderer(itemStack);
            if (font == null) {
                font = this.field_146289_q;
            }
            this.field_146296_j.func_180450_b(itemStack, this.guiLeft + 20 + x * 40, this.guiTop + 90 + y * 40);
            this.field_146296_j.func_180453_a(font, itemStack, this.guiLeft + 20 + x * 40, this.guiTop + 90 + y * 40, "");
            if (this.guiLeft + 20 + x * 40 < mouseX && mouseX < this.guiLeft + 20 + x * 40 + 16 && this.guiTop + 90 + y * 40 < mouseY && mouseY < this.guiTop + 90 + y * 40 + 16 && !this.hasSubGui()) {
                SimpleGraphics.drawGradientRect(this.guiLeft + 20 + x * 40, this.guiTop + 90 + y * 40, this.guiLeft + 20 + x * 40 + 16, this.guiTop + 90 + y * 40 + 16, Color.WHITE_50, Color.WHITE_50, 0.0);
                this.tooltip = new Object[]{this.guiLeft + mouseX, this.guiTop + mouseY, itemStack};
            }
            if (++x <= 2) continue;
            x = 0;
            ++y;
        }
    }

    @Override
    protected void renderGuiBackground(int mouseX, int mouseY) {
        int y;
        int x;
        GuiGraphics.drawGuiBackGround(this.field_146297_k, this.guiLeft, this.guiTop, this.right, this.bottom, this.field_73735_i, true);
        this.field_146289_q.func_175065_a(TextUtil.translate("misc.selectOreDict", new String[0]), (float)(this.guiLeft + 10), (float)(this.guiTop + 6), 0x404040, false);
        for (x = 0; x < 3; ++x) {
            for (y = 0; y < 3; ++y) {
                GuiGraphics.drawSlotBackground(this.field_146297_k, this.guiLeft + 44 + x * 18, this.guiTop + 19 + y * 18);
            }
        }
        x = 0;
        y = 0;
        for (Candidates candidate : this.list) {
            GuiGraphics.drawSlotBackground(this.field_146297_k, this.guiLeft + 19 + x * 40, this.guiTop + 89 + y * 40);
            if (++x <= 2) continue;
            x = 0;
            ++y;
        }
    }

    protected void func_146284_a(GuiButton button) {
        int id = button.field_146127_k;
        if (id == 0) {
            NEISetCraftingRecipe packet = PacketHandler.getPacket(NEISetCraftingRecipe.class);
            NonNullList<ItemStack> stackList = packet.getStackList();
            int i = 0;
            for (Candidates candidate : this.grid) {
                if (candidate == null) {
                    ++i;
                    continue;
                }
                stackList.set(i++, (Object)candidate.order.get(candidate.pos).makeNormalStack());
            }
            MainProxy.sendPacketToServer(packet.setBlockPos(this.tile.func_174877_v()));
            this.exitGui();
        } else if (id == 1) {
            MainProxy.sendPacketToServer(PacketHandler.getPacket(FindMostLikelyRecipeComponents.class).setContent(this.list).setTilePos(this.tile));
        } else if (id >= 10 && id < 30) {
            int slot = id % 10;
            boolean up = id < 20;
            Candidates candidate = this.list.get(slot);
            if (up) {
                ++candidate.pos;
                if (candidate.pos >= candidate.order.size()) {
                    candidate.pos = 0;
                }
            } else {
                --candidate.pos;
                if (candidate.pos < 0) {
                    candidate.pos = candidate.order.size() - 1;
                }
            }
        }
    }

    public void handleProposePacket(List<Integer> response) {
        if (this.list.size() != response.size()) {
            return;
        }
        for (int slot = 0; slot < this.list.size(); ++slot) {
            Candidates candidate = this.list.get(slot);
            int newPos = response.get(slot);
            if (newPos == -1) continue;
            candidate.pos = newPos;
        }
    }

    protected void func_73864_a(int mouseX, int mouseY, int button) throws IOException {
        int x = 0;
        int y = 0;
        for (Candidates candidate : this.list) {
            if (this.guiLeft + 20 + x * 40 < mouseX && mouseX < this.guiLeft + 20 + x * 40 + 16 && this.guiTop + 90 + y * 40 < mouseY && mouseY < this.guiTop + 90 + y * 40 + 16) {
                this.setSubGui(new SelectItemOutOfList(candidate.order, slot -> {
                    candidate.pos = slot;
                }));
            }
            if (++x <= 2) continue;
            x = 0;
            ++y;
        }
        super.func_73864_a(mouseX, mouseY, button);
    }

    public static class Candidates {
        Set<ItemIdentifierStack> set;
        public List<ItemIdentifierStack> order;
        int pos = 0;

        public Candidates(Set<ItemIdentifierStack> set) {
            this.set = set;
        }
    }
}

