/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.logistics;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeSet;
import java.util.stream.Collectors;
import javax.annotation.Nullable;
import logisticspipes.LPItems;
import logisticspipes.interfaces.routing.IFluidSink;
import logisticspipes.interfaces.routing.IProvideFluids;
import logisticspipes.items.LogisticsFluidContainer;
import logisticspipes.logistics.ILogisticsFluidManager;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.FluidIdentifierStack;
import logisticspipes.utils.FluidSinkReply;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.tuples.Pair;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fluids.FluidStack;

public class LogisticsFluidManager
implements ILogisticsFluidManager {
    @Override
    @Nullable
    public Pair<Integer, FluidSinkReply> getBestReply(FluidIdentifierStack stack, IRouter sourceRouter, List<Integer> jamList) {
        Optional<Pair> bestReply = sourceRouter.getIRoutersByCost().stream().filter(it -> it.containsFlag(PipeRoutingConnectionType.canRouteTo) && it.destination.getId() != sourceRouter.getId() && !jamList.contains(it.destination.getSimpleID()) && it.destination.getPipe() instanceof IFluidSink && it.destination.getPipe().isEnabled() && !it.destination.getPipe().isOnSameContainer(sourceRouter.getPipe())).sorted().map(it -> new Pair<Integer, FluidSinkReply>(it.destination.getSimpleID(), ((IFluidSink)((Object)it.destination.getPipe())).sinkAmount(stack))).filter(pair -> pair.getValue2() != null && ((FluidSinkReply)pair.getValue2()).sinkAmount != 0L).reduce((left, right) -> ((FluidSinkReply)left.getValue2()).fixedPriority.compareTo(((FluidSinkReply)right.getValue2()).fixedPriority) < 0 ? right : left);
        bestReply.ifPresent(pair -> {
            ServerRouter serverRouter = SimpleServiceLocator.routerManager.getServerRouter((Integer)pair.getValue1());
            if (serverRouter == null) {
                return;
            }
            CoreRoutedPipe pipe = serverRouter.getPipe();
            if (pipe != null) {
                pipe.spawnParticle(Particles.BlueParticle, 10);
            }
        });
        return bestReply.orElse(null);
    }

    @Override
    public ItemIdentifierStack getFluidContainer(FluidIdentifierStack stack) {
        ItemStack item = new ItemStack((Item)LPItems.fluidContainer, 1);
        NBTTagCompound nbt = new NBTTagCompound();
        stack.makeFluidStack().writeToNBT(nbt);
        item.func_77982_d(nbt);
        return ItemIdentifierStack.getFromStack(item);
    }

    @Override
    public FluidIdentifierStack getFluidFromContainer(ItemIdentifierStack stack) {
        ItemStack itemStack = stack.makeNormalStack();
        if (itemStack.func_77973_b() instanceof LogisticsFluidContainer && stack.getItem().tag != null) {
            return FluidIdentifierStack.getFromStack(FluidStack.loadFluidStackFromNBT((NBTTagCompound)stack.getItem().tag));
        }
        return null;
    }

    @Override
    public TreeSet<FluidIdentifierStack> getAvailableFluid(List<ExitRoute> validDestinations) {
        HashMap<FluidIdentifier, Integer> allAvailableItems = new HashMap<FluidIdentifier, Integer>();
        for (ExitRoute r : validDestinations) {
            if (r == null || !r.containsFlag(PipeRoutingConnectionType.canRequestFrom) || !(r.destination.getPipe() instanceof IProvideFluids)) continue;
            IProvideFluids provider = (IProvideFluids)((Object)r.destination.getPipe());
            Map<FluidIdentifier, Integer> allItems = provider.getAvailableFluids();
            for (Map.Entry<FluidIdentifier, Integer> liquid : allItems.entrySet()) {
                Integer amount = (Integer)allAvailableItems.get(liquid.getKey());
                if (amount == null) {
                    allAvailableItems.put(liquid.getKey(), liquid.getValue());
                    continue;
                }
                long addition = (long)amount.intValue() + (long)liquid.getValue().intValue();
                if (addition > Integer.MAX_VALUE) {
                    addition = Integer.MAX_VALUE;
                }
                allAvailableItems.put(liquid.getKey(), (int)addition);
            }
        }
        return allAvailableItems.entrySet().stream().map(item -> new FluidIdentifierStack((FluidIdentifier)item.getKey(), (Integer)item.getValue())).collect(Collectors.toCollection(TreeSet::new));
    }
}

