/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis.module.inhand;

import logisticspipes.gui.GuiCraftingPipe;
import logisticspipes.items.ItemModule;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.modules.ModuleCrafter;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.network.abstractguis.ModuleInHandGuiProvider;
import logisticspipes.proxy.MainProxy;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.gui.DummyContainer;
import logisticspipes.utils.gui.DummyModuleContainer;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class CraftingModuleInHand
extends ModuleInHandGuiProvider {
    private int[] amount;
    private boolean cleanupExclude;

    public CraftingModuleInHand(int id) {
        super(id);
    }

    @Override
    public Object getClientGui(EntityPlayer player) {
        LogisticsModule module = ItemModule.getLogisticsModule(player, this.getInvSlot());
        if (!(module instanceof ModuleCrafter)) {
            return null;
        }
        return new GuiCraftingPipe(player, (ModuleCrafter)module, false, 0, this.amount, false, false, 0, this.cleanupExclude);
    }

    @Override
    public DummyContainer getContainer(EntityPlayer player) {
        DummyModuleContainer dummy = new DummyModuleContainer(player, this.getInvSlot());
        if (!(dummy.getModule() instanceof ModuleCrafter)) {
            return null;
        }
        MainProxy.sendPacketToPlayer(((ModuleCrafter)dummy.getModule()).getCPipePacket(), player);
        dummy.setInventory(((ModuleCrafter)dummy.getModule()).dummyInventory);
        dummy.addNormalSlotsForPlayerInventory(18, 97);
        for (int l = 0; l < 9; ++l) {
            dummy.addFuzzyDummySlot(l, 18 + l * 18, 18, ((ModuleCrafter)dummy.getModule()).inputFuzzy(l));
        }
        dummy.addFuzzyDummySlot(9, 90, 64, ((ModuleCrafter)dummy.getModule()).outputFuzzy());
        return dummy;
    }

    @Override
    public GuiProvider template() {
        return new CraftingModuleInHand(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeIntArray(this.amount);
        output.writeBoolean(this.cleanupExclude);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.amount = input.readIntArray();
        this.cleanupExclude = input.readBoolean();
    }

    public int[] getAmount() {
        return this.amount;
    }

    public CraftingModuleInHand setAmount(int[] amount) {
        this.amount = amount;
        return this;
    }

    public boolean isCleanupExclude() {
        return this.cleanupExclude;
    }

    public CraftingModuleInHand setCleanupExclude(boolean cleanupExclude) {
        this.cleanupExclude = cleanupExclude;
        return this;
    }
}

