/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.guis.module.inpipe;

import logisticspipes.modules.ModuleProvider;
import logisticspipes.network.abstractguis.GuiProvider;
import logisticspipes.network.abstractguis.ModuleCoordinatesGuiProvider;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import network.rs485.logisticspipes.gui.module.ProviderGui;
import network.rs485.logisticspipes.inventory.ProviderMode;
import network.rs485.logisticspipes.inventory.container.ProviderContainer;
import network.rs485.logisticspipes.property.layer.SimplePropertyOverlay;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class ProviderModuleGuiProvider
extends ModuleCoordinatesGuiProvider {
    private boolean exclude;
    private int extractorMode;
    private boolean isActive;
    private EnumFacing sneakyOrientation;

    public ProviderModuleGuiProvider(int id) {
        super(id);
    }

    @Override
    public Object getClientGui(EntityPlayer player) {
        ModuleProvider module = this.getLogisticsModule(player.func_130014_f_(), ModuleProvider.class);
        if (module == null) {
            return null;
        }
        module.isExclusionFilter.setValue(this.exclude);
        module.providerMode.setValue(ProviderMode.modeFromIntSafe(this.extractorMode));
        module.setSneakyDirection(this.sneakyOrientation);
        module.isActive.setValue(this.isActive);
        return ProviderGui.create((IInventory)player.field_71071_by, module, ItemStack.field_190927_a);
    }

    @Override
    public ProviderContainer getContainer(EntityPlayer player) {
        ModuleProvider module = this.getLogisticsModule(player.func_130014_f_(), ModuleProvider.class);
        if (module == null) {
            return null;
        }
        return new ProviderContainer(module, (IInventory)player.field_71071_by, new SimplePropertyOverlay(module.filterInventory), ItemStack.field_190927_a);
    }

    @Override
    public GuiProvider template() {
        return new ProviderModuleGuiProvider(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeBoolean(this.exclude);
        output.writeInt(this.extractorMode);
        output.writeBoolean(this.isActive);
        output.writeFacing(this.sneakyOrientation);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.exclude = input.readBoolean();
        this.extractorMode = input.readInt();
        this.isActive = input.readBoolean();
        this.sneakyOrientation = input.readFacing();
    }

    public boolean isExclude() {
        return this.exclude;
    }

    public ProviderModuleGuiProvider setExclude(boolean exclude) {
        this.exclude = exclude;
        return this;
    }

    public int getExtractorMode() {
        return this.extractorMode;
    }

    public ProviderModuleGuiProvider setExtractorMode(int extractorMode) {
        this.extractorMode = extractorMode;
        return this;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public ProviderModuleGuiProvider setActive(boolean isActive) {
        this.isActive = isActive;
        return this;
    }

    public EnumFacing getSneakyOrientation() {
        return this.sneakyOrientation;
    }

    public ProviderModuleGuiProvider setSneakyOrientation(EnumFacing sneakyOrientation) {
        this.sneakyOrientation = sneakyOrientation;
        return this;
    }
}

