/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.block;

import logisticspipes.blocks.crafting.LogisticsCraftingTableTileEntity;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.pipes.PipeBlockRequestTable;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.utils.StaticResolve;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.tileentity.TileEntity;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class CraftingSetType
extends CoordinatesPacket {
    private ItemIdentifier targetType;

    public CraftingSetType(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        TileEntity table = this.getTileAs(player.func_130014_f_(), TileEntity.class);
        if (table instanceof LogisticsCraftingTableTileEntity) {
            ((LogisticsCraftingTableTileEntity)table).targetType = this.targetType;
            ((LogisticsCraftingTableTileEntity)table).cacheRecipe();
        } else if (table instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)table).pipe instanceof PipeBlockRequestTable) {
            ((PipeBlockRequestTable)((LogisticsTileGenericPipe)table).pipe).targetType = this.targetType;
            ((PipeBlockRequestTable)((LogisticsTileGenericPipe)table).pipe).cacheRecipe();
        }
    }

    @Override
    public ModernPacket template() {
        return new CraftingSetType(this.getId());
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeItemIdentifier(this.targetType);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.targetType = input.readItemIdentifier();
    }

    public ItemIdentifier getTargetType() {
        return this.targetType;
    }

    public CraftingSetType setTargetType(ItemIdentifier targetType) {
        this.targetType = targetType;
        return this;
    }
}

