/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.block;

import java.util.UUID;
import logisticspipes.blocks.LogisticsSecurityTileEntity;
import logisticspipes.network.abstractpackets.CoordinatesPacket;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class SecurityStationId
extends CoordinatesPacket {
    private UUID uuid;

    public SecurityStationId(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new SecurityStationId(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        LogisticsSecurityTileEntity tile = this.getTileAs(player.field_70170_p, LogisticsSecurityTileEntity.class);
        if (tile != null) {
            tile.setClientUUID(this.getUuid());
        }
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        output.writeLong(this.uuid.getMostSignificantBits());
        output.writeLong(this.uuid.getLeastSignificantBits());
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.uuid = new UUID(input.readLong(), input.readLong());
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public SecurityStationId setUuid(UUID uuid) {
        this.uuid = uuid;
        return this;
    }
}

