/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.network.packets.hud;

import logisticspipes.LPItems;
import logisticspipes.hud.HUDConfig;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class HUDSettingsPacket
extends ModernPacket {
    private int buttonId;
    private boolean state;
    private int slot;

    public HUDSettingsPacket(int id) {
        super(id);
    }

    @Override
    public ModernPacket template() {
        return new HUDSettingsPacket(this.getId());
    }

    @Override
    public void processPacket(EntityPlayer player) {
        ItemStack equipment = player.field_71071_by.func_70301_a(this.slot);
        if (equipment.func_77973_b() != LPItems.hudGlasses) {
            return;
        }
        HUDConfig config = new HUDConfig(equipment);
        switch (this.buttonId) {
            case 0: {
                config.setChassisHUD(this.state);
                if (config.isChassisHUD()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.hud.config.chassie.enabled", new Object[0]));
                    break;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.hud.config.chassie.disabled", new Object[0]));
                break;
            }
            case 1: {
                config.setHUDCrafting(this.state);
                if (config.isHUDCrafting()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.hud.config.crafting.enabled", new Object[0]));
                    break;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.hud.config.crafting.disabled", new Object[0]));
                break;
            }
            case 2: {
                config.setHUDInvSysCon(this.state);
                if (config.isHUDInvSysCon()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.hud.config.invsyscon.enabled", new Object[0]));
                    break;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.hud.config.invsyscon.disabled", new Object[0]));
                break;
            }
            case 3: {
                config.setHUDPowerJunction(this.state);
                if (config.isHUDPowerLevel()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.hud.config.powerjunction.enabled", new Object[0]));
                    break;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.hud.config.powerjunction.disabled", new Object[0]));
                break;
            }
            case 4: {
                config.setHUDProvider(this.state);
                if (config.isHUDProvider()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.hud.config.provider.enabled", new Object[0]));
                    break;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.hud.config.provider.disabled", new Object[0]));
                break;
            }
            case 5: {
                config.setHUDSatellite(this.state);
                if (config.isHUDSatellite()) {
                    player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.hud.config.satellite.enabled", new Object[0]));
                    break;
                }
                player.func_145747_a((ITextComponent)new TextComponentTranslation("lp.hud.config.satellite.disabled", new Object[0]));
            }
        }
        if (player.field_71069_bz != null) {
            player.field_71069_bz.func_75142_b();
        }
    }

    @Override
    public void readData(LPDataInput input) {
        this.buttonId = input.readInt();
        this.state = input.readBoolean();
        this.slot = input.readInt();
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeInt(this.buttonId);
        output.writeBoolean(this.state);
        output.writeInt(this.slot);
    }

    public int getButtonId() {
        return this.buttonId;
    }

    public HUDSettingsPacket setButtonId(int buttonId) {
        this.buttonId = buttonId;
        return this;
    }

    public boolean isState() {
        return this.state;
    }

    public HUDSettingsPacket setState(boolean state) {
        this.state = state;
        return this;
    }

    public int getSlot() {
        return this.slot;
    }

    public HUDSettingsPacket setSlot(int slot) {
        this.slot = slot;
        return this;
    }
}

