/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes;

import logisticspipes.interfaces.ITankUtil;
import logisticspipes.pipes.PipeFluidInsertion;
import logisticspipes.pipes.PipeFluidUtil;
import logisticspipes.textures.Textures;
import logisticspipes.transport.PipeFluidTransportLogistics;
import logisticspipes.utils.FluidIdentifierStack;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.fluids.FluidStack;
import network.rs485.logisticspipes.connection.NeighborTileEntity;

public class PipeFluidExtractor
extends PipeFluidInsertion {
    private int[] liquidToExtract = new int[6];
    private static final int flowRate = 500;
    private static final int energyPerFlow = 5;

    public PipeFluidExtractor(Item item) {
        super(item);
    }

    @Override
    public void enabledUpdateEntity() {
        super.enabledUpdateEntity();
        if (!this.isNthTick(10)) {
            return;
        }
        PipeFluidUtil.INSTANCE.getAdjacentTanks(this, false).forEach(tankData -> this.extractFrom((ITankUtil)tankData.getValue2(), ((NeighborTileEntity)tankData.getValue1()).getDirection()));
    }

    private void extractFrom(ITankUtil container, EnumFacing side) {
        int sideID = side.ordinal();
        FluidStack contained = ((PipeFluidTransportLogistics)this.transport).getTankProperties(side)[0].getContents();
        int amountMissing = ((PipeFluidTransportLogistics)this.transport).getSideCapacity() - (contained != null ? contained.amount : 0);
        if (this.liquidToExtract[sideID] < Math.min(500, amountMissing) && this.useEnergy(5)) {
            int n = sideID;
            this.liquidToExtract[n] = this.liquidToExtract[n] + Math.min(500, amountMissing);
        }
        FluidIdentifierStack extracted = container.drain(Math.min(this.liquidToExtract[sideID], 500), false);
        int inserted = 0;
        if (extracted != null) {
            inserted = ((PipeFluidTransportLogistics)this.transport).fill(side, extracted.makeFluidStack(), true);
            container.drain(inserted, true);
        }
        int n = sideID;
        this.liquidToExtract[n] = this.liquidToExtract[n] - inserted;
    }

    @Override
    public void writeToNBT(NBTTagCompound nbttagcompound) {
        super.writeToNBT(nbttagcompound);
        nbttagcompound.func_74783_a("liquidToExtract", this.liquidToExtract);
    }

    @Override
    public void readFromNBT(NBTTagCompound nbttagcompound) {
        super.readFromNBT(nbttagcompound);
        this.liquidToExtract = nbttagcompound.func_74759_k("liquidToExtract");
        if (this.liquidToExtract.length < 6) {
            this.liquidToExtract = new int[6];
        }
    }

    @Override
    public Textures.TextureType getCenterTexture() {
        return Textures.LOGISTICSPIPE_LIQUID_EXTRACTOR;
    }
}

