/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.pipes.tubes;

import java.util.List;
import logisticspipes.interfaces.ITubeOrientation;
import logisticspipes.interfaces.ITubeRenderOrientation;
import logisticspipes.pipes.basic.CoreMultiBlockPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericSubMultiBlock;
import logisticspipes.renderer.newpipe.IHighlightPlacementRenderer;
import logisticspipes.renderer.newpipe.ISpecialPipeRenderer;
import logisticspipes.renderer.newpipe.tube.CurveTubeRenderer;
import logisticspipes.transport.LPTravelingItem;
import logisticspipes.transport.PipeMultiBlockTransportLogistics;
import logisticspipes.utils.IPositionRotateble;
import logisticspipes.utils.LPPositionSet;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;
import network.rs485.logisticspipes.world.DoubleCoordinates;
import network.rs485.logisticspipes.world.DoubleCoordinatesType;

public class HSTubeCurve
extends CoreMultiBlockPipe {
    private CurveOrientation orientation;

    public HSTubeCurve(Item item) {
        super(new PipeMultiBlockTransportLogistics(), item);
    }

    @Override
    public void writeData(LPDataOutput output) {
        if (this.orientation == null) {
            output.writeBoolean(false);
        } else {
            output.writeBoolean(true);
            output.writeEnum(this.orientation);
        }
    }

    @Override
    public void readData(LPDataInput input) {
        if (input.readBoolean()) {
            this.orientation = input.readEnum(CurveOrientation.class);
        }
    }

    @Override
    public int getIconIndex(EnumFacing direction) {
        return 0;
    }

    @Override
    public int getTextureIndex() {
        return 0;
    }

    @Override
    public LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> getSubBlocks() {
        LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> list = new LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>>(DoubleCoordinatesType.class);
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(-1.0, 0.0, 0.0, CoreMultiBlockPipe.SubBlockTypeForShare.CURVE_INNER_A));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(0.0, 0.0, 1.0, CoreMultiBlockPipe.SubBlockTypeForShare.CURVE_OUT_A));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(-1.0, 0.0, 1.0, CoreMultiBlockPipe.SubBlockTypeForShare.NON_SHARE));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(-2.0, 0.0, 1.0, CoreMultiBlockPipe.SubBlockTypeForShare.CURVE_INNER_B));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(-1.0, 0.0, 2.0, CoreMultiBlockPipe.SubBlockTypeForShare.CURVE_OUT_B));
        list.add(new DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>(-2.0, 0.0, 2.0, CoreMultiBlockPipe.SubBlockTypeForShare.NON_SHARE));
        return list;
    }

    @Override
    public LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> getRotatedSubBlocks() {
        LPPositionSet<DoubleCoordinatesType<CoreMultiBlockPipe.SubBlockTypeForShare>> set = this.getSubBlocks();
        this.orientation.rotatePositions(set);
        return set;
    }

    @Override
    public void addCollisionBoxesToList(List<AxisAlignedBB> arraylist, AxisAlignedBB axisalignedbb) {
        double x = this.getX();
        double y = this.getY();
        double z = this.getZ();
        double angle = 0.0;
        double addOne = 0.0;
        double addTwo = 0.0;
        if (this.orientation.getRenderOrientation() == TurnDirection.NORTH_EAST) {
            angle = 4.71238898038469;
            addOne = 0.8125;
            addTwo = 0.1875;
            z -= 2.0;
            x += 1.0;
        } else if (this.orientation.getRenderOrientation() == TurnDirection.EAST_SOUTH) {
            angle = Math.PI;
            addOne = 0.1875;
            addTwo = 0.8125;
            x += 3.0;
            z += 1.0;
        } else if (this.orientation.getRenderOrientation() == TurnDirection.SOUTH_WEST) {
            angle = 1.5707963267948966;
            addOne = 0.8125;
            addTwo = 0.1875;
            z += 3.0;
        } else if (this.orientation.getRenderOrientation() == TurnDirection.WEST_NORTH) {
            angle = 0.0;
            addOne = 0.1875;
            addTwo = 0.8125;
            x -= 2.0;
        }
        for (int i = 0; i < 49; ++i) {
            double xOne = x;
            double yMin = y + 0.1875;
            double zOne = z;
            double xTwo = x;
            double yMax = y + 0.8125;
            double zTwo = z;
            AxisAlignedBB box = new AxisAlignedBB(Math.min(xOne += (2.0 + addOne) * Math.sin(angle + 0.031415926535897934 * (double)i), xTwo += (2.0 + addTwo) * Math.sin(angle + 0.031415926535897934 * (double)(i + 1))), yMin, Math.min(zOne += (2.0 + addOne) * Math.cos(angle + 0.031415926535897934 * (double)(i + 2)), zTwo += (2.0 + addTwo) * Math.cos(angle + 0.031415926535897934 * (double)i)), Math.max(xOne, xTwo), yMax, Math.max(zOne, zTwo));
            if (axisalignedbb != null && !axisalignedbb.func_72326_a(box)) continue;
            arraylist.add(box);
        }
    }

    @Override
    public AxisAlignedBB getCompleteBox() {
        return CurveTubeRenderer.tubeCurve.get(this.orientation.getRenderOrientation()).bounds().toAABB();
    }

    @Override
    public ITubeOrientation getTubeOrientation(EntityPlayer player, int xPos, int zPos) {
        double x = (double)xPos + 0.5 - player.field_70165_t;
        double z = (double)zPos + 0.5 - player.field_70161_v;
        double w = Math.atan2(x, z);
        double halfPI = 1.5707963267948966;
        double halfhalfPI = halfPI / 2.0;
        if ((w -= halfhalfPI) < 0.0) {
            w += Math.PI * 2;
        }
        EnumFacing dir = null;
        EnumFacing dir1 = null;
        EnumFacing dir2 = null;
        double addition = 0.0;
        if (0.0 < w && w <= halfPI) {
            dir = EnumFacing.WEST;
            dir1 = EnumFacing.NORTH;
            dir2 = EnumFacing.SOUTH;
            addition = halfPI;
        } else if (halfPI < w && w <= 2.0 * halfPI) {
            dir = EnumFacing.SOUTH;
            dir1 = EnumFacing.EAST;
            dir2 = EnumFacing.WEST;
        } else if (2.0 * halfPI < w && w <= 3.0 * halfPI) {
            dir = EnumFacing.EAST;
            dir1 = EnumFacing.NORTH;
            dir2 = EnumFacing.SOUTH;
            addition = halfPI;
        } else if (3.0 * halfPI < w && w <= 4.0 * halfPI) {
            dir = EnumFacing.NORTH;
            dir1 = EnumFacing.EAST;
            dir2 = EnumFacing.WEST;
        }
        w = Math.atan2(player.func_70040_Z().field_72450_a, player.func_70040_Z().field_72449_c);
        w -= addition;
        if (w < 0.0) {
            w += Math.PI * 2;
        }
        EnumFacing dir3 = null;
        if (0.0 < w && w <= 2.0 * halfPI) {
            dir3 = dir1;
        } else if (2.0 * halfPI < w && w <= 4.0 * halfPI) {
            dir3 = dir2;
        }
        for (CurveOrientation curve : CurveOrientation.values()) {
            if (!curve.from.equals((Object)dir) || !curve.looking.equals((Object)dir3)) continue;
            return curve;
        }
        return null;
    }

    @Override
    public void writeToNBT(NBTTagCompound data) {
        super.writeToNBT(data);
        data.func_74778_a("orientation", this.orientation.name());
    }

    @Override
    public void readFromNBT(NBTTagCompound data) {
        super.readFromNBT(data);
        this.orientation = CurveOrientation.valueOf(data.func_74779_i("orientation"));
    }

    @Override
    public float getPipeLength() {
        return 3.9269907f;
    }

    @Override
    public EnumFacing getExitForInput(EnumFacing commingFrom) {
        TurnDirection ori = this.orientation.getRenderOrientation();
        if (ori.dir1 == commingFrom) {
            return ori.dir2;
        }
        if (ori.dir2 == commingFrom) {
            return ori.dir1;
        }
        return null;
    }

    @Override
    public TileEntity getConnectedEndTile(EnumFacing output) {
        TurnDirection ori = this.orientation.getRenderOrientation();
        if (ori.dir2 == output) {
            return this.container.getTile(output);
        }
        if (ori.dir1 == output) {
            DoubleCoordinates pos = new DoubleCoordinates(-2.0, 0.0, 2.0);
            LPPositionSet set = new LPPositionSet(DoubleCoordinates.class);
            set.add(pos);
            this.orientation.rotatePositions(set);
            TileEntity subTile = pos.add(this.getLPPosition()).getTileEntity((IBlockAccess)this.getWorld());
            if (subTile instanceof LogisticsTileGenericSubMultiBlock) {
                return ((LogisticsTileGenericSubMultiBlock)subTile).getTile(output);
            }
        }
        return null;
    }

    @Override
    public boolean actAsNormalPipe() {
        return false;
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public ISpecialPipeRenderer getSpecialRenderer() {
        return CurveTubeRenderer.instance;
    }

    @Override
    public IHighlightPlacementRenderer getHighlightRenderer() {
        return CurveTubeRenderer.instance;
    }

    @Override
    public DoubleCoordinates getItemRenderPos(float fPos, LPTravelingItem travelItem) {
        if (this.orientation.getRenderOrientation().getDir1().func_176734_d() != travelItem.input) {
            fPos = this.transport.getPipeLength() - fPos;
        }
        double angle = 0.0;
        int x = 0;
        boolean y = false;
        int z = 0;
        if (this.orientation.getRenderOrientation() == TurnDirection.NORTH_EAST) {
            angle = 4.71238898038469;
            z -= 2;
            ++x;
        } else if (this.orientation.getRenderOrientation() == TurnDirection.EAST_SOUTH) {
            angle = Math.PI;
            x += 3;
            ++z;
        } else if (this.orientation.getRenderOrientation() == TurnDirection.SOUTH_WEST) {
            angle = 1.5707963267948966;
            z += 3;
        } else if (this.orientation.getRenderOrientation() == TurnDirection.WEST_NORTH) {
            angle = 0.0;
            x -= 2;
        }
        double xOne = x;
        double yMin = (double)y + 0.5;
        double zOne = z;
        return new DoubleCoordinates(xOne += 2.5 * Math.sin(angle + 1.5707963267948966 / (double)this.transport.getPipeLength() * (double)fPos), yMin, zOne += 2.5 * Math.cos(angle + 1.5707963267948966 / (double)this.transport.getPipeLength() * (double)fPos));
    }

    @Override
    public double getItemRenderPitch(float fPos, LPTravelingItem travelItem) {
        return super.getItemRenderPitch(fPos, travelItem);
    }

    @Override
    public double getItemRenderYaw(float fPos, LPTravelingItem travelItem) {
        if (this.orientation.getRenderOrientation().getDir1().func_176734_d() != travelItem.input) {
            fPos = this.transport.getPipeLength() - fPos;
        }
        double angle = 0.0;
        if (this.orientation.getRenderOrientation() == TurnDirection.NORTH_EAST) {
            angle = 4.71238898038469;
        } else if (this.orientation.getRenderOrientation() == TurnDirection.EAST_SOUTH) {
            angle = Math.PI;
        } else if (this.orientation.getRenderOrientation() == TurnDirection.SOUTH_WEST) {
            angle = 1.5707963267948966;
        } else if (this.orientation.getRenderOrientation() == TurnDirection.WEST_NORTH) {
            angle = 0.0;
        }
        return 360.0 * (angle + 1.5707963267948966 / (double)this.transport.getPipeLength() * (double)fPos) / (Math.PI * 2);
    }

    @Override
    public double getBoxRenderScale(float fPos, LPTravelingItem travelItem) {
        if (this.orientation.getRenderOrientation().getDir1().func_176734_d() != travelItem.input) {
            fPos = this.transport.getPipeLength() - fPos;
        }
        if ((double)fPos > (double)this.transport.getPipeLength() - 0.5) {
            return 1.0 - (double)(this.transport.getPipeLength() - fPos) * 0.1;
        }
        if ((double)fPos > 0.5) {
            return 0.95;
        }
        return 1.0 - (double)fPos * 0.1;
    }

    @Override
    public boolean isHSTube() {
        return true;
    }

    public CurveOrientation getOrientation() {
        return this.orientation;
    }

    public static enum TurnDirection implements ITubeRenderOrientation
    {
        NORTH_EAST(EnumFacing.NORTH, EnumFacing.EAST),
        EAST_SOUTH(EnumFacing.EAST, EnumFacing.SOUTH),
        SOUTH_WEST(EnumFacing.SOUTH, EnumFacing.WEST),
        WEST_NORTH(EnumFacing.WEST, EnumFacing.NORTH);

        EnumFacing dir1;
        EnumFacing dir2;

        public void rotatePositions(IPositionRotateble set) {
            if (this == WEST_NORTH) {
                return;
            }
            if (this == NORTH_EAST) {
                set.rotateRight();
            } else if (this == EAST_SOUTH) {
                set.rotateLeft();
                set.rotateLeft();
            } else if (this == SOUTH_WEST) {
                set.rotateLeft();
            }
        }

        private TurnDirection(EnumFacing dir1, EnumFacing dir2) {
            this.dir1 = dir1;
            this.dir2 = dir2;
        }

        public EnumFacing getDir1() {
            return this.dir1;
        }
    }

    public static enum CurveOrientation implements ITubeOrientation
    {
        NORTH_NORTH_EAST(TurnDirection.NORTH_EAST, new DoubleCoordinates(2.0, 0.0, 2.0), EnumFacing.NORTH, EnumFacing.EAST),
        NORTH_WEST_NORTH(TurnDirection.WEST_NORTH, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.NORTH, EnumFacing.WEST),
        WEST_WEST_NORTH(TurnDirection.WEST_NORTH, new DoubleCoordinates(2.0, 0.0, -2.0), EnumFacing.WEST, EnumFacing.NORTH),
        WEST_SOUTH_WEST(TurnDirection.SOUTH_WEST, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.WEST, EnumFacing.SOUTH),
        SOUTH_SOUTH_WEST(TurnDirection.SOUTH_WEST, new DoubleCoordinates(-2.0, 0.0, -2.0), EnumFacing.SOUTH, EnumFacing.WEST),
        SOUTH_EAST_SOUTH(TurnDirection.EAST_SOUTH, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.SOUTH, EnumFacing.EAST),
        EAST_EAST_SOUTH(TurnDirection.EAST_SOUTH, new DoubleCoordinates(-2.0, 0.0, 2.0), EnumFacing.EAST, EnumFacing.SOUTH),
        EAST_NORTH_EAST(TurnDirection.NORTH_EAST, new DoubleCoordinates(0.0, 0.0, 0.0), EnumFacing.EAST, EnumFacing.NORTH);

        TurnDirection renderOrientation;
        DoubleCoordinates offset;
        EnumFacing from;
        EnumFacing looking;

        @Override
        public void rotatePositions(IPositionRotateble set) {
            this.renderOrientation.rotatePositions(set);
        }

        @Override
        public void setOnPipe(CoreMultiBlockPipe pipe) {
            ((HSTubeCurve)pipe).orientation = this;
        }

        private CurveOrientation(TurnDirection renderOrientation, DoubleCoordinates offset, EnumFacing from, EnumFacing looking) {
            this.renderOrientation = renderOrientation;
            this.offset = offset;
            this.from = from;
            this.looking = looking;
        }

        @Override
        public TurnDirection getRenderOrientation() {
            return this.renderOrientation;
        }

        @Override
        public DoubleCoordinates getOffset() {
            return this.offset;
        }

        public EnumFacing getFrom() {
            return this.from;
        }

        public EnumFacing getLooking() {
            return this.looking;
        }
    }
}

