/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.recipes.ingredients;

import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import logisticspipes.recipes.CraftingPartRecipes;
import logisticspipes.recipes.CraftingParts;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.Ingredient;
import net.minecraftforge.common.crafting.IIngredientFactory;
import net.minecraftforge.common.crafting.JsonContext;

public class IngredientPart
implements IIngredientFactory {
    @Nonnull
    public Ingredient parse(JsonContext context, JsonObject json) {
        PartType ct = PartType.valueOf(json.get("part").getAsString());
        return new Impl(ct);
    }

    private static class Impl
    extends Ingredient {
        Impl(PartType type) {
            super((ItemStack[])CraftingPartRecipes.getCraftingPartList().stream().map(type::getStack).toArray(ItemStack[]::new));
        }
    }

    public static enum PartType {
        chip_basic,
        chip_advanced,
        chip_fpga;


        @Nonnull
        public ItemStack getStack(CraftingParts parts) {
            switch (this) {
                case chip_basic: {
                    return parts.getChipBasic();
                }
                case chip_advanced: {
                    return parts.getChipAdvanced();
                }
                case chip_fpga: {
                    return parts.getChipFpga();
                }
            }
            throw new IllegalStateException();
        }
    }
}

