/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.request.resources;

import com.google.common.base.Objects;
import java.util.BitSet;
import javax.annotation.Nonnull;
import logisticspipes.interfaces.routing.IRequestItems;
import logisticspipes.request.resources.IResource;
import logisticspipes.request.resources.ItemResource;
import logisticspipes.routing.IRouter;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import logisticspipes.utils.string.ChatColor;
import network.rs485.logisticspipes.util.FuzzyFlag;
import network.rs485.logisticspipes.util.FuzzyUtil;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

public class DictResource
implements IResource {
    private final Object[] ccTypeHolder = new Object[1];
    private final IRequestItems requester;
    public ItemIdentifierStack stack;
    private BitSet fuzzyFlags = new BitSet(4);

    public DictResource(ItemIdentifierStack stack, IRequestItems requester) {
        this.stack = stack;
        this.requester = requester;
    }

    public DictResource(LPDataInput input) {
        this.stack = input.readItemIdentifierStack();
        this.requester = null;
        this.fuzzyFlags = input.readBitSet().get(0, 3);
    }

    @Override
    public void writeData(LPDataOutput output) {
        output.writeItemIdentifierStack(this.stack);
        output.writeBitSet(this.fuzzyFlags);
    }

    @Override
    public ItemIdentifier getAsItem() {
        return this.stack.getItem();
    }

    @Override
    public int getRequestedAmount() {
        return this.stack.getStackSize();
    }

    @Override
    public boolean matches(IResource resource, IResource.MatchSettings settings) {
        if (resource instanceof DictResource) {
            return this.matches(((DictResource)resource).getItem(), IResource.MatchSettings.NORMAL) && resource.matches(this.getItem(), IResource.MatchSettings.NORMAL) && this.getBitSet().equals(((DictResource)resource).getBitSet());
        }
        if (resource instanceof ItemResource) {
            return this.matches(((ItemResource)resource).getItem(), IResource.MatchSettings.NORMAL);
        }
        return false;
    }

    @Override
    public boolean matches(ItemIdentifier other, IResource.MatchSettings settings) {
        return FuzzyUtil.INSTANCE.fuzzyMatches(FuzzyUtil.INSTANCE.getter(this.fuzzyFlags), this.stack.getItem(), other);
    }

    @Override
    @Nonnull
    public IRouter getRouter() {
        return this.requester.getRouter();
    }

    @Override
    public IResource clone(int multiplier) {
        ItemIdentifierStack stack = new ItemIdentifierStack(this.stack);
        stack.setStackSize(stack.getStackSize() * multiplier);
        DictResource clone = new DictResource(stack, this.requester);
        clone.fuzzyFlags.or(this.fuzzyFlags);
        return clone;
    }

    public DictResource clone() {
        DictResource clone = new DictResource(new ItemIdentifierStack(this.stack), this.requester);
        clone.fuzzyFlags.or(this.fuzzyFlags);
        return clone;
    }

    public IRequestItems getTarget() {
        return this.requester;
    }

    public ItemIdentifier getItem() {
        return this.stack.getItem();
    }

    public ItemIdentifierStack getItemStack() {
        return this.stack;
    }

    @Override
    public boolean mergeForDisplay(IResource resource, int withAmount) {
        if (resource instanceof DictResource && ((DictResource)resource).fuzzyFlags.equals(this.fuzzyFlags) && ((DictResource)resource).getItem().equals(this.getItem())) {
            this.stack.setStackSize(this.stack.getStackSize() + withAmount);
            return true;
        }
        return false;
    }

    @Override
    public IResource copyForDisplayWith(int amount) {
        ItemIdentifierStack stack = new ItemIdentifierStack(this.stack);
        stack.setStackSize(amount);
        DictResource clone = new DictResource(stack, null);
        clone.fuzzyFlags.or(this.fuzzyFlags);
        return clone;
    }

    @Override
    public String getDisplayText(IResource.ColorCode code) {
        StringBuilder builder = new StringBuilder();
        builder.append((Object)ChatColor.GRAY);
        builder.append("{");
        if (code != IResource.ColorCode.NONE) {
            builder.append((Object)(code == IResource.ColorCode.MISSING ? ChatColor.RED : ChatColor.GREEN));
        }
        builder.append(this.stack.getFriendlyName());
        if (code != IResource.ColorCode.NONE) {
            builder.append((Object)ChatColor.GRAY);
        }
        builder.append(" [");
        builder.append((Object)(this.useOreDict() ? ChatColor.GREEN : ChatColor.RED));
        builder.append("OreDict");
        builder.append((Object)ChatColor.GRAY);
        builder.append(", ");
        builder.append((Object)(this.useOreCategory() ? ChatColor.GREEN : ChatColor.RED));
        builder.append("OreCat");
        builder.append((Object)ChatColor.GRAY);
        builder.append(", ");
        builder.append((Object)(this.ignoreDamage() ? ChatColor.GREEN : ChatColor.RED));
        builder.append("IgnDmg");
        builder.append((Object)ChatColor.GRAY);
        builder.append(", ");
        builder.append((Object)(this.ignoreNBT() ? ChatColor.GREEN : ChatColor.RED));
        builder.append("IgnNBT");
        builder.append((Object)ChatColor.GRAY);
        return builder.append("]}").toString();
    }

    @Override
    public ItemIdentifierStack getDisplayItem() {
        return this.stack;
    }

    public DictResource loadFromBitSet(BitSet bits) {
        this.fuzzyFlags.clear();
        this.fuzzyFlags.or(bits);
        return this;
    }

    public BitSet getBitSet() {
        return this.fuzzyFlags.get(0, 3);
    }

    public Identifier getIdentifier() {
        return new Identifier();
    }

    @Override
    public Object[] getTypeHolder() {
        return this.ccTypeHolder;
    }

    public boolean useOreDict() {
        return FuzzyUtil.INSTANCE.get(this.fuzzyFlags, FuzzyFlag.USE_ORE_DICT);
    }

    public boolean useOreCategory() {
        return FuzzyUtil.INSTANCE.get(this.fuzzyFlags, FuzzyFlag.USE_ORE_CATEGORY);
    }

    public boolean ignoreDamage() {
        return FuzzyUtil.INSTANCE.get(this.fuzzyFlags, FuzzyFlag.IGNORE_DAMAGE);
    }

    public boolean ignoreNBT() {
        return FuzzyUtil.INSTANCE.get(this.fuzzyFlags, FuzzyFlag.IGNORE_NBT);
    }

    public class Identifier {
        private ItemIdentifier getItem() {
            return DictResource.this.stack.getItem();
        }

        private BitSet getBitSet() {
            return DictResource.this.getBitSet();
        }

        public int hashCode() {
            return Objects.hashCode((Object[])new Object[]{this.getItem(), this.getBitSet()});
        }

        public boolean equals(Object obj) {
            if (obj instanceof Identifier) {
                Identifier id = (Identifier)obj;
                return id.getItem().equals(this.getItem()) && id.getBitSet().equals(this.getBitSet());
            }
            return false;
        }
    }
}

