/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import java.util.List;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.ServerRouter;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\n\u0012\u0004\u0012\u00020\u0005\u0018\u00010\u00042\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\tJ\u000e\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u0007J\n\u0010\r\u001a\u00020\u000e*\u00020\u0007J\n\u0010\u000f\u001a\u00020\u000b*\u00020\u0007\u00a8\u0006\u0010"}, d2={"Llogisticspipes/routing/AsyncRouting;", "", "()V", "getDistance", "", "Llogisticspipes/routing/ExitRoute;", "sourceRouter", "Llogisticspipes/routing/ServerRouter;", "destinationRouter", "Llogisticspipes/routing/IRouter;", "updateRoutingTable", "", "serverRouter", "needsRoutingTableUpdate", "", "updateServerRouterLsa", "logisticspipes"})
public final class AsyncRouting {
    @NotNull
    public static final AsyncRouting INSTANCE = new AsyncRouting();

    private AsyncRouting() {
    }

    @Nullable
    public final List<ExitRoute> getDistance(@NotNull ServerRouter sourceRouter, @NotNull IRouter destinationRouter) {
        Intrinsics.checkNotNullParameter(sourceRouter, "sourceRouter");
        Intrinsics.checkNotNullParameter(destinationRouter, "destinationRouter");
        return sourceRouter._routeTable.size() <= destinationRouter.getSimpleID() ? (List<ExitRoute>)null : sourceRouter._routeTable.get(destinationRouter.getSimpleID());
    }

    public final void updateServerRouterLsa(@NotNull ServerRouter $this$updateServerRouterLsa) {
        Intrinsics.checkNotNullParameter($this$updateServerRouterLsa, "<this>");
        if ($this$updateServerRouterLsa.connectionNeedsChecking != 0 && $this$updateServerRouterLsa.checkAdjacentUpdate()) {
            $this$updateServerRouterLsa.updateLsa();
        }
    }

    public final boolean needsRoutingTableUpdate(@NotNull ServerRouter $this$needsRoutingTableUpdate) {
        Intrinsics.checkNotNullParameter($this$needsRoutingTableUpdate, "<this>");
        return $this$needsRoutingTableUpdate._LSAVersion > ServerRouter._lastLSAVersion[$this$needsRoutingTableUpdate.simpleID];
    }

    public final void updateRoutingTable(@NotNull ServerRouter serverRouter) {
        Intrinsics.checkNotNullParameter(serverRouter, "serverRouter");
        if (serverRouter._LSAVersion > ServerRouter._lastLSAVersion[serverRouter.simpleID]) {
            serverRouter.CreateRouteTable(serverRouter._LSAVersion);
        }
    }
}

