/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing;

import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IProvide;
import logisticspipes.interfaces.routing.IProvideFluids;
import logisticspipes.request.IExtraPromise;
import logisticspipes.request.IPromise;
import logisticspipes.request.resources.FluidResource;
import logisticspipes.request.resources.IResource;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifier;

public class FluidLogisticsPromise
implements IPromise {
    public FluidIdentifier liquid;
    public int amount;
    public IProvideFluids sender;
    public IOrderInfoProvider.ResourceType type;

    @Override
    public FluidLogisticsPromise copy() {
        FluidLogisticsPromise result2 = new FluidLogisticsPromise();
        result2.liquid = this.liquid;
        result2.amount = this.amount;
        result2.sender = this.sender;
        result2.type = this.type;
        return result2;
    }

    @Override
    public boolean matches(IResource requestType) {
        if (requestType instanceof FluidResource) {
            FluidResource fluid = (FluidResource)requestType;
            return fluid.getFluid().equals(this.liquid);
        }
        return false;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }

    @Override
    public IExtraPromise split(int more) {
        throw new UnsupportedOperationException("Fluid Promises can't be split");
    }

    @Override
    public IProvide getProvider() {
        return this.sender;
    }

    @Override
    public ItemIdentifier getItemType() {
        return this.liquid.getItemIdentifier();
    }

    @Override
    public IOrderInfoProvider.ResourceType getType() {
        return this.type;
    }

    @Override
    public IOrderInfoProvider fullFill(IResource requestType, IAdditionalTargetInformation info) {
        return this.sender.fullFill(this, ((FluidResource)requestType).getTarget(), this.type, info);
    }
}

