/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.order;

import javax.annotation.Nonnull;
import logisticspipes.interfaces.routing.IAdditionalTargetInformation;
import logisticspipes.interfaces.routing.IRequestFluid;
import logisticspipes.routing.IRouter;
import logisticspipes.routing.order.IOrderInfoProvider;
import logisticspipes.routing.order.LogisticsOrder;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;

public class LogisticsFluidOrder
extends LogisticsOrder {
    private final FluidIdentifier fluid;
    private int amount;
    private final IRequestFluid destination;

    public LogisticsFluidOrder(FluidIdentifier fuild, Integer amount, IRequestFluid destination, IOrderInfoProvider.ResourceType type, IAdditionalTargetInformation info) {
        super(type, info);
        if (destination == null) {
            throw new NullPointerException();
        }
        this.fluid = fuild;
        this.amount = amount;
        this.destination = destination;
    }

    @Override
    public ItemIdentifierStack getAsDisplayItem() {
        return this.fluid.getItemIdentifier().makeStack(this.amount);
    }

    @Override
    @Nonnull
    public IRouter getRouter() {
        return this.destination.getRouter();
    }

    @Override
    public void sendFailed() {
        this.destination.sendFailed(this.fluid, this.amount);
    }

    @Override
    public void reduceAmountBy(int reduce2) {
        this.amount -= reduce2;
    }

    public FluidIdentifier getFluid() {
        return this.fluid;
    }

    @Override
    public int getAmount() {
        return this.amount;
    }
}

