/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.routing.pathfinder;

import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import logisticspipes.LogisticsPipes;
import logisticspipes.api.ILogisticsPowerProvider;
import logisticspipes.asm.te.ILPTEInformation;
import logisticspipes.asm.te.ITileEntityChangeListener;
import logisticspipes.asm.te.LPTileEntityObject;
import logisticspipes.interfaces.ISubSystemPowerProvider;
import logisticspipes.interfaces.routing.IChannelRoutingConnection;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.proxy.specialconnection.SpecialPipeConnection;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.IPaintPath;
import logisticspipes.routing.LaserData;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.pathfinder.IPipeInformationProvider;
import logisticspipes.routing.pathfinder.IRouteProvider;
import logisticspipes.utils.OneList;
import logisticspipes.utils.tuples.Pair;
import logisticspipes.utils.tuples.Quartet;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import network.rs485.logisticspipes.world.CoordinateUtils;
import network.rs485.logisticspipes.world.DoubleCoordinates;

public class PathFinder {
    private final int maxVisited;
    private final int maxLength;
    private final HashSet<DoubleCoordinates> setVisited;
    private final HashMap<DoubleCoordinates, Double> distances;
    private final IPaintPath pathPainter;
    private double pipesVisited;
    public List<Pair<ILogisticsPowerProvider, List<IFilter>>> powerNodes;
    public List<Pair<ISubSystemPowerProvider, List<IFilter>>> subPowerProvider;
    public HashMap<CoreRoutedPipe, ExitRoute> result;
    public ITileEntityChangeListener changeListener;
    public Set<List<ITileEntityChangeListener>> listenedPipes = new HashSet<List<ITileEntityChangeListener>>();
    public Set<LPTileEntityObject> touchedPipes = new HashSet<LPTileEntityObject>();

    public static HashMap<CoreRoutedPipe, ExitRoute> paintAndgetConnectedRoutingPipes(TileEntity startPipe, EnumFacing startOrientation, int maxVisited, int maxLength, IPaintPath pathPainter, EnumSet<PipeRoutingConnectionType> connectionType) {
        IPipeInformationProvider startProvider = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(startPipe);
        if (startProvider == null) {
            return new HashMap<CoreRoutedPipe, ExitRoute>();
        }
        PathFinder newSearch = new PathFinder(maxVisited, maxLength, pathPainter);
        DoubleCoordinates p = new DoubleCoordinates(startProvider);
        newSearch.setVisited.add(p);
        CoordinateUtils.add(p, startOrientation);
        TileEntity entity = p.getTileEntity((IBlockAccess)startProvider.getWorld());
        IPipeInformationProvider provider = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(entity);
        if (provider == null) {
            return new HashMap<CoreRoutedPipe, ExitRoute>();
        }
        return newSearch.getConnectedRoutingPipes(provider, connectionType, startOrientation);
    }

    public PathFinder(IPipeInformationProvider startPipe, int maxVisited, int maxLength, ITileEntityChangeListener changeListener) {
        this(maxVisited, maxLength, null);
        if (startPipe == null) {
            this.result = new HashMap();
            return;
        }
        this.changeListener = changeListener;
        this.result = this.getConnectedRoutingPipes(startPipe, EnumSet.allOf(PipeRoutingConnectionType.class), null);
    }

    public PathFinder(IPipeInformationProvider startPipe, int maxVisited, int maxLength, EnumFacing side) {
        this(maxVisited, maxLength, null);
        this.result = this.getConnectedRoutingPipes(startPipe, EnumSet.allOf(PipeRoutingConnectionType.class), side);
    }

    private PathFinder(int maxVisited, int maxLength, IPaintPath pathPainter) {
        this.maxVisited = maxVisited;
        this.maxLength = maxLength;
        this.setVisited = new HashSet();
        this.distances = new HashMap();
        this.pathPainter = pathPainter;
    }

    private HashMap<CoreRoutedPipe, ExitRoute> getConnectedRoutingPipes(IPipeInformationProvider startPipe, EnumSet<PipeRoutingConnectionType> connectionFlags, EnumFacing side) {
        boolean root;
        HashMap<CoreRoutedPipe, ExitRoute> foundPipes = new HashMap<CoreRoutedPipe, ExitRoute>();
        int setVisitedSize = this.setVisited.size();
        boolean bl = root = setVisitedSize == 0;
        if (setVisitedSize == 1) {
            this.pipesVisited = 0.0;
        }
        this.pipesVisited += startPipe.getDistanceWeight() > 0.0 ? startPipe.getDistanceWeight() : 1.0;
        if (this.pipesVisited > (double)this.maxVisited) {
            return foundPipes;
        }
        if (setVisitedSize > this.maxLength * 10) {
            return foundPipes;
        }
        if (setVisitedSize > this.maxLength && this.distances.values().stream().mapToDouble(i -> Math.max(Math.min(i, 1.0), 0.0)).sum() > (double)this.maxLength) {
            return foundPipes;
        }
        if (!startPipe.isRouterInitialized()) {
            return foundPipes;
        }
        if (startPipe.isRoutingPipe() && setVisitedSize != 0) {
            CoreRoutedPipe rp = startPipe.getRoutingPipe();
            if (rp.stillNeedReplace()) {
                return foundPipes;
            }
            double size = 0.0;
            for (Double dis : this.distances.values()) {
                size += dis.doubleValue();
            }
            if (!rp.getUpgradeManager().hasPowerPassUpgrade()) {
                connectionFlags.remove((Object)PipeRoutingConnectionType.canPowerSubSystemFrom);
            }
            foundPipes.put(rp, new ExitRoute(null, rp.getRouter(), null, side.func_176734_d(), Math.max(1.0, size), connectionFlags, this.distances.size()));
            return foundPipes;
        }
        this.setVisited.add(new DoubleCoordinates(startPipe));
        this.distances.put(new DoubleCoordinates(startPipe), startPipe.getDistance() * startPipe.getDistanceWeight());
        List<SpecialPipeConnection.ConnectionInformation> pipez = SimpleServiceLocator.specialpipeconnection.getConnectedPipes(startPipe, connectionFlags, side);
        for (SpecialPipeConnection.ConnectionInformation connectionInformation : pipez) {
            if (this.setVisited.contains(new DoubleCoordinates(connectionInformation.getConnectedPipe()))) continue;
            this.distances.put(new DoubleCoordinates(startPipe).center(), connectionInformation.getDistance());
            HashMap<CoreRoutedPipe, ExitRoute> result2 = this.getConnectedRoutingPipes(connectionInformation.getConnectedPipe(), connectionInformation.getConnectionFlags(), connectionInformation.getInsertOrientation());
            this.distances.remove(new DoubleCoordinates(startPipe).center());
            for (Map.Entry<CoreRoutedPipe, ExitRoute> pipe2 : result2.entrySet()) {
                pipe2.getValue().exitOrientation = connectionInformation.getExitOrientation();
                ExitRoute foundPipe = foundPipes.get(pipe2.getKey());
                if (foundPipe != null && !(pipe2.getValue().distanceToDestination < foundPipe.distanceToDestination)) continue;
                foundPipes.put(pipe2.getKey(), pipe2.getValue());
            }
        }
        ArrayDeque<Quartet<TileEntity, EnumFacing, Integer, Boolean>> connections = new ArrayDeque<Quartet<TileEntity, EnumFacing, Integer, Boolean>>();
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            TileEntity tile;
            if (root && side != null && !direction.equals((Object)side) || (tile = startPipe.getNextConnectedTile(direction)) == null) continue;
            if (root && (direction.func_176740_k() == EnumFacing.Axis.X || direction.func_176740_k() == EnumFacing.Axis.Z)) {
                if (tile instanceof ILogisticsPowerProvider) {
                    if (this.powerNodes == null) {
                        this.powerNodes = new ArrayList<Pair<ILogisticsPowerProvider, List<IFilter>>>();
                    }
                    if (startPipe.isFirewallPipe()) {
                        this.powerNodes.add(new Pair<ILogisticsPowerProvider, OneList<IFilter>>((ILogisticsPowerProvider)tile, new OneList<IFilter>(startPipe.getFirewallFilter())));
                    } else {
                        this.powerNodes.add(new Pair((ILogisticsPowerProvider)tile, Collections.unmodifiableList(new ArrayList(0))));
                    }
                } else if (tile instanceof ISubSystemPowerProvider) {
                    if (this.subPowerProvider == null) {
                        this.subPowerProvider = new ArrayList<Pair<ISubSystemPowerProvider, List<IFilter>>>();
                    }
                    if (startPipe.isFirewallPipe()) {
                        this.subPowerProvider.add(new Pair<ISubSystemPowerProvider, OneList<IFilter>>((ISubSystemPowerProvider)tile, new OneList<IFilter>(startPipe.getFirewallFilter())));
                    } else {
                        this.subPowerProvider.add(new Pair((ISubSystemPowerProvider)tile, Collections.unmodifiableList(new ArrayList(0))));
                    }
                }
            }
            connections.add(new Quartet<TileEntity, EnumFacing, Integer, Boolean>(tile, direction, 0, false));
        }
        while (!connections.isEmpty()) {
            List<IRouteProvider.RouteInfo> list;
            IPipeInformationProvider currentPipe;
            Quartet quartet = (Quartet)connections.pollFirst();
            TileEntity tile = (TileEntity)quartet.getValue1();
            EnumFacing direction = (EnumFacing)quartet.getValue2();
            int resistance = (Integer)quartet.getValue3();
            boolean isDirectConnection = (Boolean)quartet.getValue4();
            EnumSet<PipeRoutingConnectionType> nextConnectionFlags = EnumSet.copyOf(connectionFlags);
            if (root) {
                Collection<TileEntity> list2 = SimpleServiceLocator.specialtileconnection.getConnectedPipes(tile);
                if (!list2.isEmpty()) {
                    connections.addAll(list2.stream().map(pipe -> new Quartet<TileEntity, EnumFacing, Integer, Boolean>((TileEntity)pipe, direction, 0, false)).collect(Collectors.toList()));
                    this.listTileEntity(tile);
                    continue;
                }
                if (!startPipe.getRoutingPipe().getUpgradeManager().hasPowerPassUpgrade()) {
                    nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerSubSystemFrom);
                }
            }
            if (!SimpleServiceLocator.pipeInformationManager.isPipe(tile) && tile.hasCapability(LogisticsPipes.ITEM_HANDLER_CAPABILITY, direction.func_176734_d()) && startPipe.isRoutingPipe() && startPipe.getRoutingPipe() instanceof IChannelRoutingConnection && startPipe.canConnect(tile, direction, false) && SimpleServiceLocator.connectionManager.hasChannelConnection(startPipe.getRoutingPipe().getRouter())) {
                List<CoreRoutedPipe> connectedPipes = SimpleServiceLocator.connectionManager.getConnectedPipes(startPipe.getRoutingPipe().getRouter());
                connections.addAll(connectedPipes.stream().map(pipe -> new Quartet<LogisticsTileGenericPipe, EnumFacing, Integer, Boolean>(pipe.container, direction, ((IChannelRoutingConnection)((Object)startPipe.getRoutingPipe())).getConnectionResistance(), true)).collect(Collectors.toList()));
                if (!connectedPipes.isEmpty()) continue;
            }
            if (tile == null || (currentPipe = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(tile)) == null || !currentPipe.isRouterInitialized() || !isDirectConnection && !SimpleServiceLocator.pipeInformationManager.canConnect(startPipe, currentPipe, direction, true)) continue;
            this.listTileEntity(tile);
            if (currentPipe.isMultiBlock()) {
                currentPipe.getPartsOfPipe().forEach(this::listTileEntity);
            }
            if (this.setVisited.contains(new DoubleCoordinates(currentPipe))) continue;
            if (side != direction && !root) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerSubSystemFrom);
            }
            if (isDirectConnection) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerFrom);
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerSubSystemFrom);
            }
            if (currentPipe.divideNetwork()) continue;
            if (currentPipe.powerOnly()) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canRouteTo);
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canRequestFrom);
            }
            if (startPipe.isOnewayPipe() && startPipe.isOutputClosed(direction)) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canRouteTo);
            }
            if (currentPipe.isOnewayPipe()) {
                nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerSubSystemFrom);
                if (currentPipe.isOutputClosed(direction.func_176734_d())) {
                    nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canRequestFrom);
                    nextConnectionFlags.remove((Object)PipeRoutingConnectionType.canPowerFrom);
                }
            }
            if (nextConnectionFlags.isEmpty()) continue;
            int beforeRecurseCount = foundPipes.size();
            HashMap<CoreRoutedPipe, ExitRoute> result3 = null;
            if (currentPipe instanceof IRouteProvider && (list = ((IRouteProvider)((Object)currentPipe)).getConnectedPipes(direction.func_176734_d())) != null) {
                result3 = new HashMap();
                DoubleCoordinates pos = new DoubleCoordinates(currentPipe);
                for (IRouteProvider.RouteInfo info : list) {
                    if (info.getPipe() == startPipe || this.setVisited.contains(new DoubleCoordinates(info.getPipe()))) continue;
                    this.distances.put(pos, currentPipe.getDistance() * currentPipe.getDistanceWeight() + (double)info.getLength());
                    result3.putAll(this.getConnectedRoutingPipes(info.getPipe(), nextConnectionFlags, direction));
                    this.distances.remove(pos);
                }
            }
            if (result3 == null) {
                result3 = this.getConnectedRoutingPipes(currentPipe, nextConnectionFlags, direction);
            }
            for (Map.Entry pipeEntry : result3.entrySet()) {
                ((ExitRoute)pipeEntry.getValue()).exitOrientation = direction;
                ExitRoute foundPipe = foundPipes.get(pipeEntry.getKey());
                if (foundPipe == null) {
                    foundPipes.put((CoreRoutedPipe)pipeEntry.getKey(), (ExitRoute)pipeEntry.getValue());
                    ((ExitRoute)pipeEntry.getValue()).distanceToDestination += (double)resistance;
                    continue;
                }
                if (!(((ExitRoute)pipeEntry.getValue()).distanceToDestination + (double)resistance < foundPipe.distanceToDestination)) continue;
                foundPipes.put((CoreRoutedPipe)pipeEntry.getKey(), (ExitRoute)pipeEntry.getValue());
                ((ExitRoute)pipeEntry.getValue()).distanceToDestination += (double)resistance;
            }
            if (foundPipes.size() <= beforeRecurseCount || this.pathPainter == null) continue;
            this.pathPainter.addLaser(startPipe.getWorld(), new LaserData(startPipe.getX(), startPipe.getY(), startPipe.getZ(), direction, connectionFlags));
        }
        this.setVisited.remove(new DoubleCoordinates(startPipe));
        this.distances.remove(new DoubleCoordinates(startPipe));
        if (startPipe.isRoutingPipe()) {
            for (ExitRoute e : foundPipes.values()) {
                e.root = startPipe.getRoutingPipe().getRouter();
            }
        }
        if (startPipe.isFirewallPipe() && root) {
            for (ExitRoute e : foundPipes.values()) {
                e.filters = new OneList<IFilter>(startPipe.getFirewallFilter());
            }
        }
        return foundPipes;
    }

    private void listTileEntity(TileEntity tile) {
        if (this.changeListener != null && tile instanceof ILPTEInformation && ((ILPTEInformation)tile).getLPTileEntityObject() != null) {
            if (!((ILPTEInformation)tile).getLPTileEntityObject().changeListeners.contains(this.changeListener)) {
                ((ILPTEInformation)tile).getLPTileEntityObject().changeListeners.add(this.changeListener);
            }
            this.listenedPipes.add(((ILPTEInformation)tile).getLPTileEntityObject().changeListeners);
            this.touchedPipes.add(((ILPTEInformation)tile).getLPTileEntityObject());
        }
    }

    public static int messureDistanceToNextRoutedPipe(DoubleCoordinates lpPosition, EnumFacing exitOrientation, World world) {
        int dis = 1;
        TileEntity tile = lpPosition.getTileEntity((IBlockAccess)world);
        if (tile instanceof LogisticsTileGenericPipe) {
            tile = ((LogisticsTileGenericPipe)tile).getNextConnectedTile(exitOrientation);
        }
        if (tile == null) {
            return 0;
        }
        IPipeInformationProvider info = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(tile);
        while (info != null && !info.isRoutingPipe()) {
            tile = info.getNextConnectedTile(exitOrientation);
            if (tile == null) {
                info = null;
                continue;
            }
            info = SimpleServiceLocator.pipeInformationManager.getInformationProviderFor(tile);
            ++dis;
        }
        return dis;
    }
}

