/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import java.util.Arrays;
import java.util.stream.Stream;
import logisticspipes.interfaces.ITankUtil;
import logisticspipes.utils.FluidIdentifier;
import logisticspipes.utils.FluidIdentifierStack;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidTankProperties;

public class TankUtil
implements ITankUtil {
    private final IFluidHandler fluidhandler;

    public TankUtil(IFluidHandler fluidhandler) {
        this.fluidhandler = fluidhandler;
    }

    @Override
    public boolean containsTanks() {
        IFluidTankProperties[] tanks = this.fluidhandler.getTankProperties();
        return tanks != null && tanks.length > 0;
    }

    @Override
    public int fill(FluidIdentifierStack stack, boolean doFill) {
        return this.fluidhandler.fill(stack.makeFluidStack(), doFill);
    }

    @Override
    public FluidIdentifierStack drain(FluidIdentifierStack stack, boolean doDrain) {
        return FluidIdentifierStack.getFromStack(this.fluidhandler.drain(stack.makeFluidStack(), doDrain));
    }

    @Override
    public FluidIdentifierStack drain(int amount, boolean doDrain) {
        return FluidIdentifierStack.getFromStack(this.fluidhandler.drain(amount, doDrain));
    }

    @Override
    public Stream<IFluidTankProperties> tanks() {
        IFluidTankProperties[] tanks = this.fluidhandler.getTankProperties();
        if (tanks == null) {
            return Stream.empty();
        }
        return Arrays.stream(tanks).filter(tank -> tank.getContents() != null);
    }

    @Override
    public boolean canDrain(FluidIdentifier fluid) {
        FluidStack fluidStack = fluid.makeFluidStack(1);
        return this.tanks().anyMatch(tank -> tank.canDrainFluidType(fluidStack));
    }

    @Override
    public int getFreeSpaceInsideTank(FluidIdentifier type) {
        int free = 0;
        IFluidTankProperties[] tanks = this.fluidhandler.getTankProperties();
        if (tanks != null && tanks.length > 0) {
            for (IFluidTankProperties tank : tanks) {
                FluidStack content = tank.getContents();
                if (content != null && FluidIdentifier.get(content) != type) continue;
                free += this.getFreeSpaceInsideTank(tank);
            }
        }
        return free;
    }

    private int getFreeSpaceInsideTank(IFluidTankProperties tanks) {
        if (tanks == null) {
            return 0;
        }
        FluidStack liquid = tanks.getContents();
        if (liquid == null || liquid.getFluid() == null) {
            return tanks.getCapacity();
        }
        return tanks.getCapacity() - liquid.amount;
    }
}

