/*
 * Decompiled with CFR 0.152.
 */
package logisticspipes.utils;

import logisticspipes.pipes.basic.LogisticsTileGenericPipe;
import logisticspipes.utils.SafeTimeTracker;
import net.minecraft.block.Block;
import net.minecraft.block.state.IBlockState;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;

public final class TileBuffer {
    private Block block = null;
    private TileEntity tile;
    private final SafeTimeTracker tracker = new SafeTimeTracker(20L, 5L);
    private final World world;
    private final int x;
    private final int y;
    private final int z;
    private final boolean loadUnloaded;

    public TileBuffer(World world, int x, int y, int z, boolean loadUnloaded) {
        this.world = world;
        this.x = x;
        this.y = y;
        this.z = z;
        this.loadUnloaded = loadUnloaded;
        this.refresh();
    }

    public void refresh() {
        BlockPos pos = new BlockPos(this.x, this.y, this.z);
        IBlockState blockState = this.world.func_180495_p(pos);
        if (this.tile instanceof LogisticsTileGenericPipe && ((LogisticsTileGenericPipe)this.tile).pipe != null && ((LogisticsTileGenericPipe)this.tile).pipe.preventRemove() && blockState.func_177230_c().isAir(blockState, (IBlockAccess)this.world, pos)) {
            return;
        }
        this.tile = null;
        this.block = null;
        if (!this.loadUnloaded) {
            return;
        }
        this.block = blockState.func_177230_c();
        if (this.block.hasTileEntity(blockState)) {
            this.tile = this.world.func_175625_s(pos);
        }
    }

    public void set(Block block, TileEntity tile) {
        this.block = block;
        this.tile = tile;
        this.tracker.markTime(this.world);
    }

    public Block getBlock() {
        if (this.tile != null && !this.tile.func_145837_r()) {
            return this.block;
        }
        if (this.tracker.markTimeIfDelay(this.world)) {
            this.refresh();
            if (this.tile != null && !this.tile.func_145837_r()) {
                return this.block;
            }
        }
        return null;
    }

    public TileEntity getTile() {
        if (this.tile != null && !this.tile.func_145837_r()) {
            return this.tile;
        }
        if (this.tracker.markTimeIfDelay(this.world)) {
            this.refresh();
            if (this.tile != null && !this.tile.func_145837_r()) {
                return this.tile;
            }
        }
        return null;
    }

    public static TileBuffer[] makeBuffer(World world, BlockPos pos, boolean loadUnloaded) {
        TileBuffer[] buffer = new TileBuffer[6];
        for (int i = 0; i < 6; ++i) {
            EnumFacing d = EnumFacing.func_82600_a((int)i);
            buffer[i] = new TileBuffer(world, pos.func_177958_n() + d.func_82601_c(), pos.func_177956_o() + d.func_96559_d(), pos.func_177952_p() + d.func_82599_e(), loadUnloaded);
        }
        return buffer;
    }
}

