/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.debug;

import com.google.common.reflect.Reflection;
import java.awt.Color;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.JTextField;
import javax.swing.KeyStroke;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableModel;
import javax.swing.text.JTextComponent;
import logisticspipes.LogisticsPipes;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.internal.DefaultConstructorMarker;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.text.StringsKt;
import network.rs485.debug.ChangeTrackingSortedMap;
import network.rs485.debug.GLType;
import network.rs485.debug.GLVariable;
import network.rs485.debug.IOpenGLDebugger;
import org.lwjgl.opengl.GL11;
import org.lwjgl.util.glu.GLU;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000L\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\b\u0018\u0000 \u001e2\u00020\u0001:\u0004\u001e\u001f !B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u001aH\u0016J\b\u0010\u001b\u001a\u00020\u001aH\u0002J\b\u0010\u001c\u001a\u00020\u001aH\u0016J\b\u0010\u001d\u001a\u00020\u001aH\u0016R\u000e\u0010\u0005\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001a\u0010\b\u001a\u000e\u0012\u0004\u0012\u00020\n\u0012\u0004\u0012\u00020\u000b0\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0016\u0010\f\u001a\n \u000e*\u0004\u0018\u00010\r0\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\n0\u0010X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001a\u0010\u0002\u001a\u00020\u0003X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0013\u0010\u0014\"\u0004\b\u0015\u0010\u0004R\u000e\u0010\u0016\u001a\u00020\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0012X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\""}, d2={"Lnetwork/rs485/debug/OpenGLDebugger;", "Lnetwork/rs485/debug/IOpenGLDebugger;", "printOnCycle", "", "(I)V", "cycleCount", "debuggerLock", "Ljava/util/concurrent/locks/ReentrantLock;", "glStuff", "Lnetwork/rs485/debug/ChangeTrackingSortedMap;", "Lnetwork/rs485/debug/GLVariable;", "", "glVariablesCondition", "Ljava/util/concurrent/locks/Condition;", "logisticspipes.kotlin.jvm.PlatformType", "glVariablesToCheck", "Ljava/util/ArrayList;", "glVariablesUpdated", "", "getPrintOnCycle", "()I", "setPrintOnCycle", "probeGUIThread", "Ljava/lang/Thread;", "started", "cycle", "", "saveOpenGLStuff", "start", "stop", "Companion", "ProbeGUI", "SpecialTableCellRenderer", "SpecialTableModel", "logisticspipes"})
public final class OpenGLDebugger
implements IOpenGLDebugger {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private int printOnCycle;
    @NotNull
    private final Thread probeGUIThread;
    private int cycleCount;
    private boolean started;
    @NotNull
    private final ChangeTrackingSortedMap<GLVariable, Object> glStuff;
    @NotNull
    private final ArrayList<GLVariable> glVariablesToCheck;
    @NotNull
    private final ReentrantLock debuggerLock;
    private final Condition glVariablesCondition;
    private boolean glVariablesUpdated;
    @NotNull
    private static final HashMap<Integer, String> niceToHave = new HashMap();
    private static int probeID;

    public OpenGLDebugger(int printOnCycle) {
        this.printOnCycle = printOnCycle;
        this.glStuff = new ChangeTrackingSortedMap();
        this.glVariablesToCheck = new ArrayList();
        this.debuggerLock = new ReentrantLock();
        this.glVariablesCondition = this.debuggerLock.newCondition();
        if (!(this.getPrintOnCycle() >= 1)) {
            boolean bl = false;
            String string = "Print per cycle must be at least 1";
            throw new IllegalArgumentException(string.toString());
        }
        this.probeGUIThread = new Thread(() -> OpenGLDebugger._init_$lambda-2(this), "LogisticsPipes GLDebug Probe #" + probeID);
        int n = probeID;
        probeID = n + 1;
    }

    @Override
    public int getPrintOnCycle() {
        return this.printOnCycle;
    }

    @Override
    public void setPrintOnCycle(int n) {
        this.printOnCycle = n;
    }

    @Override
    public void start() {
        if (!this.started) {
            this.started = true;
            this.cycleCount = 0;
            this.probeGUIThread.start();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void stop() {
        if (this.started) {
            Lock lock = this.debuggerLock;
            lock.lock();
            try {
                boolean bl = false;
                this.started = false;
                this.glVariablesUpdated = true;
                this.glVariablesCondition.signal();
                Unit unit = Unit.INSTANCE;
            }
            finally {
                lock.unlock();
            }
        }
    }

    @Override
    public void cycle() {
        if (!this.started) {
            this.start();
        }
        ++this.cycleCount;
        if (this.cycleCount % this.getPrintOnCycle() == 0) {
            this.saveOpenGLStuff();
            this.cycleCount = 0;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * WARNING - void declaration
     */
    private final void saveOpenGLStuff() {
        Lock lock = this.debuggerLock;
        lock.lock();
        try {
            void $this$filterTo$iv$iv;
            boolean bl = false;
            this.glStuff.startSession();
            Iterable $this$filter$iv = this.glVariablesToCheck;
            boolean $i$f$filter = false;
            Iterable iterable = $this$filter$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$filterTo = false;
            for (Object element$iv$iv : $this$filterTo$iv$iv) {
                Object object;
                boolean isInvalid;
                GLVariable variable = (GLVariable)element$iv$iv;
                boolean bl2 = false;
                LogisticsPipes.log.warn("Getting " + variable.getName(niceToHave.get(variable.getPname())));
                Object value = variable.getType().getGetterFunction().invoke(variable.getPname());
                int glError = GL11.glGetError();
                boolean bl3 = isInvalid = glError == 1280;
                if (glError != 0) {
                    LogisticsPipes.log.warn("  got error " + GLU.gluErrorString((int)glError));
                }
                if ((object = value) != null) {
                    Object object2;
                    Object it = object2 = object;
                    boolean bl4 = false;
                    object = !isInvalid ? object2 : null;
                    if (object != null) {
                        it = object2 = object;
                        boolean bl5 = false;
                        this.glStuff.put((GLVariable)((Comparable)variable), it);
                    }
                }
                if (!isInvalid) continue;
                destination$iv$iv.add(element$iv$iv);
            }
            Set toRemove = CollectionsKt.toSet((List)destination$iv$iv);
            this.glVariablesToCheck.removeAll(toRemove);
            this.glStuff.stopSession();
            this.glVariablesUpdated = true;
            this.glVariablesCondition.signal();
            Unit unit = Unit.INSTANCE;
        }
        finally {
            lock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final void _init_$lambda-2(OpenGLDebugger this$0) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        HashMap<Integer, String> hashMap = niceToHave;
        synchronized (hashMap) {
            boolean bl = false;
            if (niceToHave.isEmpty()) {
                OpenGLDebugger.Companion.updateNiceToHave();
            }
            Unit unit = Unit.INSTANCE;
        }
        this$0.new ProbeGUI().run();
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\b\u0010\u0003\u001a\u00020\u0004H\u0016J\u0010\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\u0004H\u0016J\b\u0010\b\u001a\u00020\u0004H\u0016J\u0018\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00042\u0006\u0010\f\u001a\u00020\u0004H\u0016J\u0018\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00042\u0006\u0010\u0007\u001a\u00020\u0004H\u0016\u00a8\u0006\u0010"}, d2={"Lnetwork/rs485/debug/OpenGLDebugger$SpecialTableModel;", "Ljavax/swing/table/DefaultTableModel;", "(Lnetwork/rs485/debug/OpenGLDebugger;)V", "getColumnCount", "", "getColumnName", "", "column", "getRowCount", "getValueAt", "", "rowIndex", "columnIndex", "isCellEditable", "", "row", "logisticspipes"})
    private final class SpecialTableModel
    extends DefaultTableModel {
        @Override
        public boolean isCellEditable(int row, int column) {
            return false;
        }

        @Override
        @NotNull
        public String getColumnName(int column) {
            String string;
            switch (column) {
                case 0: {
                    string = "Key";
                    break;
                }
                case 1: {
                    string = "Value";
                    break;
                }
                default: {
                    string = "";
                }
            }
            return string;
        }

        @Override
        public int getRowCount() {
            return OpenGLDebugger.this.glStuff.getSize();
        }

        @Override
        public int getColumnCount() {
            return 2;
        }

        @Override
        @NotNull
        public Object getValueAt(int rowIndex, int columnIndex) {
            Object object;
            block11: {
                block9: {
                    String string;
                    object = (GLVariable)OpenGLDebugger.this.glStuff.getKeyOrNull(rowIndex);
                    if (object == null) break block9;
                    GLVariable gLVariable = object;
                    OpenGLDebugger openGLDebugger = OpenGLDebugger.this;
                    GLVariable glVariable = gLVariable;
                    boolean bl = false;
                    switch (columnIndex) {
                        case 0: {
                            string = glVariable.getName((String)niceToHave.get(glVariable.getPname()));
                            break;
                        }
                        case 1: {
                            string = openGLDebugger.glStuff.getValueOrNull(rowIndex);
                            if (string == null) {
                                string = "<NULL>";
                            }
                            break;
                        }
                        default: {
                            string = "";
                        }
                    }
                    object = string;
                    if (string != null) break block11;
                }
                object = "<NOT FOUND>";
            }
            return object;
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\b\u0082\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J:\u0010\u0003\u001a\u00020\u00042\b\u0010\u0005\u001a\u0004\u0018\u00010\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\n2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0016\u00a8\u0006\u000f"}, d2={"Lnetwork/rs485/debug/OpenGLDebugger$SpecialTableCellRenderer;", "Ljavax/swing/table/DefaultTableCellRenderer;", "(Lnetwork/rs485/debug/OpenGLDebugger;)V", "getTableCellRendererComponent", "Ljava/awt/Component;", "table", "Ljavax/swing/JTable;", "value", "", "isSelected", "", "hasFocus", "row", "", "column", "logisticspipes"})
    private final class SpecialTableCellRenderer
    extends DefaultTableCellRenderer {
        @Override
        @NotNull
        public Component getTableCellRendererComponent(@Nullable JTable table, @NotNull Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            Intrinsics.checkNotNullParameter(value, "value");
            if (table == null) {
                return this;
            }
            this.setBackground(null);
            super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
            if (OpenGLDebugger.this.glStuff.wasUpdated(row)) {
                this.setBackground(Color.YELLOW);
            } else if (OpenGLDebugger.this.glStuff.wasAdded(row)) {
                this.setBackground(Color.GREEN);
            }
            return this;
        }
    }

    /*
     * Illegal identifiers - consider using --renameillegalidents true
     */
    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\b\u0082\u0004\u0018\u00002\u00020\u00012\u00020\u0002B\u0005\u00a2\u0006\u0002\u0010\u0003J\b\u0010\n\u001a\u00020\u000bH\u0016J\b\u0010\f\u001a\u00020\u0007H\u0002J\b\u0010\r\u001a\u00020\u000bH\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u000e"}, d2={"Lnetwork/rs485/debug/OpenGLDebugger$ProbeGUI;", "Ljavax/swing/JDialog;", "Ljava/lang/Runnable;", "(Lnetwork/rs485/debug/OpenGLDebugger;)V", "closeButton", "Ljavax/swing/JButton;", "mainPanel", "Ljavax/swing/JPanel;", "variableMonitorTable", "Ljavax/swing/JTable;", "run", "", "setupUI", "updateVariables", "logisticspipes"})
    private final class ProbeGUI
    extends JDialog
    implements Runnable {
        @NotNull
        private final JPanel mainPanel;
        @NotNull
        private final JTable variableMonitorTable;
        @NotNull
        private final JButton closeButton;

        /*
         * WARNING - void declaration
         */
        public ProbeGUI() {
            void $this$_init__u24lambda_u2d1;
            void $this$_init__u24lambda_u2d0;
            UIManager.LookAndFeelInfo[] lookAndFeelInfoArray = UIManager.getInstalledLookAndFeels();
            Intrinsics.checkNotNullExpressionValue(lookAndFeelInfoArray, "getInstalledLookAndFeels()");
            Object object = lookAndFeelInfoArray;
            int n = ((UIManager.LookAndFeelInfo[])object).length;
            for (int i = 0; i < n; ++i) {
                UIManager.LookAndFeelInfo info = object[i];
                if (!Intrinsics.areEqual("Windows", info.getName())) continue;
                try {
                    UIManager.setLookAndFeel(info.getClassName());
                }
                catch (ReflectiveOperationException e) {
                    e.printStackTrace();
                }
                catch (UnsupportedLookAndFeelException e) {
                    e.printStackTrace();
                }
                break;
            }
            this.mainPanel = new JPanel();
            Object object2 = object = new JButton();
            ProbeGUI probeGUI = this;
            boolean $i$a$-apply-OpenGLDebugger$ProbeGUI$32 = false;
            $this$_init__u24lambda_u2d0.setText("Close");
            probeGUI.closeButton = object;
            object = new JTable();
            object2 = OpenGLDebugger.this;
            Object $i$a$-apply-OpenGLDebugger$ProbeGUI$32 = object;
            probeGUI = this;
            boolean bl = false;
            $this$_init__u24lambda_u2d1.setEnabled(false);
            $this$_init__u24lambda_u2d1.setModel((OpenGLDebugger)object2.new SpecialTableModel());
            $this$_init__u24lambda_u2d1.getColumnModel().getColumn(0).setCellRenderer((OpenGLDebugger)object2.new SpecialTableCellRenderer());
            probeGUI.variableMonitorTable = object;
            this.setupUI();
            this.setType(Window.Type.UTILITY);
            this.setContentPane(this.mainPanel);
            this.getRootPane().setDefaultButton(this.closeButton);
            this.setDefaultCloseOperation(0);
            this.addWindowListener(new WindowAdapter(){

                @Override
                public void windowClosing(@NotNull WindowEvent e) {
                    Intrinsics.checkNotNullParameter(e, "e");
                    OpenGLDebugger.this.stop();
                }
            });
            this.closeButton.addActionListener(arg_0 -> ProbeGUI._init_$lambda-2(OpenGLDebugger.this, arg_0));
            this.mainPanel.registerKeyboardAction(arg_0 -> ProbeGUI._init_$lambda-3(OpenGLDebugger.this, arg_0), KeyStroke.getKeyStroke(27, 0), 1);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public void run() {
            void $this$flatMapTo$iv$iv;
            void $this$flatMap$iv;
            OpenGLDebugger.this.glVariablesToCheck.clear();
            ArrayList arrayList = OpenGLDebugger.this.glVariablesToCheck;
            Set set = niceToHave.keySet();
            Intrinsics.checkNotNullExpressionValue(set, "niceToHave.keys");
            Object object = set;
            ArrayList arrayList2 = arrayList;
            boolean $i$f$flatMap = false;
            Unit unit = $this$flatMap$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$flatMapTo = false;
            for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
                void $this$mapTo$iv$iv;
                Integer key = (Integer)element$iv$iv;
                boolean bl = false;
                GLType[] $this$map$iv = GLType.values();
                boolean $i$f$map = false;
                GLType[] gLTypeArray = $this$map$iv;
                Collection destination$iv$iv2 = new ArrayList($this$map$iv.length);
                boolean $i$f$mapTo = false;
                int n = ((void)$this$mapTo$iv$iv).length;
                for (int i = 0; i < n; ++i) {
                    void glType;
                    void item$iv$iv;
                    void var18_23 = item$iv$iv = $this$mapTo$iv$iv[i];
                    Collection collection = destination$iv$iv2;
                    boolean bl2 = false;
                    Intrinsics.checkNotNullExpressionValue(key, "key");
                    collection.add(new GLVariable(key, (GLType)glType));
                }
                Iterable list$iv$iv = (List)destination$iv$iv2;
                CollectionsKt.addAll(destination$iv$iv, list$iv$iv);
            }
            arrayList2.addAll((List)destination$iv$iv);
            this.pack();
            this.setVisible(true);
            while (OpenGLDebugger.this.started) {
                object = OpenGLDebugger.this.debuggerLock;
                OpenGLDebugger openGLDebugger = OpenGLDebugger.this;
                object.lock();
                try {
                    boolean bl = false;
                    try {
                        while (!openGLDebugger.glVariablesUpdated) {
                            openGLDebugger.glVariablesCondition.await();
                        }
                        openGLDebugger.glVariablesUpdated = false;
                        this.updateVariables();
                    }
                    catch (InterruptedException e) {
                        e.printStackTrace();
                    }
                    unit = Unit.INSTANCE;
                }
                finally {
                    object.unlock();
                }
            }
        }

        private final void updateVariables() {
            TableModel tableModel = this.variableMonitorTable.getModel();
            Intrinsics.checkNotNull(tableModel, "null cannot be cast to non-null type javax.swing.table.DefaultTableModel");
            DefaultTableModel dtm = (DefaultTableModel)tableModel;
            dtm.fireTableDataChanged();
        }

        private final JPanel setupUI() {
            Serializable $this$setupUI_u24lambda_u2d12_u24lambda_u2d10;
            Serializable $this$setupUI_u24lambda_u2d12_u24lambda_u2d8;
            Serializable serializable;
            JPanel jPanel;
            JPanel $this$setupUI_u24lambda_u2d12 = jPanel = this.mainPanel;
            boolean bl = false;
            $this$setupUI_u24lambda_u2d12.setLayout(new GridBagLayout());
            $this$setupUI_u24lambda_u2d12.setBorder(BorderFactory.createTitledBorder(BorderFactory.createEmptyBorder(5, 5, 5, 5), "null"));
            GridBagConstraints gridBagConstraints = serializable = new GridBagConstraints();
            Component component = this.closeButton;
            JPanel jPanel2 = $this$setupUI_u24lambda_u2d12;
            boolean bl2 = false;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d7.gridx = 2;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d7.gridy = 1;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d7.fill = 2;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d7.insets = new Insets(0, 5, 0, 0);
            Unit unit = Unit.INSTANCE;
            jPanel2.add(component, serializable);
            Serializable $this$setupUI_u24lambda_u2d12_u24lambda_u2d7 = serializable = new JTextField();
            jPanel2 = $this$setupUI_u24lambda_u2d12;
            boolean bl3 = false;
            ((JTextComponent)$this$setupUI_u24lambda_u2d12_u24lambda_u2d8).setText("Search\u2026");
            Component component2 = (Component)serializable;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d8 = serializable = new GridBagConstraints();
            component = component2;
            boolean bl4 = false;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d9.gridx = 0;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d9.gridy = 1;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d9.weightx = 1.0;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d9.anchor = 17;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d9.fill = 2;
            unit = Unit.INSTANCE;
            jPanel2.add(component, serializable);
            Serializable $this$setupUI_u24lambda_u2d12_u24lambda_u2d9 = serializable = new JScrollPane();
            jPanel2 = $this$setupUI_u24lambda_u2d12;
            boolean bl5 = false;
            ((JScrollPane)$this$setupUI_u24lambda_u2d12_u24lambda_u2d10).setHorizontalScrollBarPolicy(31);
            ((JScrollPane)$this$setupUI_u24lambda_u2d12_u24lambda_u2d10).setViewportView(this.variableMonitorTable);
            Component component3 = (Component)serializable;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d10 = serializable = new GridBagConstraints();
            component = component3;
            boolean bl6 = false;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d11.gridx = 0;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d11.gridy = 0;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d11.gridwidth = 3;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d11.weightx = 1.0;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d11.weighty = 1.0;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d11.fill = 1;
            $this$setupUI_u24lambda_u2d12_u24lambda_u2d11.insets = new Insets(0, 0, 5, 0);
            unit = Unit.INSTANCE;
            jPanel2.add(component, serializable);
            return jPanel;
        }

        private static final void _init_$lambda-2(OpenGLDebugger this$0, ActionEvent it) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            this$0.stop();
        }

        private static final void _init_$lambda-3(OpenGLDebugger this$0, ActionEvent it) {
            Intrinsics.checkNotNullParameter(this$0, "this$0");
            this$0.stop();
        }
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\"\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\b\u0010\b\u001a\u00020\tH\u0002R\u001a\u0010\u0003\u001a\u000e\u0012\u0004\u0012\u00020\u0005\u0012\u0004\u0012\u00020\u00060\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\n"}, d2={"Lnetwork/rs485/debug/OpenGLDebugger$Companion;", "", "()V", "niceToHave", "Ljava/util/HashMap;", "", "", "probeID", "updateNiceToHave", "", "logisticspipes"})
    public static final class Companion {
        private Companion() {
        }

        private final void updateNiceToHave() {
            niceToHave.clear();
            int crawlerVersion = 11;
            boolean almostEnd = false;
            boolean end = false;
            while (!end) {
                String packageGL;
                String string = "%s%d";
                Object[] objectArray2 = new Object[]{"GL", crawlerVersion};
                objectArray2 = objectArray2;
                Intrinsics.checkNotNullExpressionValue(String.format(string, Arrays.copyOf(objectArray2, objectArray2.length)), "format(format, *args)");
                String string2 = "%s.%s";
                Object[] objectArray3 = new Object[]{"org.lwjgl.opengl", packageGL};
                Intrinsics.checkNotNullExpressionValue(String.format(string2, Arrays.copyOf(objectArray3, objectArray3.length)), "format(format, *args)");
                try {
                    Field[] fieldArray;
                    String nextGL;
                    ++crawlerVersion;
                    Class<?> glClass = GL11.class.getClassLoader().loadClass(nextGL);
                    Class[] classArray = new Class[]{glClass};
                    Reflection.initialize((Class[])classArray);
                    almostEnd = false;
                    Intrinsics.checkNotNullExpressionValue(glClass.getDeclaredFields(), "glClass.declaredFields");
                    for (Field f : fieldArray) {
                        Object[] objectArray4;
                        try {
                            String string3;
                            Object[] objectArray5;
                            int id;
                            if (!Intrinsics.areEqual(f.getType(), Integer.TYPE) || (id = f.getInt(null)) == -1) continue;
                            String nice = f.getName();
                            Intrinsics.checkNotNullExpressionValue(nice, "nice");
                            if (StringsKt.endsWith$default(nice, "BIT", false, 2, null)) continue;
                            if (niceToHave.containsKey(id) && !Intrinsics.areEqual(niceToHave.get(id), nice)) {
                                objectArray5 = new Object[]{id, niceToHave.remove(id), nice};
                                System.out.printf("NiceToHave: ID %d exists. Replacing %s with %s!!%n", objectArray5);
                            }
                            objectArray5 = (Object[])niceToHave;
                            Integer n = id;
                            String string4 = "%s.%s";
                            Object[] objectArray6 = new Object[]{packageGL, nice};
                            Intrinsics.checkNotNullExpressionValue(String.format(string4, Arrays.copyOf(objectArray6, objectArray6.length)), "format(format, *args)");
                            objectArray5.put(n, string3);
                        }
                        catch (IllegalArgumentException e) {
                            objectArray4 = new Object[]{e};
                            System.out.printf("NiceToHave: Illegal Argument!%nNiceToHave: %s%n", objectArray4);
                            e.printStackTrace();
                        }
                        catch (IllegalAccessException e) {
                            objectArray4 = new Object[]{e};
                            System.out.printf("NiceToHave: Illegal Access!%nNiceToHave: %s%n", objectArray4);
                            e.printStackTrace();
                        }
                    }
                }
                catch (ClassNotFoundException e) {
                    if (almostEnd) {
                        end = true;
                        continue;
                    }
                    almostEnd = true;
                    crawlerVersion = (crawlerVersion / 10 + 1) * 10;
                }
            }
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

