/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.connection;

import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityHopper;
import net.minecraftforge.fml.common.Loader;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0005\u00a2\u0006\u0002\u0010\u0002J\u0012\u0010\n\u001a\u00020\u000b2\n\u0010\f\u001a\u0006\u0012\u0002\b\u00030\u0005J\u0018\u0010\r\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u000fH\u0002J\u000e\u0010\u0011\u001a\u00020\t2\u0006\u0010\u0012\u001a\u00020\bR\u0018\u0010\u0003\u001a\f\u0012\b\u0012\u0006\u0012\u0002\b\u00030\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R \u0010\u0006\u001a\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\b0\u0005\u0012\u0004\u0012\u00020\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0013"}, d2={"Lnetwork/rs485/logisticspipes/connection/PipeInventoryConnectionChecker;", "", "()V", "allowedConnectionClasses", "", "Ljava/lang/Class;", "cachedClasses", "", "Lnet/minecraft/tileentity/TileEntity;", "", "addSupportedClassType", "", "clazz", "checkAndAddClass", "modId", "", "className", "shouldLPProvideInventoryTo", "tile", "logisticspipes"})
public final class PipeInventoryConnectionChecker {
    @NotNull
    private final Set<Class<?>> allowedConnectionClasses = new LinkedHashSet();
    @NotNull
    private final Map<Class<TileEntity>, Boolean> cachedClasses = new LinkedHashMap();

    public PipeInventoryConnectionChecker() {
        this.allowedConnectionClasses.add(TileEntityHopper.class);
        this.checkAndAddClass("gregtech", "gregtech.api.block.BlockStateTileEntity");
    }

    private final void checkAndAddClass(String modId, String className) {
        if (Loader.isModLoaded((String)modId)) {
            try {
                Class<?> clazz = Class.forName(className);
                Intrinsics.checkNotNullExpressionValue(clazz, "clazz");
                this.addSupportedClassType(clazz);
            }
            catch (ClassNotFoundException classNotFoundException) {
                // empty catch block
            }
        }
    }

    public final void addSupportedClassType(@NotNull Class<?> clazz) {
        Intrinsics.checkNotNullParameter(clazz, "clazz");
        this.allowedConnectionClasses.add(clazz);
    }

    public final boolean shouldLPProvideInventoryTo(@NotNull TileEntity tile) {
        Intrinsics.checkNotNullParameter(tile, "tile");
        Boolean bl = this.cachedClasses.computeIfAbsent(tile.getClass(), arg_0 -> PipeInventoryConnectionChecker.shouldLPProvideInventoryTo$lambda-0(this, arg_0));
        Intrinsics.checkNotNullExpressionValue(bl, "cachedClasses.computeIfA\u2026eIfAbsent false\n        }");
        return bl;
    }

    private static final Boolean shouldLPProvideInventoryTo$lambda-0(PipeInventoryConnectionChecker this$0, Class it) {
        Intrinsics.checkNotNullParameter(this$0, "this$0");
        Intrinsics.checkNotNullParameter(it, "it");
        Class clazz = it;
        while (!Intrinsics.areEqual(clazz.getSuperclass(), Object.class)) {
            if (this$0.allowedConnectionClasses.contains(clazz)) {
                return true;
            }
            Intrinsics.checkNotNullExpressionValue(clazz.getSuperclass(), "clazz.superclass");
        }
        return false;
    }
}

