/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.io.IOException;
import logisticspipes.LogisticsPipes;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.utils.MinecraftColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.texture.PngSizeInfo;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResource;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.gui.GuiDrawer;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.DrawableImageParagraphKt;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.math.MutableRectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\r\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J(\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J\u001e\u0010\u001e\u001a\u00020\u00172\u0006\u0010\u001f\u001a\u00020\u001d2\u0006\u0010\u001c\u001a\u00020\u001d2\u0006\u0010 \u001a\u00020\u0003J`\u0010!\u001a\u00020\u00172\u0006\u0010\"\u001a\u00020#2\u0006\u0010$\u001a\u00020\u00192\u0006\u0010%\u001a\u00020\u00192\u0006\u0010&\u001a\u00020\u00192\u0006\u0010'\u001a\u00020\u00192\u0006\u0010(\u001a\u00020)2\u0006\u0010*\u001a\u00020)2\u0006\u0010+\u001a\u00020)2\u0006\u0010,\u001a\u00020)2\u0006\u0010-\u001a\u00020)2\u0006\u0010.\u001a\u00020)H\u0002J$\u0010/\u001a\u000e\u0012\u0004\u0012\u00020)\u0012\u0004\u0012\u00020)002\u0006\u00101\u001a\u00020)2\u0006\u00102\u001a\u00020)H\u0016R\u0011\u0010\u0005\u001a\u00020\u00068F\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\t\u001a\u0004\u0018\u00010\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000b\u001a\u0004\u0018\u00010\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\f\u0010\r\"\u0004\b\u000e\u0010\u000fR\u001a\u0010\u0010\u001a\u00020\u0011X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0012\u0010\u0013\"\u0004\b\u0014\u0010\u0015\u00a8\u00063"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableImage;", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "imageResource", "Lnet/minecraft/util/ResourceLocation;", "(Lnet/minecraft/util/ResourceLocation;)V", "broken", "", "getBroken", "()Z", "imageSize", "Lnet/minecraft/client/renderer/texture/PngSizeInfo;", "parent", "getParent", "()Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "setParent", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;)V", "relativeBody", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "getRelativeBody", "()Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "setRelativeBody", "(Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;)V", "draw", "", "mouseX", "", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "drawImage", "imageBody", "image", "putTexturedImage", "bufferBuilder", "Lnet/minecraft/client/renderer/BufferBuilder;", "x0", "y0", "x1", "y1", "uw", "", "vh", "u0", "v0", "u1", "v1", "setPos", "Llogisticspipes/kotlin/Pair;", "x", "y", "logisticspipes"})
public final class DrawableImage
implements Drawable {
    @NotNull
    private ResourceLocation imageResource;
    @NotNull
    private MutableRectangle relativeBody;
    @Nullable
    private Drawable parent;
    @Nullable
    private PngSizeInfo imageSize;

    public DrawableImage(@NotNull ResourceLocation imageResource) {
        PngSizeInfo pngSizeInfo;
        DrawableImage drawableImage;
        Intrinsics.checkNotNullParameter(imageResource, "imageResource");
        this.imageResource = imageResource;
        this.relativeBody = new MutableRectangle();
        DrawableImage drawableImage2 = this;
        try {
            drawableImage = drawableImage2;
            IResource resource = Minecraft.func_71410_x().func_110442_L().func_110536_a(this.imageResource);
            pngSizeInfo = PngSizeInfo.func_188532_a((IResource)resource);
        }
        catch (IOException iOException) {
            drawableImage = drawableImage2;
            LogisticsPipes.log.error("File not found: " + this.imageResource.func_110623_a());
            pngSizeInfo = null;
        }
        drawableImage.imageSize = pngSizeInfo;
    }

    @Override
    @NotNull
    public MutableRectangle getRelativeBody() {
        return this.relativeBody;
    }

    public void setRelativeBody(@NotNull MutableRectangle mutableRectangle) {
        Intrinsics.checkNotNullParameter(mutableRectangle, "<set-?>");
        this.relativeBody = mutableRectangle;
    }

    @Override
    @Nullable
    public Drawable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Drawable drawable) {
        this.parent = drawable;
    }

    public final boolean getBroken() {
        return this.imageSize == null;
    }

    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        if (this.imageSize != null) {
            this.drawImage(this.getAbsoluteBody(), visibleArea, this.imageResource);
        } else {
            GuiDrawer.INSTANCE.drawOutlineRect(this.getAbsoluteBody(), MinecraftColor.WHITE.getColorCode());
        }
    }

    private final void putTexturedImage(BufferBuilder bufferBuilder, float x0, float y0, float x1, float y1, int uw, int vh, int u0, int v0, int u1, int v1) {
        double atlasWidthScale = 1.0 / (double)uw;
        double atlasHeightScale = 1.0 / (double)vh;
        double u0S = (double)u0 * atlasWidthScale;
        double v0S = (double)v0 * atlasHeightScale;
        double u1S = (double)u1 * atlasWidthScale;
        double v1S = (double)v1 * atlasHeightScale;
        DrawableImageParagraphKt.pos(bufferBuilder, x0, y1, 0.0f).func_187315_a(u0S, v1S).func_181675_d();
        DrawableImageParagraphKt.pos(bufferBuilder, x1, y1, 0.0f).func_187315_a(u1S, v1S).func_181675_d();
        DrawableImageParagraphKt.pos(bufferBuilder, x1, y0, 0.0f).func_187315_a(u1S, v0S).func_181675_d();
        DrawableImageParagraphKt.pos(bufferBuilder, x0, y0, 0.0f).func_187315_a(u0S, v0S).func_181675_d();
    }

    public final void drawImage(@NotNull IRectangle imageBody, @NotNull IRectangle visibleArea, @NotNull ResourceLocation image) {
        Intrinsics.checkNotNullParameter(imageBody, "imageBody");
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        Intrinsics.checkNotNullParameter(image, "image");
        IRectangle visibleImageBody = imageBody.overlap(visibleArea);
        float xOffset = Math.min(imageBody.getX0() - visibleArea.getX0(), 0.0f);
        float yOffset = Math.min(imageBody.getY0() - visibleArea.getY0(), 0.0f);
        MutableRectangle visibleImageTexture = MutableRectangle.Companion.fromRectangle(visibleImageBody).setPos(xOffset, -yOffset);
        GlStateManager.func_179094_E();
        Minecraft.func_71410_x().func_110434_K().func_110577_a(image);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder bufferBuilder = tessellator.func_178180_c();
        bufferBuilder.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        Intrinsics.checkNotNullExpressionValue(bufferBuilder, "bufferBuilder");
        this.putTexturedImage(bufferBuilder, visibleImageBody.getX0(), visibleImageBody.getY0(), visibleImageBody.getX1(), visibleImageBody.getY1(), imageBody.getRoundedWidth(), imageBody.getRoundedHeight(), visibleImageTexture.getRoundedLeft(), visibleImageTexture.getRoundedTop(), visibleImageTexture.getRoundedRight(), visibleImageTexture.getRoundedBottom());
        tessellator.func_78381_a();
        GlStateManager.func_179121_F();
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> setPos(int x, int y) {
        if (this.imageSize != null) {
            MutableRectangle mutableRectangle = this.getRelativeBody();
            PngSizeInfo pngSizeInfo = this.imageSize;
            Intrinsics.checkNotNull(pngSizeInfo);
            int n = pngSizeInfo.field_188533_a;
            PngSizeInfo pngSizeInfo2 = this.imageSize;
            Intrinsics.checkNotNull(pngSizeInfo2);
            mutableRectangle.setSize(n, pngSizeInfo2.field_188534_b);
            PngSizeInfo pngSizeInfo3 = this.imageSize;
            Intrinsics.checkNotNull(pngSizeInfo3);
            int n2 = pngSizeInfo3.field_188533_a;
            Drawable drawable = this.getParent();
            Intrinsics.checkNotNull(drawable);
            if (n2 > drawable.getWidth()) {
                Drawable drawable2 = this.getParent();
                Intrinsics.checkNotNull(drawable2);
                float downScaleFactor = (float)drawable2.getWidth() / (float)this.getWidth();
                this.getRelativeBody().scale(downScaleFactor);
            }
        } else {
            this.getRelativeBody().setSize(20, 20);
        }
        return Drawable.super.setPos(x, y);
    }
}

