/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.EnumSet;
import java.util.Set;
import logisticspipes.LPItems;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Lazy;
import logisticspipes.kotlin.LazyKt;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.Unit;
import logisticspipes.kotlin.jvm.internal.DefaultConstructorMarker;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.utils.MinecraftColor;
import logisticspipes.utils.item.ItemStackRenderer;
import net.minecraft.item.Item;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.gui.GuiDrawer;
import network.rs485.logisticspipes.gui.font.LPFontRenderer;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.DrawableMenuListEntry;
import network.rs485.logisticspipes.gui.guidebook.GuiGuideBook;
import network.rs485.logisticspipes.gui.guidebook.GuideBookMouseInteractable;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.math.MutableRectangle;
import network.rs485.markdown.TextFormat;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0000\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 )2\u00020\u00012\u00020\u0002:\u0001)B\u001d\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0006\u001a\u00020\u0004\u00a2\u0006\u0002\u0010\u0007J(\u0010\u0017\u001a\u00020\u00182\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010\u001b\u001a\u00020\t2\u0006\u0010\u001c\u001a\u00020\u001dH\u0016J.\u0010\u001e\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\t2\u0006\u0010 \u001a\u00020\u000b2\f\u0010!\u001a\b\u0018\u00010\"R\u00020#H\u0016J\u0018\u0010$\u001a\u00020\u001f2\u0006\u0010\u0019\u001a\u00020\t2\u0006\u0010\u001a\u001a\u00020\tH\u0016J$\u0010%\u001a\u000e\u0012\u0004\u0012\u00020\u000b\u0012\u0004\u0012\u00020\u000b0&2\u0006\u0010'\u001a\u00020\u000b2\u0006\u0010(\u001a\u00020\u000bH\u0016R\u000e\u0010\u0006\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\u000bX\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0005\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u001c\u0010\u000f\u001a\u0004\u0018\u00010\u0001X\u0096\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0010\u0010\u0011\"\u0004\b\u0012\u0010\u0013R\u0014\u0010\u0014\u001a\u00020\u000eX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0016\u00a8\u0006*"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableMenuListEntry;", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuideBookMouseInteractable;", "linkedPage", "", "pageName", "icon", "(Ljava/lang/String;Ljava/lang/String;Ljava/lang/String;)V", "iconScale", "", "iconSize", "", "itemOffset", "itemRect", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "parent", "getParent", "()Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "setParent", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;)V", "relativeBody", "getRelativeBody", "()Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "draw", "", "mouseX", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "inBookMouseClicked", "", "mouseButton", "guideActionListener", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook$ActionListener;", "Lnetwork/rs485/logisticspipes/gui/guidebook/GuiGuideBook;", "isMouseHovering", "setPos", "Llogisticspipes/kotlin/Pair;", "x", "y", "Companion", "logisticspipes"})
public final class DrawableMenuListEntry
implements Drawable,
GuideBookMouseInteractable {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final String linkedPage;
    @NotNull
    private final String pageName;
    @NotNull
    private final String icon;
    private final float iconScale;
    private final int iconSize;
    @NotNull
    private final MutableRectangle itemRect;
    private final int itemOffset;
    @NotNull
    private final MutableRectangle relativeBody;
    @Nullable
    private Drawable parent;
    @NotNull
    private static final Lazy<ItemStackRenderer> itemStackRenderer$delegate = LazyKt.lazy(Companion.itemStackRenderer.2.INSTANCE);

    public DrawableMenuListEntry(@NotNull String linkedPage, @NotNull String pageName, @NotNull String icon) {
        Intrinsics.checkNotNullParameter(linkedPage, "linkedPage");
        Intrinsics.checkNotNullParameter(pageName, "pageName");
        Intrinsics.checkNotNullParameter(icon, "icon");
        this.linkedPage = linkedPage;
        this.pageName = pageName;
        this.icon = icon;
        this.iconScale = 1.0f;
        this.iconSize = (int)((float)16 * this.iconScale);
        this.itemRect = new MutableRectangle();
        this.itemOffset = (24 - this.iconSize) / 2;
        this.relativeBody = new MutableRectangle();
        this.getRelativeBody().setSize(4 * this.itemOffset + this.iconSize + GuiDrawer.INSTANCE.getLpFontRenderer().getStringWidth(this.pageName), 24);
        this.itemRect.setSize(this.iconSize, this.iconSize);
    }

    @Override
    @NotNull
    public MutableRectangle getRelativeBody() {
        return this.relativeBody;
    }

    @Override
    @Nullable
    public Drawable getParent() {
        return this.parent;
    }

    @Override
    public void setParent(@Nullable Drawable drawable) {
        this.parent = drawable;
    }

    @Override
    public boolean isMouseHovering(float mouseX, float mouseY) {
        return this.getAbsoluteBody().contains(mouseX, mouseY);
    }

    @Override
    public boolean inBookMouseClicked(float mouseX, float mouseY, int mouseButton, @Nullable GuiGuideBook.ActionListener guideActionListener) {
        Unit unit;
        GuiGuideBook.ActionListener actionListener = guideActionListener;
        if (actionListener != null) {
            actionListener.onMenuButtonClick(this.linkedPage);
            unit = Unit.INSTANCE;
        } else {
            unit = null;
        }
        return unit != null;
    }

    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        boolean hovered = visibleArea.contains(mouseX, mouseY) && this.isMouseHovering(mouseX, mouseY);
        GuiDrawer.INSTANCE.drawBorderedTile(this.getAbsoluteBody(), hovered, true, true, false);
        this.itemRect.setPos(this.getLeft() + (float)this.itemOffset, this.getTop() + (float)this.itemOffset);
        if (this.itemRect.intersects(visibleArea)) {
            int textColor = !hovered ? MinecraftColor.WHITE.getColorCode() : -96;
            int textVerticalOffset = (this.getHeight() - GuiDrawer.INSTANCE.getLpFontRenderer().getFontHeight(1.0f)) / 2;
            LPFontRenderer lPFontRenderer = GuiDrawer.INSTANCE.getLpFontRenderer();
            float f = this.itemRect.getRight() + (float)this.itemOffset;
            float f2 = this.getTop() + (float)textVerticalOffset;
            EnumSet<Enum> enumSet = EnumSet.of((Enum)TextFormat.Shadow);
            Intrinsics.checkNotNullExpressionValue(enumSet, "of(TextFormat.Shadow)");
            lPFontRenderer.drawString(this.pageName, f, f2, textColor, (Set<? extends TextFormat>)enumSet, 1.0f);
            Item item = (Item)Item.field_150901_e.func_82594_a((Object)new ResourceLocation(this.icon));
            if (item == null) {
                item = LPItems.brokenItem;
            }
            Item item2 = item;
            Companion.getItemStackRenderer().renderItemInGui(this.itemRect.getLeft(), this.itemRect.getTop(), item2, 0.0f, this.iconScale);
        }
        if (hovered) {
            GuiDrawer.INSTANCE.drawInteractionIndicator(mouseX, mouseY);
        }
    }

    @Override
    @NotNull
    public Pair<Integer, Integer> setPos(int x, int y) {
        this.getRelativeBody().setPos(x, y);
        this.itemRect.setPos(this.getLeft() + (float)this.itemOffset, this.getTop() + (float)this.itemOffset);
        return Drawable.super.setPos(x, y);
    }

    @Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002R\u001b\u0010\u0003\u001a\u00020\u00048FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0007\u0010\b\u001a\u0004\b\u0005\u0010\u0006\u00a8\u0006\t"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableMenuListEntry$Companion;", "", "()V", "itemStackRenderer", "Llogisticspipes/utils/item/ItemStackRenderer;", "getItemStackRenderer", "()Llogisticspipes/utils/item/ItemStackRenderer;", "itemStackRenderer$delegate", "Llogisticspipes/kotlin/Lazy;", "logisticspipes"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final ItemStackRenderer getItemStackRenderer() {
            Lazy lazy = itemStackRenderer$delegate;
            return (ItemStackRenderer)lazy.getValue();
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

