/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.guidebook;

import java.util.Set;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import network.rs485.logisticspipes.gui.GuiDrawer;
import network.rs485.logisticspipes.gui.guidebook.DrawableWord;
import network.rs485.logisticspipes.gui.guidebook.LinkInteractable;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.markdown.ElementKt;
import network.rs485.markdown.InlineDrawableState;
import network.rs485.markdown.TextFormat;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000:\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0007\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u000e\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\u0010\u0006\u001a\u0004\u0018\u00010\u0007\u00a2\u0006\u0002\u0010\bJ(\u0010\t\u001a\u00020\n2\u0006\u0010\u000b\u001a\u00020\u00032\u0006\u0010\f\u001a\u00020\u00032\u0006\u0010\r\u001a\u00020\u00032\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0006\u0010\u0010\u001a\u00020\nJ\u000e\u0010\u0011\u001a\u00020\n2\u0006\u0010\u0012\u001a\u00020\u0013J\b\u0010\u0014\u001a\u00020\u0015H\u0016R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0016"}, d2={"Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableSpace;", "Lnetwork/rs485/logisticspipes/gui/guidebook/DrawableWord;", "scale", "", "state", "Lnetwork/rs485/markdown/InlineDrawableState;", "linkInteractable", "Lnetwork/rs485/logisticspipes/gui/guidebook/LinkInteractable;", "(FLnetwork/rs485/markdown/InlineDrawableState;Lnetwork/rs485/logisticspipes/gui/guidebook/LinkInteractable;)V", "draw", "", "mouseX", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "resetWidth", "setWidth", "newWidth", "", "toString", "", "logisticspipes"})
public final class DrawableSpace
extends DrawableWord {
    private final float scale;

    public DrawableSpace(float scale, @NotNull InlineDrawableState state, @Nullable LinkInteractable linkInteractable) {
        Intrinsics.checkNotNullParameter(state, "state");
        super(" ", scale, state, linkInteractable);
        this.scale = scale;
    }

    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        if (this.getWidth() > 0) {
            LinkInteractable linkInteractable = this.getLinkInteractable();
            if (linkInteractable != null) {
                linkInteractable.isMouseHovering(mouseX, mouseY);
            }
            LinkInteractable linkInteractable2 = this.getLinkInteractable();
            int updatedColor = linkInteractable2 != null ? linkInteractable2.updateColor(this.getColor()) : this.getColor();
            Object object = this.getLinkInteractable();
            if (object == null || (object = object.updateFormat(this.getFormat())) == null) {
                object = this.getFormat();
            }
            Set<TextFormat> updatedFormat = object;
            GuiDrawer.INSTANCE.getLpFontRenderer().drawSpace(this.getLeft(), this.getTop(), this.getWidth(), updatedColor, ElementKt.italic(updatedFormat), ElementKt.underline(updatedFormat), ElementKt.strikethrough(updatedFormat), ElementKt.shadow(updatedFormat), this.scale);
        }
    }

    public final void setWidth(int newWidth) {
        this.getRelativeBody().setSize(newWidth, this.getRelativeBody().getRoundedHeight());
    }

    public final void resetWidth() {
        this.setWidth(GuiDrawer.INSTANCE.getLpFontRenderer().getStringWidth(" ", ElementKt.italic(this.getFormat()), ElementKt.bold(this.getFormat()), this.scale));
    }

    @Override
    @NotNull
    public String toString() {
        return "Space of size " + this.getWidth() + " with formatting: " + this.getFormat() + '.';
    }
}

