/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.widget;

import java.util.List;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.NoWhenBranchMatchedException;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.GlStateManager;
import network.rs485.logisticspipes.gui.GuiDrawer;
import network.rs485.logisticspipes.gui.HorizontalAlignment;
import network.rs485.logisticspipes.gui.Margin;
import network.rs485.logisticspipes.gui.Size;
import network.rs485.logisticspipes.gui.VerticalAlignment;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.guidebook.MouseHoverable;
import network.rs485.logisticspipes.gui.widget.LPGuiWidget;
import network.rs485.logisticspipes.gui.widget.Tooltipped;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.TextUtil;
import network.rs485.logisticspipes.util.math.MutableRectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000j\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\f\n\u0002\u0010\u0002\n\u0000\n\u0002\u0010\u0007\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u000b\u0018\u00002\u00020\u00012\u00020\u00022\u00020\u0003B]\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u0012\u0006\u0010\b\u001a\u00020\t\u0012\u0006\u0010\n\u001a\u00020\u000b\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0006\u0010\u0012\u001a\u00020\u0007\u0012\u0006\u0010\u0013\u001a\u00020\t\u0012\u0006\u0010\u0014\u001a\u00020\u0015\u0012\u0006\u0010\u0016\u001a\u00020\u0007\u00a2\u0006\u0002\u0010\u0017J(\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(2\u0006\u0010*\u001a\u00020(2\u0006\u0010+\u001a\u00020,H\u0016J\u000e\u0010-\u001a\b\u0012\u0004\u0012\u00020\u00110.H\u0016J\b\u0010/\u001a\u00020&H\u0016J\u0018\u00100\u001a\u00020\u00152\u0006\u0010'\u001a\u00020(2\u0006\u0010)\u001a\u00020(H\u0016J\u0018\u00101\u001a\u00020&2\u0006\u00102\u001a\u00020\u00072\u0006\u00103\u001a\u00020\u0007H\u0016J\b\u00104\u001a\u00020\u0011H\u0016J\u0010\u00105\u001a\u00020\u00112\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\b\u00106\u001a\u00020&H\u0002J\u000e\u00107\u001a\u00020&2\u0006\u00108\u001a\u00020\u0011J\f\u0010\u0006\u001a\u00020\u0007*\u00020\u0011H\u0002R\u000e\u0010\u0016\u001a\u00020\u0007X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0014\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0019X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u001a\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR\u0014\u0010\u001d\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001e\u0010\u001cR\u0014\u0010\u001f\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b \u0010\u001cR\u0014\u0010!\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\"\u0010\u001cR\u000e\u0010#\u001a\u00020\u0015X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0012\u001a\u00020\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010$\u001a\u00020\u0011X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u00069"}, d2={"Lnetwork/rs485/logisticspipes/gui/widget/LabelWidget;", "Lnetwork/rs485/logisticspipes/gui/widget/LPGuiWidget;", "Lnetwork/rs485/logisticspipes/gui/guidebook/MouseHoverable;", "Lnetwork/rs485/logisticspipes/gui/widget/Tooltipped;", "parent", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "width", "", "xPosition", "Lnetwork/rs485/logisticspipes/gui/HorizontalAlignment;", "yPosition", "Lnetwork/rs485/logisticspipes/gui/VerticalAlignment;", "xSize", "Lnetwork/rs485/logisticspipes/gui/Size;", "margin", "Lnetwork/rs485/logisticspipes/gui/Margin;", "text", "", "textColor", "textAlignment", "extendable", "", "backgroundColor", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;ILnetwork/rs485/logisticspipes/gui/HorizontalAlignment;Lnetwork/rs485/logisticspipes/gui/VerticalAlignment;Lnetwork/rs485/logisticspipes/gui/Size;Lnetwork/rs485/logisticspipes/gui/Margin;Ljava/lang/String;ILnetwork/rs485/logisticspipes/gui/HorizontalAlignment;ZI)V", "fullBody", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "maxHeight", "getMaxHeight", "()I", "maxWidth", "getMaxWidth", "minHeight", "getMinHeight", "minWidth", "getMinWidth", "overflowing", "trimmedText", "draw", "", "mouseX", "", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "getTooltipText", "", "initWidget", "isMouseHovering", "setSize", "newWidth", "newHeight", "toString", "trimText", "updateConstraints", "updateText", "newText", "logisticspipes"})
public final class LabelWidget
extends LPGuiWidget
implements MouseHoverable,
Tooltipped {
    @NotNull
    private String text;
    private final int textColor;
    @NotNull
    private final HorizontalAlignment textAlignment;
    private boolean extendable;
    private int backgroundColor;
    private boolean overflowing;
    private final int minWidth;
    private final int minHeight;
    private final int maxWidth;
    private final int maxHeight;
    @NotNull
    private String trimmedText;
    @NotNull
    private final MutableRectangle fullBody;

    public LabelWidget(@NotNull Drawable parent, int width, @NotNull HorizontalAlignment xPosition, @NotNull VerticalAlignment yPosition, @NotNull Size xSize, @NotNull Margin margin, @NotNull String text, int textColor, @NotNull HorizontalAlignment textAlignment, boolean extendable, int backgroundColor) {
        int n;
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter((Object)xPosition, "xPosition");
        Intrinsics.checkNotNullParameter((Object)yPosition, "yPosition");
        Intrinsics.checkNotNullParameter((Object)xSize, "xSize");
        Intrinsics.checkNotNullParameter(margin, "margin");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter((Object)textAlignment, "textAlignment");
        super(parent, xPosition, yPosition, xSize, Size.FIXED, margin);
        this.text = text;
        this.textColor = textColor;
        this.textAlignment = textAlignment;
        this.extendable = extendable;
        this.backgroundColor = backgroundColor;
        switch (WhenMappings.$EnumSwitchMapping$0[xSize.ordinal()]) {
            case 1: {
                n = width;
                break;
            }
            case 2: {
                n = this.width(this.text) + 2;
                break;
            }
            case 3: {
                n = 30;
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        this.minWidth = n;
        this.minHeight = GuiDrawer.INSTANCE.getMcFontRenderer().field_78288_b + 1;
        this.maxWidth = parent.getHeight();
        this.maxHeight = parent.getHeight();
        this.trimmedText = this.trimText(this.text);
        this.fullBody = new MutableRectangle();
    }

    @Override
    public int getMinWidth() {
        return this.minWidth;
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @Override
    public int getMaxWidth() {
        return this.maxWidth;
    }

    @Override
    public int getMaxHeight() {
        return this.maxHeight;
    }

    @Override
    public void initWidget() {
        this.setSize(this.getMinWidth(), this.getMinHeight());
        this.updateConstraints();
    }

    public final void updateText(@NotNull String newText) {
        Intrinsics.checkNotNullParameter(newText, "newText");
        this.text = newText;
        this.updateConstraints();
    }

    private final void updateConstraints() {
        this.trimmedText = this.trimText(this.text);
        MutableRectangle.translate$default(this.fullBody.setPosFromRectangle(this.getAbsoluteBody()), 0, -2, 1, null).grow(1);
        this.fullBody.setSize(this.width(this.text), this.getMinHeight());
        this.overflowing = !Intrinsics.areEqual(this.text, this.trimmedText);
    }

    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        int n;
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        boolean hovering = this.isMouseHovering(mouseX, mouseY);
        GlStateManager.func_179094_E();
        GlStateManager.func_179126_j();
        if (hovering && this.overflowing && this.extendable) {
            GuiDrawer.INSTANCE.drawRect(this.fullBody.translated(this.getAbsoluteBody()), this.backgroundColor);
        }
        Pair<HorizontalAlignment, String> pair = this.overflowing ? TuplesKt.to(HorizontalAlignment.LEFT, hovering && this.extendable ? this.text : this.trimmedText) : TuplesKt.to(this.textAlignment, this.text);
        HorizontalAlignment effectiveAlignment = pair.component1();
        String effectiveText = pair.component2();
        FontRenderer fontRenderer = GuiDrawer.INSTANCE.getMcFontRenderer();
        switch (WhenMappings.$EnumSwitchMapping$1[effectiveAlignment.ordinal()]) {
            case 1: {
                n = this.getAbsoluteBody().getRoundedLeft();
                break;
            }
            case 2: {
                n = this.getAbsoluteBody().getRoundedLeft() + (this.getWidth() - this.width(effectiveText)) / 2;
                break;
            }
            case 3: {
                n = this.getAbsoluteBody().getRoundedRight() - this.width(effectiveText);
                break;
            }
            default: {
                throw new NoWhenBranchMatchedException();
            }
        }
        fontRenderer.func_78276_b(effectiveText, n, this.getAbsoluteBody().getRoundedY(), this.textColor);
        GlStateManager.func_179097_i();
        GlStateManager.func_179121_F();
    }

    private final String trimText(String text) {
        return TextUtil.getTrimmedString$default(text, this.getWidth(), GuiDrawer.INSTANCE.getMcFontRenderer(), null, 8, null);
    }

    @Override
    public void setSize(int newWidth, int newHeight) {
        this.getRelativeBody().setSize(newWidth, newHeight);
        this.updateConstraints();
    }

    @Override
    @NotNull
    public List<String> getTooltipText() {
        return this.overflowing && !this.extendable ? CollectionsKt.listOf(this.text) : CollectionsKt.emptyList();
    }

    @Override
    public boolean isMouseHovering(float mouseX, float mouseY) {
        return this.getAbsoluteBody().contains(mouseX, mouseY);
    }

    private final int width(String $this$width) {
        return GuiDrawer.INSTANCE.getMcFontRenderer().func_78256_a($this$width);
    }

    @NotNull
    public String toString() {
        return "LabelWidget: " + this.text + ", " + this.getAbsoluteBody();
    }

    @Metadata(mv={1, 7, 1}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;
        public static final /* synthetic */ int[] $EnumSwitchMapping$1;

        static {
            int[] nArray = new int[Size.values().length];
            nArray[Size.FIXED.ordinal()] = 1;
            nArray[Size.MIN.ordinal()] = 2;
            nArray[Size.GROW.ordinal()] = 3;
            $EnumSwitchMapping$0 = nArray;
            nArray = new int[HorizontalAlignment.values().length];
            nArray[HorizontalAlignment.LEFT.ordinal()] = 1;
            nArray[HorizontalAlignment.CENTER.ordinal()] = 2;
            nArray[HorizontalAlignment.RIGHT.ordinal()] = 3;
            $EnumSwitchMapping$1 = nArray;
        }
    }
}

