/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.gui.widget;

import java.util.List;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.math.MathKt;
import logisticspipes.utils.Color;
import net.minecraft.client.renderer.GlStateManager;
import network.rs485.logisticspipes.gui.HorizontalAlignment;
import network.rs485.logisticspipes.gui.Margin;
import network.rs485.logisticspipes.gui.Size;
import network.rs485.logisticspipes.gui.VerticalAlignment;
import network.rs485.logisticspipes.gui.guidebook.Drawable;
import network.rs485.logisticspipes.gui.widget.LPGuiButton;
import network.rs485.logisticspipes.gui.widget.Tooltipped;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.TextUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000d\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\u0007\n\u0002\b\u000e\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0007\b\u0016\u0018\u00002\u00020\u00012\u00020\u0002BY\u0012\u0006\u0010\u0003\u001a\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u0012\u0006\u0010\u000b\u001a\u00020\n\u0012\u0006\u0010\f\u001a\u00020\r\u0012\u0006\u0010\u000e\u001a\u00020\u000f\u0012\u0006\u0010\u0010\u001a\u00020\u0011\u0012\u0012\u0010\u0012\u001a\u000e\u0012\u0004\u0012\u00020\u0014\u0012\u0004\u0012\u00020\u00110\u0013\u00a2\u0006\u0002\u0010\u0015J(\u0010%\u001a\u00020&2\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00172\u0006\u0010)\u001a\u00020\u00172\u0006\u0010*\u001a\u00020+H\u0016J\u000e\u0010,\u001a\b\u0012\u0004\u0012\u00020\u000f0-H\u0016J \u0010.\u001a\u00020\u00112\u0006\u0010'\u001a\u00020\u00172\u0006\u0010(\u001a\u00020\u00172\u0006\u0010/\u001a\u00020\u0014H\u0016J\u0018\u00100\u001a\u00020&2\u0006\u00101\u001a\u00020\u00142\u0006\u00102\u001a\u00020\u0014H\u0016J\u0010\u00103\u001a\u00020\u000f2\u0006\u0010\u000e\u001a\u00020\u000fH\u0002R\u0014\u0010\u0016\u001a\u00020\u00178BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\u0019R\u0014\u0010\u001a\u001a\u00020\u0014X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001b\u0010\u001cR$\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u001d\u001a\u00020\u000f@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u001e\u0010\u001f\"\u0004\b \u0010!R\u000e\u0010\"\u001a\u00020\u000fX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0011\u0010#\u001a\u00020\u0014\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010\u001c\u00a8\u00064"}, d2={"Lnetwork/rs485/logisticspipes/gui/widget/TextButton;", "Lnetwork/rs485/logisticspipes/gui/widget/LPGuiButton;", "Lnetwork/rs485/logisticspipes/gui/widget/Tooltipped;", "parent", "Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;", "xPosition", "Lnetwork/rs485/logisticspipes/gui/HorizontalAlignment;", "yPosition", "Lnetwork/rs485/logisticspipes/gui/VerticalAlignment;", "xSize", "Lnetwork/rs485/logisticspipes/gui/Size;", "ySize", "margin", "Lnetwork/rs485/logisticspipes/gui/Margin;", "text", "", "enabled", "", "onClickAction", "Llogisticspipes/kotlin/Function1;", "", "(Lnetwork/rs485/logisticspipes/gui/guidebook/Drawable;Lnetwork/rs485/logisticspipes/gui/HorizontalAlignment;Lnetwork/rs485/logisticspipes/gui/VerticalAlignment;Lnetwork/rs485/logisticspipes/gui/Size;Lnetwork/rs485/logisticspipes/gui/Size;Lnetwork/rs485/logisticspipes/gui/Margin;Ljava/lang/String;ZLkotlin/jvm/functions/Function1;)V", "centerX", "", "getCenterX", "()F", "minHeight", "getMinHeight", "()I", "value", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "trimmedText", "yOffset", "getYOffset", "draw", "", "mouseX", "mouseY", "delta", "visibleArea", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "getTooltipText", "", "mouseClicked", "mouseButton", "setSize", "newWidth", "newHeight", "trimText", "logisticspipes"})
public class TextButton
extends LPGuiButton
implements Tooltipped {
    private final int minHeight;
    @NotNull
    private String text;
    @NotNull
    private String trimmedText;
    private final int yOffset;

    public TextButton(@NotNull Drawable parent, @NotNull HorizontalAlignment xPosition, @NotNull VerticalAlignment yPosition, @NotNull Size xSize, @NotNull Size ySize, @NotNull Margin margin, @NotNull String text, boolean enabled, @NotNull Function1<? super Integer, Boolean> onClickAction) {
        Intrinsics.checkNotNullParameter(parent, "parent");
        Intrinsics.checkNotNullParameter((Object)xPosition, "xPosition");
        Intrinsics.checkNotNullParameter((Object)yPosition, "yPosition");
        Intrinsics.checkNotNullParameter((Object)xSize, "xSize");
        Intrinsics.checkNotNullParameter((Object)ySize, "ySize");
        Intrinsics.checkNotNullParameter(margin, "margin");
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(onClickAction, "onClickAction");
        super(parent, xPosition, yPosition, xSize, ySize, margin, onClickAction);
        this.minHeight = 20;
        this.setEnabled(enabled);
        this.text = text;
        this.trimmedText = this.trimText(text);
        this.yOffset = (this.getRelativeBody().getRoundedHeight() - this.getHelper().getMcFontRenderer().field_78288_b) / 2 + 1;
    }

    @Override
    public int getMinHeight() {
        return this.minHeight;
    }

    @NotNull
    public final String getText() {
        return this.text;
    }

    public final void setText(@NotNull String value) {
        Intrinsics.checkNotNullParameter(value, "value");
        this.text = value;
        this.trimmedText = this.trimText(value);
    }

    public final int getYOffset() {
        return this.yOffset;
    }

    private final float getCenterX() {
        return this.getRelativeBody().getWidth() / (float)2;
    }

    @Override
    public void setSize(int newWidth, int newHeight) {
        super.setSize(newWidth, newHeight);
        this.setText(this.text);
    }

    private final String trimText(String text) {
        return TextUtil.getTrimmedString$default(text, this.getRelativeBody().getRoundedWidth() - 4, this.getHelper().getMcFontRenderer(), null, 8, null);
    }

    @Override
    public void draw(float mouseX, float mouseY, float delta, @NotNull IRectangle visibleArea) {
        Intrinsics.checkNotNullParameter(visibleArea, "visibleArea");
        super.draw(mouseX, mouseY, delta, visibleArea);
        Color color = !this.getEnabled() ? Color.TEXT_DISABLED : (this.isMouseHovering(mouseX, mouseY) ? Color.TEXT_HOVERED : Color.TEXT_WHITE);
        int yOffset = (this.getRelativeBody().getRoundedHeight() - this.getHelper().getMcFontRenderer().field_78288_b) / 2 + 1;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        this.getHelper().drawCenteredString(this.trimmedText, MathKt.roundToInt(this.getAbsoluteBody().getLeft() + this.getCenterX()), this.getAbsoluteBody().getRoundedY() + yOffset, color.getValue(), true);
        GlStateManager.func_179084_k();
    }

    @Override
    public boolean mouseClicked(float mouseX, float mouseY, int mouseButton) {
        return this.getEnabled() ? this.getOnClickAction().invoke(mouseButton) : false;
    }

    @Override
    @NotNull
    public List<String> getTooltipText() {
        return !Intrinsics.areEqual(this.trimmedText, this.text) ? CollectionsKt.listOf(this.text) : CollectionsKt.emptyList();
    }
}

