/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.inventory.container;

import java.util.ArrayList;
import java.util.Collection;
import java.util.EnumSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import logisticspipes.LogisticsPipes;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.NotImplementedError;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.functions.Function0;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.utils.gui.ModuleSlot;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.ClickType;
import net.minecraft.inventory.Container;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Slot;
import net.minecraft.item.ItemStack;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import network.rs485.logisticspipes.gui.widget.FuzzyItemSlot;
import network.rs485.logisticspipes.gui.widget.GhostItemSlot;
import network.rs485.logisticspipes.gui.widget.GhostSlot;
import network.rs485.logisticspipes.gui.widget.Item;
import network.rs485.logisticspipes.gui.widget.LockedSlot;
import network.rs485.logisticspipes.gui.widget.Unmodifiable;
import network.rs485.logisticspipes.property.IBitSet;
import network.rs485.logisticspipes.property.InventoryProperty;
import network.rs485.logisticspipes.util.FuzzyFlag;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000\u008c\u0001\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010%\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010!\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000b\n\u0002\b\u000f\b&\u0018\u0000*\n\b\u0000\u0010\u0001 \u0001*\u00020\u00022\u00020\u0003B\r\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\u0002\u0010\u0005J6\u0010\u0014\u001a\b\u0012\u0004\u0012\u00020\u00160\u00152\u0006\u0010\u0017\u001a\u00020\u00182\u000e\b\u0002\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u0011H&JP\u0010\u001c\u001a\u00020\u001d2\u0006\u0010\u001e\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u00112\f\u0010\"\u001a\b\u0012\u0004\u0012\u00020$0#2\f\u0010%\u001a\b\u0012\u0004\u0012\u00020'0&J4\u0010(\u001a\u00020)2\u0006\u0010\u001e\u001a\u00020\u00182\f\u0010\u0019\u001a\b\u0012\u0002\b\u0003\u0018\u00010\t2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u0010 \u001a\u00020\u00112\u0006\u0010!\u001a\u00020\u0011J.\u0010*\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u0010+\u001a\u00020\u00182\u0006\u0010\u001a\u001a\u00020\u00112\u0006\u0010\u001b\u001a\u00020\u00112\u0006\u0010,\u001a\u00020-H\u0016J\u0018\u0010.\u001a\u00020/2\u0006\u00100\u001a\u00020-2\u0006\u00101\u001a\u00020\u0016H\u0016J0\u00102\u001a\u00020/2\u0006\u00101\u001a\u00020\u00162\u0006\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J0\u00109\u001a\u00020/2\u0006\u00101\u001a\u00020\u00162\u0006\u00103\u001a\u00020-2\u0006\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0002J&\u0010:\u001a\u00020;2\u0006\u0010<\u001a\u00020\b2\f\u0010=\u001a\b\u0012\u0004\u0012\u00020\b0\u00152\u0006\u00107\u001a\u000208H\u0016J \u0010>\u001a\u00020;2\u0006\u0010<\u001a\u00020\b2\u0006\u0010?\u001a\u00020\b2\u0006\u00107\u001a\u000208H\u0016J\u0018\u0010@\u001a\u00020/2\u0006\u0010A\u001a\u00020\u00112\u0006\u0010B\u001a\u00020-H\u0016J\u0016\u0010C\u001a\u00020/2\f\u0010D\u001a\b\u0012\u0004\u0012\u00020-0\u000eH\u0017J(\u0010E\u001a\u00020-2\u0006\u0010\u001f\u001a\u00020\u00112\u0006\u00104\u001a\u00020\u00112\u0006\u00105\u001a\u0002062\u0006\u00107\u001a\u000208H\u0016J\u0018\u0010F\u001a\u00020-2\u0006\u00107\u001a\u0002082\u0006\u0010G\u001a\u00020\u0011H\u0016J\u0010\u0010H\u001a\u00020;2\u0006\u0010I\u001a\u00020\u0011H\u0016R\u001e\u0010\u0006\u001a\u0012\u0012\u0004\u0012\u00020\b\u0012\b\u0012\u0006\u0012\u0002\b\u00030\t0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0013\u0010\u0004\u001a\u00028\u0000\u00a2\u0006\n\n\u0002\u0010\f\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\r\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\b0\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0010\u001a\u00020\u0011X\u0086D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013\u00a8\u0006J"}, d2={"Lnetwork/rs485/logisticspipes/inventory/container/LPBaseContainer;", "M", "Llogisticspipes/modules/LogisticsModule;", "Lnet/minecraft/inventory/Container;", "module", "(Llogisticspipes/modules/LogisticsModule;)V", "directSlotPropertyMap", "", "Lnet/minecraft/inventory/Slot;", "Lnetwork/rs485/logisticspipes/property/InventoryProperty;", "getModule", "()Llogisticspipes/modules/LogisticsModule;", "Llogisticspipes/modules/LogisticsModule;", "playerBackpackSlots", "", "playerHotbarSlots", "slotSize", "", "getSlotSize", "()I", "addDummySlotsToContainer", "", "Lnetwork/rs485/logisticspipes/gui/widget/GhostSlot;", "overlayInventory", "Lnet/minecraft/inventory/IInventory;", "baseProperty", "startX", "startY", "addFuzzyItemSlotToContainer", "Lnetwork/rs485/logisticspipes/gui/widget/FuzzyItemSlot;", "dummyInventoryIn", "slotId", "posX", "posY", "usedFlags", "Ljava/util/EnumSet;", "Lnetwork/rs485/logisticspipes/util/FuzzyFlag;", "flagGetter", "Llogisticspipes/kotlin/Function0;", "Lnetwork/rs485/logisticspipes/property/IBitSet;", "addGhostItemSlotToContainer", "Lnetwork/rs485/logisticspipes/gui/widget/GhostItemSlot;", "addPlayerSlotsToContainer", "playerInventoryIn", "lockedStack", "Lnet/minecraft/item/ItemStack;", "applyItemStackToGhostItemSlot", "", "itemStack", "slot", "handleGhostItemSlotClick", "grabbedItemStack", "dragType", "clickTypeIn", "Lnet/minecraft/inventory/ClickType;", "player", "Lnet/minecraft/entity/player/EntityPlayer;", "handleGhostSlotClick", "handleShiftClickFromSlotToList", "", "from", "toList", "handleShiftClickFromSlotToSlot", "to", "putStackInSlot", "slotID", "stack", "setAll", "slotStacks", "slotClick", "transferStackInSlot", "index", "tryTransferSlotToGhostSlot", "slotIdx", "logisticspipes"})
public abstract class LPBaseContainer<M extends LogisticsModule>
extends Container {
    @NotNull
    private final M module;
    private final int slotSize;
    @NotNull
    private final List<Slot> playerHotbarSlots;
    @NotNull
    private final List<Slot> playerBackpackSlots;
    @NotNull
    private final Map<Slot, InventoryProperty<?>> directSlotPropertyMap;

    public LPBaseContainer(@NotNull M module) {
        Intrinsics.checkNotNullParameter(module, "module");
        this.module = module;
        this.slotSize = 18;
        this.playerHotbarSlots = new ArrayList();
        this.playerBackpackSlots = new ArrayList();
        this.directSlotPropertyMap = new LinkedHashMap();
    }

    @NotNull
    public final M getModule() {
        return this.module;
    }

    public final int getSlotSize() {
        return this.slotSize;
    }

    @NotNull
    public abstract List<GhostSlot> addDummySlotsToContainer(@NotNull IInventory var1, @Nullable InventoryProperty<?> var2, int var3, int var4);

    public static /* synthetic */ List addDummySlotsToContainer$default(LPBaseContainer lPBaseContainer, IInventory iInventory, InventoryProperty inventoryProperty, int n, int n2, int n3, Object object) {
        if (object != null) {
            throw new UnsupportedOperationException("Super calls with default arguments not supported in this target, function: addDummySlotsToContainer");
        }
        if ((n3 & 2) != 0) {
            inventoryProperty = null;
        }
        return lPBaseContainer.addDummySlotsToContainer(iInventory, inventoryProperty, n, n2);
    }

    @NotNull
    public final GhostItemSlot addGhostItemSlotToContainer(@NotNull IInventory dummyInventoryIn, @Nullable InventoryProperty<?> baseProperty, int slotId, int posX, int posY) {
        GhostItemSlot slot;
        block0: {
            Intrinsics.checkNotNullParameter(dummyInventoryIn, "dummyInventoryIn");
            slot = new GhostItemSlot(dummyInventoryIn, slotId, posX, posY);
            this.func_75146_a(slot);
            InventoryProperty<?> inventoryProperty = baseProperty;
            if (inventoryProperty == null) break block0;
            InventoryProperty<?> it = inventoryProperty;
            boolean bl = false;
            this.directSlotPropertyMap.put(slot, it);
        }
        return slot;
    }

    @NotNull
    public final FuzzyItemSlot addFuzzyItemSlotToContainer(@NotNull IInventory dummyInventoryIn, @Nullable InventoryProperty<?> baseProperty, int slotId, int posX, int posY, @NotNull EnumSet<FuzzyFlag> usedFlags, @NotNull Function0<? extends IBitSet> flagGetter) {
        FuzzyItemSlot slot;
        block0: {
            Intrinsics.checkNotNullParameter(dummyInventoryIn, "dummyInventoryIn");
            Intrinsics.checkNotNullParameter(usedFlags, "usedFlags");
            Intrinsics.checkNotNullParameter(flagGetter, "flagGetter");
            slot = new FuzzyItemSlot(dummyInventoryIn, slotId, posX, posY, usedFlags, flagGetter);
            this.func_75146_a(slot);
            InventoryProperty<?> inventoryProperty = baseProperty;
            if (inventoryProperty == null) break block0;
            InventoryProperty<?> it = inventoryProperty;
            boolean bl = false;
            this.directSlotPropertyMap.put(slot, it);
        }
        return slot;
    }

    @NotNull
    public ItemStack func_184996_a(int slotId, int dragType, @NotNull ClickType clickTypeIn, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter(clickTypeIn, "clickTypeIn");
        Intrinsics.checkNotNullParameter(player, "player");
        if (slotId < 0) {
            ItemStack itemStack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
            Intrinsics.checkNotNullExpressionValue(itemStack, "super.slotClick(slotId, \u2026ype, clickTypeIn, player)");
            return itemStack;
        }
        Slot slot = (Slot)this.field_75151_b.get(slotId);
        if (slot == null) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue(itemStack, "EMPTY");
            return itemStack;
        }
        Slot slot2 = slot;
        if (slot2 instanceof LockedSlot) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue(itemStack, "EMPTY");
            return itemStack;
        }
        if (!(slot2 instanceof GhostSlot)) {
            ItemStack itemStack = super.func_184996_a(slotId, dragType, clickTypeIn, player);
            Intrinsics.checkNotNullExpressionValue(itemStack, "super.slotClick(slotId, \u2026ype, clickTypeIn, player)");
            return itemStack;
        }
        ItemStack grabbedItemStack = player.field_71071_by.func_70445_o();
        GhostSlot ghostSlot = (GhostSlot)slot2;
        Intrinsics.checkNotNullExpressionValue(grabbedItemStack, "grabbedItemStack");
        this.handleGhostSlotClick(ghostSlot, grabbedItemStack, dragType, clickTypeIn, player);
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkNotNullExpressionValue(itemStack, "EMPTY");
        return itemStack;
    }

    @NotNull
    public ItemStack func_82846_b(@NotNull EntityPlayer player, int index) {
        Intrinsics.checkNotNullParameter(player, "player");
        Slot slot = (Slot)this.field_75151_b.get(index);
        if (slot == null) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue(itemStack, "EMPTY");
            return itemStack;
        }
        Slot slot2 = slot;
        if (!slot2.func_75216_d() || slot2 instanceof GhostSlot || slot2 instanceof ModuleSlot) {
            ItemStack itemStack = ItemStack.field_190927_a;
            Intrinsics.checkNotNullExpressionValue(itemStack, "EMPTY");
            return itemStack;
        }
        if (this.playerHotbarSlots.contains(slot2)) {
            this.handleShiftClickFromSlotToList(slot2, this.playerBackpackSlots, player);
        } else if (this.playerBackpackSlots.contains(slot2)) {
            this.handleShiftClickFromSlotToList(slot2, this.playerHotbarSlots, player);
        } else {
            LogisticsPipes.log.warn("Something is wrong, this slot is not apart of the player's inventory and wasn't dealt with properly before.");
        }
        ItemStack itemStack = ItemStack.field_190927_a;
        Intrinsics.checkNotNullExpressionValue(itemStack, "EMPTY");
        return itemStack;
    }

    public boolean tryTransferSlotToGhostSlot(int slotIdx) {
        return false;
    }

    public boolean handleShiftClickFromSlotToList(@NotNull Slot from, @NotNull List<? extends Slot> toList2, @NotNull EntityPlayer player) {
        Slot to;
        Iterable $this$forEach$iv;
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(toList2, "toList");
        Intrinsics.checkNotNullParameter(player, "player");
        if (!from.func_75216_d()) {
            return true;
        }
        Iterable $this$partition$iv = toList2;
        boolean $i$f$partition22 = false;
        ArrayList first$iv = new ArrayList();
        ArrayList second$iv = new ArrayList();
        for (Object element$iv : $this$partition$iv) {
            Slot it = (Slot)element$iv;
            boolean bl = false;
            if (it.func_75216_d()) {
                first$iv.add(element$iv);
                continue;
            }
            second$iv.add(element$iv);
        }
        Pair slots = new Pair(first$iv, second$iv);
        Iterable $i$f$partition22 = slots.getFirst();
        List it = $i$f$partition22;
        boolean bl = false;
        List list = !((Collection)it).isEmpty() ? $i$f$partition22 : null;
        if (list != null) {
            $i$f$partition22 = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                to = (Slot)element$iv;
                boolean bl2 = false;
                if (!this.handleShiftClickFromSlotToSlot(from, to, player)) continue;
                return true;
            }
        }
        $this$forEach$iv = slots.getSecond();
        it = (List)$this$forEach$iv;
        boolean bl3 = false;
        list = (List)(!((Collection)it).isEmpty() ? $this$forEach$iv : null);
        if (list != null) {
            $this$forEach$iv = list;
            boolean $i$f$forEach = false;
            for (Object element$iv : $this$forEach$iv) {
                to = (Slot)element$iv;
                boolean bl4 = false;
                if (!this.handleShiftClickFromSlotToSlot(from, to, player)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean handleShiftClickFromSlotToSlot(@NotNull Slot from, @NotNull Slot to, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter(from, "from");
        Intrinsics.checkNotNullParameter(to, "to");
        Intrinsics.checkNotNullParameter(player, "player");
        if (!from.func_75216_d()) {
            return true;
        }
        if (to instanceof GhostSlot || to instanceof ModuleSlot) {
            return false;
        }
        if (to.func_75216_d() && from.func_75211_c().func_77969_a(to.func_75211_c())) {
            int freeAmount = Math.min(to.func_75219_a(), to.func_75211_c().func_77976_d()) - to.func_75211_c().func_190916_E();
            if (freeAmount > 0) {
                ItemStack shiftedStack = from.func_75209_a(freeAmount);
                if (!(shiftedStack = from.func_190901_a(player, shiftedStack)).func_190926_b() && !to.func_75211_c().func_190926_b()) {
                    to.func_75211_c().func_190917_f(shiftedStack.func_190916_E());
                    to.func_75215_d(to.func_75211_c());
                    return !from.func_75216_d();
                }
            }
        } else if (!to.func_75216_d()) {
            int maxAmount = Math.min(from.func_75211_c().func_190916_E(), to.func_75219_a());
            if (maxAmount > 0) {
                ItemStack shiftedStack = from.func_75209_a(maxAmount);
                to.func_75215_d(shiftedStack);
                if (from.func_75211_c().func_190926_b()) {
                    from.func_75215_d(ItemStack.field_190927_a);
                }
            }
            return !from.func_75216_d();
        }
        return false;
    }

    @NotNull
    public List<Slot> addPlayerSlotsToContainer(@NotNull IInventory playerInventoryIn, int startX, int startY, @NotNull ItemStack lockedStack) {
        Intrinsics.checkNotNullParameter(playerInventoryIn, "playerInventoryIn");
        Intrinsics.checkNotNullParameter(lockedStack, "lockedStack");
        for (int row = 0; row < 3; ++row) {
            for (int column = 0; column < 9; ++column) {
                Slot slot = this.func_75146_a(new Slot(playerInventoryIn, column + row * 9 + 9, startX + column * this.slotSize, startY + row * this.slotSize));
                Intrinsics.checkNotNullExpressionValue(slot, "addSlotToContainer(\n    \u2026 ),\n                    )");
                this.playerBackpackSlots.add(slot);
            }
        }
        for (int index = 0; index < 9; ++index) {
            if (!lockedStack.func_190926_b() && Intrinsics.areEqual(playerInventoryIn.func_70301_a(index), lockedStack)) {
                Slot slot = this.func_75146_a(new LockedSlot(playerInventoryIn, index, startX + index * this.slotSize, startY + 3 * this.slotSize + 4));
                Intrinsics.checkNotNullExpressionValue(slot, "addSlotToContainer(\n    \u2026 ),\n                    )");
                this.playerHotbarSlots.add(slot);
                continue;
            }
            Slot slot = this.func_75146_a(new Slot(playerInventoryIn, index, startX + index * this.slotSize, startY + 3 * this.slotSize + 4));
            Intrinsics.checkNotNullExpressionValue(slot, "addSlotToContainer(\n    \u2026 ),\n                    )");
            this.playerHotbarSlots.add(slot);
        }
        return CollectionsKt.plus((Collection)this.playerBackpackSlots, (Iterable)this.playerHotbarSlots);
    }

    private final void handleGhostSlotClick(GhostSlot slot, ItemStack grabbedItemStack, int dragType, ClickType clickTypeIn, EntityPlayer player) {
        if (!(slot instanceof Item)) {
            String string = "When did I add fluid slots?";
            throw new NotImplementedError("An operation is not implemented: " + string);
        }
        this.handleGhostItemSlotClick(slot, grabbedItemStack, dragType, clickTypeIn, player);
    }

    public void handleGhostItemSlotClick(@NotNull GhostSlot slot, @NotNull ItemStack grabbedItemStack, int dragType, @NotNull ClickType clickTypeIn, @NotNull EntityPlayer player) {
        Intrinsics.checkNotNullParameter((Object)slot, "slot");
        Intrinsics.checkNotNullParameter(grabbedItemStack, "grabbedItemStack");
        Intrinsics.checkNotNullParameter(clickTypeIn, "clickTypeIn");
        Intrinsics.checkNotNullParameter(player, "player");
        LogisticsPipes.log.info("DragType " + dragType + ", ClickType: " + clickTypeIn);
        if (!(slot instanceof Unmodifiable)) {
            this.applyItemStackToGhostItemSlot(grabbedItemStack, slot);
        }
    }

    public void applyItemStackToGhostItemSlot(@NotNull ItemStack itemStack, @NotNull GhostSlot slot) {
        Intrinsics.checkNotNullParameter(itemStack, "itemStack");
        Intrinsics.checkNotNullParameter((Object)slot, "slot");
        ItemStack copiedItemStack = itemStack.func_77946_l();
        slot.func_75215_d(copiedItemStack);
    }

    /*
     * Enabled aggressive block sorting
     */
    public void func_75141_a(int slotID, @NotNull ItemStack stack) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        List list = this.field_75151_b;
        Intrinsics.checkNotNullExpressionValue(list, "inventorySlots");
        Slot slot = (Slot)CollectionsKt.getOrNull(list, slotID);
        Object object = slot;
        if (object != null) {
            Slot slot2 = object;
            boolean bl = false;
            InventoryProperty<?> inventoryProperty = this.directSlotPropertyMap.get(slot);
            object = inventoryProperty;
            if (inventoryProperty != null) {
                Object object2;
                Object object3 = object2 = object;
                boolean bl2 = false;
                object3.func_70299_a(slot.getSlotIndex(), stack);
                return;
            }
        }
        super.func_75141_a(slotID, stack);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_190896_a(@NotNull List<ItemStack> slotStacks) {
        Intrinsics.checkNotNullParameter(slotStacks, "slotStacks");
        int n = slotStacks.size();
        for (int slotIdx = 0; slotIdx < n; ++slotIdx) {
            this.func_75141_a(slotIdx, slotStacks.get(slotIdx));
        }
    }
}

