/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.logistics;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import logisticspipes.interfaces.routing.IFilter;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.jetbrains.annotations.Nullable;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.jvm.functions.Function0;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.jvm.internal.Ref;
import logisticspipes.kotlin.sequences.Sequence;
import logisticspipes.kotlin.sequences.SequencesKt;
import logisticspipes.modules.LogisticsModule;
import logisticspipes.pipefxhandlers.Particles;
import logisticspipes.pipes.basic.CoreRoutedPipe;
import logisticspipes.proxy.SimpleServiceLocator;
import logisticspipes.routing.AsyncRouting;
import logisticspipes.routing.ExitRoute;
import logisticspipes.routing.PipeRoutingConnectionType;
import logisticspipes.routing.ServerRouter;
import logisticspipes.utils.SinkReply;
import logisticspipes.utils.item.ItemIdentifier;
import net.minecraft.item.ItemStack;

/*
 * Illegal identifiers - consider using --renameillegalidents true
 */
@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0002\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002JF\u0010\u0003\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u00070\u00050\u00042\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0010\u001a\b\u0012\u0004\u0012\u00020\r0\u0011JR\u0010\u0012\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\u00150\u00142\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u00172\u0006\u0010\f\u001a\u00020\rH\u0002JB\u0010\u0018\u001a\u0010\u0012\u0004\u0012\u00020\u0006\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u00052\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\f\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00060\u0017\u00a8\u0006\u0019"}, d2={"Lnetwork/rs485/logisticspipes/logistics/LogisticsManager;", "", "()V", "allDestinations", "Llogisticspipes/kotlin/sequences/Sequence;", "Llogisticspipes/kotlin/Pair;", "", "Llogisticspipes/utils/SinkReply;", "stack", "Lnet/minecraft/item/ItemStack;", "itemid", "Llogisticspipes/utils/item/ItemIdentifier;", "canBeDefault", "", "sourceRouter", "Llogisticspipes/routing/ServerRouter;", "filter", "Llogisticspipes/kotlin/Function0;", "getBestReply", "destinationStream", "Ljava/util/stream/Stream;", "Llogisticspipes/routing/ExitRoute;", "routersToExclude", "", "getDestination", "logisticspipes"})
public final class LogisticsManager {
    @NotNull
    public static final LogisticsManager INSTANCE = new LogisticsManager();

    private LogisticsManager() {
    }

    @NotNull
    public final Sequence<Pair<Integer, SinkReply>> allDestinations(@NotNull ItemStack stack, @NotNull ItemIdentifier itemid, boolean canBeDefault, @NotNull ServerRouter sourceRouter, @NotNull Function0<Boolean> filter2) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(itemid, "itemid");
        Intrinsics.checkNotNullParameter(sourceRouter, "sourceRouter");
        Intrinsics.checkNotNullParameter(filter2, "filter");
        LinkedList<Integer> jamList = new LinkedList<Integer>();
        return SequencesKt.generateSequence((Function0)new Function0<Pair<? extends Integer, ? extends SinkReply>>(filter2, stack, itemid, canBeDefault, sourceRouter, jamList){
            final /* synthetic */ Function0<Boolean> $filter;
            final /* synthetic */ ItemStack $stack;
            final /* synthetic */ ItemIdentifier $itemid;
            final /* synthetic */ boolean $canBeDefault;
            final /* synthetic */ ServerRouter $sourceRouter;
            final /* synthetic */ LinkedList<Integer> $jamList;
            {
                this.$filter = $filter;
                this.$stack = $stack;
                this.$itemid = $itemid;
                this.$canBeDefault = $canBeDefault;
                this.$sourceRouter = $sourceRouter;
                this.$jamList = $jamList;
                super(0);
            }

            @Nullable
            public final Pair<Integer, SinkReply> invoke() {
                Pair<Integer, SinkReply> pair;
                if (this.$filter.invoke().booleanValue()) {
                    Pair<Integer, SinkReply> pair2 = LogisticsManager.INSTANCE.getDestination(this.$stack, this.$itemid, this.$canBeDefault, this.$sourceRouter, (List<Integer>)this.$jamList);
                    if (pair2 != null) {
                        Pair<Integer, SinkReply> pair3 = pair2;
                        LinkedList<Integer> linkedList = this.$jamList;
                        Pair<Integer, SinkReply> it = pair3;
                        boolean bl = false;
                        linkedList.add(it.getFirst());
                        pair = pair3;
                    } else {
                        pair = null;
                    }
                } else {
                    pair = null;
                }
                return pair;
            }
        });
    }

    @Nullable
    public final Pair<Integer, SinkReply> getDestination(@NotNull ItemStack stack, @NotNull ItemIdentifier itemid, boolean canBeDefault, @NotNull ServerRouter sourceRouter, @NotNull List<Integer> routersToExclude) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(itemid, "itemid");
        Intrinsics.checkNotNullParameter(sourceRouter, "sourceRouter");
        Intrinsics.checkNotNullParameter(routersToExclude, "routersToExclude");
        Stream<ExitRoute> destinationStream = ServerRouter.getRoutersInterestedIn(itemid).stream().mapToObj(SimpleServiceLocator.routerManager::getServerRouter).flatMap(arg_0 -> LogisticsManager.getDestination$lambda-3(sourceRouter, arg_0));
        Intrinsics.checkNotNullExpressionValue(destinationStream, "destinationStream");
        return this.getBestReply(stack, itemid, sourceRouter, destinationStream, routersToExclude, canBeDefault);
    }

    private final Pair<Integer, SinkReply> getBestReply(ItemStack stack, ItemIdentifier itemid, ServerRouter sourceRouter, Stream<ExitRoute> destinationStream, List<Integer> routersToExclude, boolean canBeDefault) {
        Pair<Integer, SinkReply> pair;
        Ref.ObjectRef resultRouterId = new Ref.ObjectRef();
        Ref.ObjectRef result2 = new Ref.ObjectRef();
        destinationStream.filter(arg_0 -> LogisticsManager.getBestReply$lambda-5(sourceRouter, routersToExclude, itemid, arg_0)).sorted().forEachOrdered(arg_0 -> LogisticsManager.getBestReply$lambda-6(result2, stack, itemid, canBeDefault, resultRouterId, arg_0));
        SinkReply sinkReply = (SinkReply)result2.element;
        if (sinkReply != null) {
            SinkReply sinkReply2 = sinkReply;
            boolean bl = false;
            Integer n = (Integer)resultRouterId.element;
            if (n != null) {
                int destinationRouterId = ((Number)n).intValue();
                boolean bl2 = false;
                ServerRouter serverRouter = SimpleServiceLocator.routerManager.getServerRouter(destinationRouterId);
                Intrinsics.checkNotNull(serverRouter);
                CoreRoutedPipe coreRoutedPipe = serverRouter.getPipe();
                Intrinsics.checkNotNull(coreRoutedPipe);
                CoreRoutedPipe pipe = coreRoutedPipe;
                pipe.useEnergy(sinkReply2.energyUse);
                pipe.spawnParticle(Particles.BlueParticle, 10);
                pair = new Pair<Integer, SinkReply>(destinationRouterId, sinkReply2);
            } else {
                pair = null;
            }
        } else {
            pair = null;
        }
        return pair;
    }

    private static final boolean getDestination$lambda-3$lambda-2$lambda-1$lambda-0(ExitRoute exitRoute) {
        return exitRoute.containsFlag(PipeRoutingConnectionType.canRouteTo);
    }

    private static final Stream getDestination$lambda-3(ServerRouter $sourceRouter, ServerRouter it) {
        Object object;
        block6: {
            block5: {
                Stream<ExitRoute> stream;
                Intrinsics.checkNotNullParameter($sourceRouter, "$sourceRouter");
                object = it;
                if (object == null) break block5;
                ServerRouter router = object;
                boolean bl = false;
                List<ExitRoute> list = AsyncRouting.INSTANCE.getDistance($sourceRouter, router);
                if (list != null) {
                    List<ExitRoute> routes = list;
                    boolean bl2 = false;
                    stream = routes.stream().filter(LogisticsManager::getDestination$lambda-3$lambda-2$lambda-1$lambda-0);
                } else {
                    stream = null;
                }
                object = stream;
                if (stream != null) break block6;
            }
            object = Stream.empty();
        }
        return object;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static final boolean getBestReply$lambda-5(ServerRouter $sourceRouter, List $routersToExclude, ItemIdentifier $itemid, ExitRoute it) {
        boolean bl;
        Intrinsics.checkNotNullParameter($sourceRouter, "$sourceRouter");
        Intrinsics.checkNotNullParameter($routersToExclude, "$routersToExclude");
        Intrinsics.checkNotNullParameter($itemid, "$itemid");
        if (Intrinsics.areEqual(it.destination.getId(), $sourceRouter.id)) return false;
        if ($routersToExclude.contains(it.destination.getSimpleID())) return false;
        if (!it.containsFlag(PipeRoutingConnectionType.canRouteTo)) return false;
        List<IFilter> list = it.filters;
        Intrinsics.checkNotNullExpressionValue(list, "it.filters");
        Iterable $this$none$iv = list;
        boolean $i$f$none = false;
        if ($this$none$iv instanceof Collection && ((Collection)$this$none$iv).isEmpty()) {
            bl = true;
        } else {
            for (Object element$iv : $this$none$iv) {
                IFilter filter2 = (IFilter)element$iv;
                boolean bl2 = false;
                if (filter2.blockRouting()) return false;
                if (filter2.isBlocked() == filter2.isFilteredItem($itemid)) {
                    return false;
                }
                boolean bl3 = false;
                if (!bl3) continue;
                return false;
            }
            bl = true;
        }
        if (!bl) return false;
        if (it.destination.getLogisticsModule() == null) return false;
        if (!it.destination.getLogisticsModule().receivePassive()) return false;
        if (it.destination.getPipe() == null) return false;
        if (!it.destination.getPipe().isEnabled()) return false;
        if (it.destination.getPipe().isOnSameContainer($sourceRouter.getPipe())) return false;
        return true;
    }

    private static final void getBestReply$lambda-6(Ref.ObjectRef $result, ItemStack $stack, ItemIdentifier $itemid, boolean $canBeDefault, Ref.ObjectRef $resultRouterId, ExitRoute it) {
        block7: {
            SinkReply reply;
            block8: {
                SinkReply sinkReply;
                Intrinsics.checkNotNullParameter($result, "$result");
                Intrinsics.checkNotNullParameter($stack, "$stack");
                Intrinsics.checkNotNullParameter($itemid, "$itemid");
                Intrinsics.checkNotNullParameter($resultRouterId, "$resultRouterId");
                reply = null;
                LogisticsModule logisticsModule = it.destination.getLogisticsModule();
                Intrinsics.checkNotNullExpressionValue(logisticsModule, "it.destination.logisticsModule");
                LogisticsModule module = logisticsModule;
                if ($result.element == null) {
                    sinkReply = module.sinksItem($stack, $itemid, -1, 0, $canBeDefault, true, true);
                } else {
                    Object t = $result.element;
                    Intrinsics.checkNotNull(t);
                    if (((SinkReply)t).maxNumberOfItems < 0) {
                        sinkReply = null;
                    } else {
                        Object t2 = $result.element;
                        Intrinsics.checkNotNull(t2);
                        int n = ((SinkReply)t2).fixedPriority.ordinal();
                        Object t3 = $result.element;
                        Intrinsics.checkNotNull(t3);
                        sinkReply = reply = module.sinksItem($stack, $itemid, n, ((SinkReply)t3).customPriority, $canBeDefault, true, true);
                    }
                }
                if (reply == null) break block7;
                if ($result.element == null) break block8;
                int n = reply.fixedPriority.ordinal();
                Object t = $result.element;
                Intrinsics.checkNotNull(t);
                if (n > ((SinkReply)t).fixedPriority.ordinal()) break block8;
                SinkReply.FixedPriority fixedPriority = reply.fixedPriority;
                Object t4 = $result.element;
                Intrinsics.checkNotNull(t4);
                if (fixedPriority != ((SinkReply)t4).fixedPriority) break block7;
                int n2 = reply.customPriority;
                Object t5 = $result.element;
                Intrinsics.checkNotNull(t5);
                if (n2 <= ((SinkReply)t5).customPriority) break block7;
            }
            $resultRouterId.element = it.destination.getSimpleID();
            $result.element = reply;
        }
    }
}

