/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.network.packets;

import java.util.List;
import java.util.Objects;
import javax.annotation.Nullable;
import logisticspipes.LPItems;
import logisticspipes.network.abstractpackets.ModernPacket;
import logisticspipes.utils.StaticResolve;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import network.rs485.logisticspipes.gui.guidebook.IPageData;
import network.rs485.logisticspipes.gui.guidebook.PageData;
import network.rs485.logisticspipes.guidebook.ItemGuideBook;
import network.rs485.logisticspipes.util.LPDataInput;
import network.rs485.logisticspipes.util.LPDataOutput;

@StaticResolve
public class SetCurrentPagePacket
extends ModernPacket {
    @Nullable
    private IPageData currentPage;
    private EntityEquipmentSlot equipmentSlot;
    private List<? extends IPageData> bookmarks;

    public SetCurrentPagePacket(int id) {
        super(id);
    }

    @Override
    public void processPacket(EntityPlayer player) {
        if (this.currentPage == null) {
            return;
        }
        ItemStack book = player.func_184582_a(this.equipmentSlot);
        if (book.func_190926_b() || !(book.func_77973_b() instanceof ItemGuideBook)) {
            return;
        }
        NBTTagCompound compound = book.func_77942_o() ? Objects.requireNonNull(book.func_77978_p()) : new NBTTagCompound();
        NBTTagCompound nbt = LPItems.itemGuideBook.updateNBT(compound, this.currentPage, this.bookmarks);
        book.func_77982_d(nbt);
    }

    @Override
    public void readData(LPDataInput input) {
        super.readData(input);
        this.equipmentSlot = input.readEnum(EntityEquipmentSlot.class);
        this.currentPage = new PageData(input);
        this.bookmarks = input.readArrayList(PageData::new);
    }

    @Override
    public void writeData(LPDataOutput output) {
        super.writeData(output);
        if (this.currentPage == null) {
            throw new NullPointerException("Current page may not be null");
        }
        output.writeEnum(this.equipmentSlot);
        this.currentPage.write(output);
        output.writeCollection(this.bookmarks);
    }

    @Override
    public ModernPacket template() {
        return new SetCurrentPagePacket(this.getId());
    }

    public SetCurrentPagePacket setCurrentPage(IPageData currentPage) {
        this.currentPage = currentPage;
        return this;
    }

    public SetCurrentPagePacket setEquipmentSlot(EntityEquipmentSlot equipmentSlot) {
        this.equipmentSlot = equipmentSlot;
        return this;
    }

    public SetCurrentPagePacket setBookmarks(List<? extends IPageData> bookmarks) {
        this.bookmarks = bookmarks;
        return this;
    }
}

