/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.util;

import io.netty.buffer.ByteBuf;
import java.util.ArrayList;
import java.util.BitSet;
import java.util.EnumSet;
import java.util.LinkedList;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import logisticspipes.network.IReadListObject;
import logisticspipes.routing.channels.ChannelInformation;
import logisticspipes.utils.PlayerIdentifier;
import logisticspipes.utils.item.ItemIdentifier;
import logisticspipes.utils.item.ItemIdentifierStack;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import network.rs485.logisticspipes.util.LPSerializable;

public interface LPDataInput {
    @Nullable
    public byte[] readByteArray();

    public byte readByte();

    public short readShort();

    public int readInt();

    public long readLong();

    public float readFloat();

    public double readDouble();

    public boolean readBoolean();

    @Nullable
    public String readUTF();

    @Nullable
    public EnumFacing readFacing();

    @Nullable
    public ResourceLocation readResourceLocation();

    @Nonnull
    public <T extends Enum<T>> EnumSet<T> readEnumSet(Class<T> var1);

    @Nonnull
    public BitSet readBitSet();

    @Nullable
    public NBTTagCompound readNBTTagCompound();

    @Nullable
    public boolean[] readBooleanArray();

    @Nullable
    public String[] readUTFArray();

    @Nullable
    public int[] readIntArray();

    @Nonnull
    public byte[] readBytes(int var1);

    @Nullable
    public ItemIdentifier readItemIdentifier();

    @Nullable
    public ItemIdentifierStack readItemIdentifierStack();

    @Nonnull
    public ItemStack readItemStack();

    @Nullable
    public <T> ArrayList<T> readArrayList(IReadListObject<T> var1);

    @Nullable
    public <T> LinkedList<T> readLinkedList(IReadListObject<T> var1);

    @Nullable
    public <T> Set<T> readSet(IReadListObject<T> var1);

    @Nullable
    public <T> NonNullList<T> readNonNullList(IReadListObject<T> var1, @Nonnull T var2);

    @Nullable
    public <T extends Enum<T>> T readEnum(Class<T> var1);

    @Nonnull
    public ByteBuf readByteBuf();

    @Nullable
    public long[] readLongArray();

    @Nonnull
    public ChannelInformation readChannelInformation();

    @Nullable
    public UUID readUUID();

    @Nonnull
    public PlayerIdentifier readPlayerIdentifier();

    default public void readSerializable(LPSerializable serializable) {
        serializable.read(this);
    }

    public static interface LPDataInputConsumer {
        public void accept(LPDataInput var1);
    }
}

