/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.util;

import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.EnumSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.Pair;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.collections.ArraysKt;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.collections.SetsKt;
import logisticspipes.kotlin.jvm.JvmStatic;
import logisticspipes.kotlin.jvm.functions.Function1;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import logisticspipes.kotlin.text.MatchResult;
import logisticspipes.kotlin.text.Regex;
import logisticspipes.kotlin.text.StringsKt;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import network.rs485.logisticspipes.util.TextUtil;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000v\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0010\u0006\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010!\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\t\n\u0002\b\u0007\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\r\n\u0002\b\u0007\n\u0002\u0010\u0011\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J&\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\f\u0010\u0013\u001a\b\u0012\u0004\u0012\u00020\b0\u00142\u0006\u0010\u0015\u001a\u00020\u0016H\u0007J\u0010\u0010\u0017\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u0019H\u0007J\u0010\u0010\u001a\u001a\u00020\b2\u0006\u0010\u001b\u001a\u00020\u0005H\u0002J\u0018\u0010\u001c\u001a\u00020\b2\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001d\u001a\u00020\u0016H\u0007J*\u0010\u001e\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\u0006\u0010 \u001a\u00020!2\u0006\u0010\"\u001a\u00020#2\b\b\u0002\u0010$\u001a\u00020%H\u0007J\u001c\u0010&\u001a\u00020\b2\u0006\u0010\u001f\u001a\u00020\b2\f\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004JI\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\u000e\b\u0002\u0010'\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\b\b\u0002\u0010*\u001a\u00020\b2\b\b\u0002\u0010+\u001a\u00020\b2\u000e\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0-H\u0007\u00a2\u0006\u0002\u0010.J)\u0010(\u001a\u00020\b2\u0006\u0010)\u001a\u00020\b2\u0012\u0010,\u001a\n\u0012\u0006\b\u0001\u0012\u00020\b0-\"\u00020\bH\u0007\u00a2\u0006\u0002\u0010/J\u0012\u00100\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\u0012\u00101\u001a\u00020\b*\b\u0012\u0004\u0012\u00020\u00050\u0004H\u0002J\f\u00102\u001a\u00020\u0005*\u000203H\u0002R\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\u00050\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\bX\u0082T\u00a2\u0006\u0002\n\u0000R \u0010\t\u001a\u0014\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\f\u0012\u0004\u0012\u00020\b0\u000b0\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u000eX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u00064"}, d2={"Lnetwork/rs485/logisticspipes/util/TextUtil;", "", "()V", "baseFormattingState", "Ljava/util/EnumSet;", "Lnet/minecraft/util/text/TextFormatting;", "formattingState", "holdShiftTooltip", "", "numberPrefixes", "", "Llogisticspipes/kotlin/Pair;", "", "regexPattern", "Llogisticspipes/kotlin/text/Regex;", "addTooltipInformation", "", "stack", "Lnet/minecraft/item/ItemStack;", "tooltip", "", "extended", "", "formatNumberWithCommas", "number", "", "getReplacementString", "formatting", "getThreeDigitFormattedNumber", "forceDisplayNumber", "getTrimmedString", "text", "maxWidth", "", "fontRenderer", "Lnet/minecraft/client/gui/FontRenderer;", "postfix", "", "transform", "baseFormatting", "translate", "key", "prepend", "append", "args", "", "(Ljava/lang/String;Ljava/util/EnumSet;Ljava/lang/String;Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "(Ljava/lang/String;[Ljava/lang/String;)Ljava/lang/String;", "getColorTag", "getFormattingTags", "getTextFormatting", "Llogisticspipes/kotlin/text/MatchResult;", "logisticspipes"})
public final class TextUtil {
    @NotNull
    public static final TextUtil INSTANCE = new TextUtil();
    @NotNull
    private static final String holdShiftTooltip = "misc.holdshift";
    @NotNull
    private static final List<Pair<Double, String>> numberPrefixes;
    @NotNull
    private static final EnumSet<TextFormatting> formattingState;
    @NotNull
    private static final EnumSet<TextFormatting> baseFormattingState;
    @NotNull
    private static final Regex regexPattern;

    private TextUtil() {
    }

    @JvmStatic
    @NotNull
    public static final String translate(@NotNull String key, String ... args2) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(args2, "args");
        EnumSet<TextFormatting> enumSet = EnumSet.noneOf(TextFormatting.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, "noneOf(TextFormatting::class.java)");
        return TextUtil.translate$default(key, enumSet, null, null, args2, 12, null);
    }

    @JvmStatic
    @NotNull
    public static final String translate(@NotNull String key, @NotNull EnumSet<TextFormatting> baseFormatting, @NotNull String prepend, @NotNull String append2, @NotNull String[] args2) {
        Intrinsics.checkNotNullParameter(key, "key");
        Intrinsics.checkNotNullParameter(baseFormatting, "baseFormatting");
        Intrinsics.checkNotNullParameter(prepend, "prepend");
        Intrinsics.checkNotNullParameter(append2, "append");
        Intrinsics.checkNotNullParameter(args2, "args");
        return INSTANCE.transform(prepend + I18n.func_135052_a((String)key, (Object[])Arrays.copyOf(args2, args2.length)) + append2, baseFormatting);
    }

    public static /* synthetic */ String translate$default(String string, EnumSet enumSet, String string2, String string3, String[] stringArray, int n, Object object) {
        if ((n & 2) != 0) {
            EnumSet<TextFormatting> enumSet2 = EnumSet.noneOf(TextFormatting.class);
            Intrinsics.checkNotNullExpressionValue(enumSet2, "noneOf(TextFormatting::class.java)");
            enumSet = enumSet2;
        }
        if ((n & 4) != 0) {
            string2 = "";
        }
        if ((n & 8) != 0) {
            string3 = "";
        }
        return TextUtil.translate(string, enumSet, string2, string3, stringArray);
    }

    @JvmStatic
    @NotNull
    public static final String getTrimmedString(@NotNull String text, int maxWidth, @NotNull FontRenderer fontRenderer, @NotNull CharSequence postfix) {
        String result2;
        block3: {
            String string;
            Intrinsics.checkNotNullParameter(text, "text");
            Intrinsics.checkNotNullParameter(fontRenderer, "fontRenderer");
            Intrinsics.checkNotNullParameter(postfix, "postfix");
            if (fontRenderer.func_78256_a(text) < maxWidth) {
                return text;
            }
            result2 = null;
            result2 = "";
            String $this$takeWhile$iv = text;
            boolean $i$f$takeWhile = false;
            int n = $this$takeWhile$iv.length();
            for (int index$iv = 0; index$iv < n; ++index$iv) {
                boolean bl;
                char c = $this$takeWhile$iv.charAt(index$iv);
                boolean bl2 = false;
                boolean fitsInWidth = bl = fontRenderer.func_78256_a(result2 + c + postfix) < maxWidth;
                boolean bl3 = false;
                if (fitsInWidth) {
                    result2 = result2 + c;
                }
                if (bl) continue;
                String string2 = $this$takeWhile$iv;
                int n2 = 0;
                String string3 = string2.substring(n2, index$iv);
                string = string3;
                Intrinsics.checkNotNullExpressionValue(string3, "this as java.lang.String\u2026ing(startIndex, endIndex)");
                break block3;
            }
            string = $this$takeWhile$iv;
        }
        return ((Object)StringsKt.trim((CharSequence)result2)).toString() + postfix;
    }

    public static /* synthetic */ String getTrimmedString$default(String string, int n, FontRenderer fontRenderer, CharSequence charSequence, int n2, Object object) {
        if ((n2 & 8) != 0) {
            charSequence = "...";
        }
        return TextUtil.getTrimmedString(string, n, fontRenderer, charSequence);
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @JvmStatic
    @NotNull
    public static final String getThreeDigitFormattedNumber(long number, boolean forceDisplayNumber) {
        String string;
        Object v0;
        int n;
        block7: {
            Iterable $this$firstOrNull$iv = numberPrefixes;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                Pair prefix = (Pair)element$iv;
                n = 0;
                if (!(number == 0L || (double)number >= ((Number)prefix.getFirst()).doubleValue() * 0.1 && (double)number < ((Number)prefix.getFirst()).doubleValue() * (double)100)) continue;
                v0 = element$iv;
                break block7;
            }
            v0 = null;
        }
        Pair pair = v0;
        if (pair == null) return "NaN";
        Pair prefix = pair;
        boolean bl = false;
        if (number == 1L && !forceDisplayNumber) {
            return "";
        }
        if (number < 1000L) {
            string = String.valueOf(number);
        } else {
            Object object;
            StringBuilder stringBuilder = new StringBuilder().append((int)((double)number / ((Number)prefix.getFirst()).doubleValue())).append((String)prefix.getSecond());
            if ((double)number > (double)10 * ((Number)prefix.getFirst()).doubleValue()) {
                object = "";
            } else {
                void decimal;
                Integer n2 = (int)((double)number % ((Number)prefix.getFirst()).doubleValue() / (((Number)prefix.getFirst()).doubleValue() / (double)10));
                n = ((Number)n2).intValue();
                StringBuilder stringBuilder2 = stringBuilder;
                boolean bl2 = false;
                stringBuilder = stringBuilder2;
                object = Boolean.valueOf(decimal > 0) != false ? n2 : null;
                if (object == null) {
                    object = "";
                }
            }
            string = stringBuilder.append(object).toString();
        }
        String string2 = string;
        if (string2 == null) return "NaN";
        String string3 = string2;
        return string3;
    }

    @JvmStatic
    public static final void addTooltipInformation(@NotNull ItemStack stack, @NotNull List<String> tooltip, boolean extended) {
        Intrinsics.checkNotNullParameter(stack, "stack");
        Intrinsics.checkNotNullParameter(tooltip, "tooltip");
        if (extended) {
            int tooltipLine = 1;
            while (I18n.func_188566_a((String)(stack.func_77977_a() + ".tip" + tooltipLine))) {
                ((Collection)tooltip).add(TextUtil.translate(stack.func_77977_a() + ".tip" + tooltipLine, new String[0]));
                ++tooltipLine;
            }
        } else if (I18n.func_188566_a((String)(stack.func_77977_a() + ".tip1"))) {
            ((Collection)tooltip).add(TextUtil.translate(holdShiftTooltip, new String[0]));
        }
    }

    @NotNull
    public final String transform(@NotNull String text, @NotNull EnumSet<TextFormatting> baseFormatting) {
        Intrinsics.checkNotNullParameter(text, "text");
        Intrinsics.checkNotNullParameter(baseFormatting, "baseFormatting");
        baseFormattingState.clear();
        baseFormattingState.addAll((Collection<TextFormatting>)baseFormatting);
        formattingState.clear();
        String result2 = StringsKt.prependIndent(text, this.getColorTag(baseFormattingState) + this.getFormattingTags(baseFormattingState));
        while (regexPattern.containsMatchIn(result2)) {
            result2 = regexPattern.replace((CharSequence)result2, transform.1.INSTANCE);
        }
        return result2;
    }

    @JvmStatic
    @NotNull
    public static final String formatNumberWithCommas(long number) {
        String string = NumberFormat.getNumberInstance(Minecraft.func_71410_x().func_135016_M().func_135041_c().getJavaLocale()).format(number);
        Intrinsics.checkNotNullExpressionValue(string, "getNumberInstance(Minecr\u2026avaLocale).format(number)");
        return string;
    }

    private final String getReplacementString(TextFormatting formatting) {
        if (formatting == TextFormatting.RESET) {
            formattingState.clear();
            return formatting.toString() + this.getColorTag(baseFormattingState) + this.getFormattingTags(baseFormattingState);
        }
        if (formatting.func_96302_c()) {
            CollectionsKt.removeAll((Iterable)formattingState, (Function1)getReplacementString.1.INSTANCE);
        }
        formattingState.add(formatting);
        return this.getColorTag(formattingState) + this.getFormattingTags(formattingState);
    }

    private final TextFormatting getTextFormatting(MatchResult $this$getTextFormatting) {
        String string = $this$getTextFormatting.getValue().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue(string, "this as java.lang.String).toLowerCase(Locale.ROOT)");
        TextFormatting textFormatting = TextFormatting.func_96300_b((String)string);
        Intrinsics.checkNotNull(textFormatting);
        return textFormatting;
    }

    private final String getColorTag(EnumSet<TextFormatting> $this$getColorTag) {
        Object object;
        Object object2;
        Object v0;
        block3: {
            Iterable $this$firstOrNull$iv = $this$getColorTag;
            boolean $i$f$firstOrNull = false;
            for (Object element$iv : $this$firstOrNull$iv) {
                TextFormatting it = (TextFormatting)element$iv;
                boolean bl = false;
                if (!it.func_96302_c()) continue;
                v0 = element$iv;
                break block3;
            }
            v0 = null;
        }
        if ((object2 = (TextFormatting)v0) == null || (object2 = object2.toString()) == null) {
            Object v2;
            block4: {
                Iterable $this$firstOrNull$iv = baseFormattingState;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    TextFormatting it = (TextFormatting)element$iv;
                    boolean bl = false;
                    if (!it.func_96302_c()) continue;
                    v2 = element$iv;
                    break block4;
                }
                v2 = null;
            }
            TextFormatting textFormatting = v2;
            object2 = textFormatting != null ? textFormatting.toString() : null;
        }
        return (object = object2) == null ? "" : object;
    }

    /*
     * WARNING - void declaration
     */
    private final String getFormattingTags(EnumSet<TextFormatting> $this$getFormattingTags) {
        void $this$filterTo$iv$iv;
        Iterable $this$filter$iv = SetsKt.plus((Set)$this$getFormattingTags, (Iterable)baseFormattingState);
        boolean $i$f$filter = false;
        Iterable iterable = $this$filter$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            TextFormatting it = (TextFormatting)element$iv$iv;
            boolean bl = false;
            if (!it.func_96301_b()) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        return CollectionsKt.joinToString$default((List)destination$iv$iv, "", null, null, 0, null, getFormattingTags.2.INSTANCE, 30, null);
    }

    public static final /* synthetic */ String access$getReplacementString(TextUtil $this, TextFormatting formatting) {
        return $this.getReplacementString(formatting);
    }

    public static final /* synthetic */ TextFormatting access$getTextFormatting(TextUtil $this, MatchResult $receiver) {
        return $this.getTextFormatting($receiver);
    }

    static {
        Pair[] pairArray = new Pair[]{TuplesKt.to(1.0, ""), TuplesKt.to(1000.0, "k"), TuplesKt.to(1000000.0, "M"), TuplesKt.to(1.0E9, "G"), TuplesKt.to(1.0E12, "T"), TuplesKt.to(1.0E15, "P"), TuplesKt.to(1.0E18, "E")};
        numberPrefixes = CollectionsKt.listOf(pairArray);
        EnumSet<TextFormatting> enumSet = EnumSet.noneOf(TextFormatting.class);
        Intrinsics.checkNotNullExpressionValue(enumSet, "noneOf(TextFormatting::class.java)");
        formattingState = enumSet;
        EnumSet<TextFormatting> enumSet2 = EnumSet.noneOf(TextFormatting.class);
        Intrinsics.checkNotNullExpressionValue(enumSet2, "noneOf(TextFormatting::class.java)");
        baseFormattingState = enumSet2;
        regexPattern = new Regex(ArraysKt.joinToString$default(TextFormatting.values(), (CharSequence)"|", (CharSequence)"(\\$)(", (CharSequence)")", 0, null, (Function1)regexPattern.1.INSTANCE, 24, null));
    }
}

