/*
 * Decompiled with CFR 0.152.
 */
package network.rs485.logisticspipes.util.math;

import java.util.Collection;
import java.util.List;
import logisticspipes.jetbrains.annotations.NotNull;
import logisticspipes.kotlin.Metadata;
import logisticspipes.kotlin.TuplesKt;
import logisticspipes.kotlin.collections.CollectionsKt;
import logisticspipes.kotlin.jvm.internal.Intrinsics;
import network.rs485.logisticspipes.util.IRectangle;
import network.rs485.logisticspipes.util.Rectangle;
import network.rs485.logisticspipes.util.math.MutableRectangle;

@Metadata(mv={1, 7, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010 \n\u0002\b\f\n\u0002\u0018\u0002\n\u0002\b\u0011\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\u00020\u0003B\u0017\b\u0016\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\u0007B-\u0012\u0006\u0010\u0004\u001a\u00028\u0000\u0012\u0006\u0010\b\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\u0006\u0012\u0006\u0010\n\u001a\u00020\u0006\u0012\u0006\u0010\u000b\u001a\u00020\u0006\u00a2\u0006\u0002\u0010\fR\u0017\u0010\r\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0012\u0010\u0013R\u0011\u0010\u0014\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0015\u0010\u0013R\u0011\u0010\u0016\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0017\u0010\u0013R\u0017\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0019\u0010\u0010R\u0011\u0010\u001a\u001a\u00020\u001b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001c\u0010\u001dR\u0011\u0010\u001e\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b\u001f\u0010\u0013R\u0017\u0010 \u001a\b\u0012\u0004\u0012\u00020\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b!\u0010\u0010R\u0011\u0010\"\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b#\u0010\u0013R\u0017\u0010$\u001a\b\u0012\u0004\u0012\u00020\u00020\u000e\u00a2\u0006\b\n\u0000\u001a\u0004\b%\u0010\u0010R\u0011\u0010&\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b'\u0010\u0013R\u0011\u0010(\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b)\u0010\u0013R\u0011\u0010*\u001a\u00020\u0002\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010\u0013\u00a8\u0006,"}, d2={"Lnetwork/rs485/logisticspipes/util/math/BorderedRectangle;", "R", "Lnetwork/rs485/logisticspipes/util/IRectangle;", "", "outer", "border", "", "(Lnetwork/rs485/logisticspipes/util/IRectangle;I)V", "borderTop", "borderLeft", "borderBottom", "borderRight", "(Lnetwork/rs485/logisticspipes/util/IRectangle;IIII)V", "borderQuads", "", "getBorderQuads", "()Ljava/util/List;", "bottom", "getBottom", "()Lnetwork/rs485/logisticspipes/util/IRectangle;", "bottomLeft", "getBottomLeft", "bottomRight", "getBottomRight", "corners", "getCorners", "inner", "Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "getInner", "()Lnetwork/rs485/logisticspipes/util/math/MutableRectangle;", "left", "getLeft", "quads", "getQuads", "right", "getRight", "sides", "getSides", "top", "getTop", "topLeft", "getTopLeft", "topRight", "getTopRight", "logisticspipes"})
public final class BorderedRectangle<R extends IRectangle> {
    @NotNull
    private final MutableRectangle inner;
    @NotNull
    private final IRectangle topRight;
    @NotNull
    private final IRectangle topLeft;
    @NotNull
    private final IRectangle bottomLeft;
    @NotNull
    private final IRectangle bottomRight;
    @NotNull
    private final IRectangle top;
    @NotNull
    private final IRectangle left;
    @NotNull
    private final IRectangle bottom;
    @NotNull
    private final IRectangle right;
    @NotNull
    private final List<IRectangle> corners;
    @NotNull
    private final List<IRectangle> sides;
    @NotNull
    private final List<IRectangle> borderQuads;
    @NotNull
    private final List<IRectangle> quads;

    public BorderedRectangle(@NotNull R outer, int borderTop, int borderLeft, int borderBottom, int borderRight) {
        Intrinsics.checkNotNullParameter(outer, "outer");
        this.inner = MutableRectangle.Companion.fromRectangle((IRectangle)outer).translate(borderLeft, borderTop).grow(-borderLeft - borderRight, -borderTop - borderBottom);
        this.topRight = new Rectangle(TuplesKt.to(Float.valueOf(this.inner.getRight()), Float.valueOf(outer.getTop())), TuplesKt.to(Float.valueOf(outer.getRight()), Float.valueOf(this.inner.getTop())));
        this.topLeft = new Rectangle(TuplesKt.to(Float.valueOf(outer.getLeft()), Float.valueOf(outer.getTop())), TuplesKt.to(Float.valueOf(this.inner.getLeft()), Float.valueOf(this.inner.getTop())));
        this.bottomLeft = new Rectangle(TuplesKt.to(Float.valueOf(outer.getLeft()), Float.valueOf(this.inner.getBottom())), TuplesKt.to(Float.valueOf(this.inner.getLeft()), Float.valueOf(outer.getBottom())));
        this.bottomRight = new Rectangle(TuplesKt.to(Float.valueOf(this.inner.getRight()), Float.valueOf(this.inner.getBottom())), TuplesKt.to(Float.valueOf(outer.getRight()), Float.valueOf(outer.getBottom())));
        this.top = new Rectangle(TuplesKt.to(Float.valueOf(this.inner.getLeft()), Float.valueOf(outer.getTop())), TuplesKt.to(Float.valueOf(this.inner.getRight()), Float.valueOf(this.inner.getTop())));
        this.left = new Rectangle(TuplesKt.to(Float.valueOf(outer.getLeft()), Float.valueOf(this.inner.getTop())), TuplesKt.to(Float.valueOf(this.inner.getLeft()), Float.valueOf(this.inner.getBottom())));
        this.bottom = new Rectangle(TuplesKt.to(Float.valueOf(this.inner.getLeft()), Float.valueOf(this.inner.getBottom())), TuplesKt.to(Float.valueOf(this.inner.getRight()), Float.valueOf(outer.getBottom())));
        this.right = new Rectangle(TuplesKt.to(Float.valueOf(this.inner.getRight()), Float.valueOf(this.inner.getTop())), TuplesKt.to(Float.valueOf(outer.getRight()), Float.valueOf(this.inner.getBottom())));
        IRectangle[] iRectangleArray = new IRectangle[]{this.topRight, this.topLeft, this.bottomLeft, this.bottomRight};
        this.corners = CollectionsKt.listOf(iRectangleArray);
        iRectangleArray = new IRectangle[]{this.top, this.left, this.bottom, this.right};
        this.sides = CollectionsKt.listOf(iRectangleArray);
        iRectangleArray = new IRectangle[]{this.topRight, this.top, this.topLeft, this.left, this.bottomLeft, this.bottom, this.bottomRight, this.right};
        this.borderQuads = CollectionsKt.listOf(iRectangleArray);
        this.quads = CollectionsKt.plus((Collection)this.borderQuads, this.inner);
    }

    public BorderedRectangle(@NotNull R outer, int border) {
        Intrinsics.checkNotNullParameter(outer, "outer");
        this(outer, border, border, border, border);
    }

    @NotNull
    public final MutableRectangle getInner() {
        return this.inner;
    }

    @NotNull
    public final IRectangle getTopRight() {
        return this.topRight;
    }

    @NotNull
    public final IRectangle getTopLeft() {
        return this.topLeft;
    }

    @NotNull
    public final IRectangle getBottomLeft() {
        return this.bottomLeft;
    }

    @NotNull
    public final IRectangle getBottomRight() {
        return this.bottomRight;
    }

    @NotNull
    public final IRectangle getTop() {
        return this.top;
    }

    @NotNull
    public final IRectangle getLeft() {
        return this.left;
    }

    @NotNull
    public final IRectangle getBottom() {
        return this.bottom;
    }

    @NotNull
    public final IRectangle getRight() {
        return this.right;
    }

    @NotNull
    public final List<IRectangle> getCorners() {
        return this.corners;
    }

    @NotNull
    public final List<IRectangle> getSides() {
        return this.sides;
    }

    @NotNull
    public final List<IRectangle> getBorderQuads() {
        return this.borderQuads;
    }

    @NotNull
    public final List<IRectangle> getQuads() {
        return this.quads;
    }
}

