/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.api.asm;

import java.util.Collections;
import java.util.function.Consumer;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.objectweb.asm.ClassReader;
import org.objectweb.asm.ClassVisitor;
import org.objectweb.asm.ClassWriter;
import org.objectweb.asm.MethodVisitor;
import org.objectweb.asm.Opcodes;
import org.objectweb.asm.Type;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.LabelNode;
import org.objectweb.asm.tree.LocalVariableNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;

public interface IASMPlugin
extends Opcodes {
    @Nonnull
    public static final Logger PLUGIN_LOGGER = LogManager.getFormatterLogger();
    @Nonnull
    public static final String[] ACTIVE_PLUGIN = new String[]{"Unknown Plugin"};

    public static void resetActivePlugin() {
        IASMPlugin.ACTIVE_PLUGIN[0] = "Unknown Plugin";
    }

    public static void setActivePlugin(@Nonnull String plugin) {
        IASMPlugin.ACTIVE_PLUGIN[0] = plugin;
    }

    default public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        return this.isMethodValid(method, obfuscated) ? 1 : 0;
    }

    default public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return false;
    }

    default public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        return true;
    }

    default public boolean transform(@Nonnull ClassNode classNode, @Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        return this.transform(instructions, method, insn, obfuscated, index);
    }

    default public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        return true;
    }

    default public boolean addLocalVariables(@Nonnull MethodNode method, @Nonnull LabelNode start, @Nonnull LabelNode end, int index) {
        return false;
    }

    default public byte[] transform(@Nonnull byte[] basicClass, boolean obfuscated) {
        ClassNode classNode = new ClassNode();
        new ClassReader(basicClass).accept((ClassVisitor)classNode, this.recalcFrames(obfuscated) ? 4 : 0);
        this.transformNode(classNode, obfuscated);
        ClassWriter writer = new ClassWriter(1 | (this.recalcFrames(obfuscated) ? 2 : 0));
        classNode.accept((ClassVisitor)writer);
        return writer.toByteArray();
    }

    default public void transformNode(@Nonnull ClassNode classNode, boolean obfuscated) {
        if (this.transformClass(classNode, obfuscated)) {
            for (MethodNode method : classNode.methods) {
                int index = this.getMethodIndex(method, obfuscated);
                if (index == 0) continue;
                this.informConsole(classNode.name, method);
                LabelNode start = new LabelNode();
                LabelNode end = new LabelNode();
                if (this.addLocalVariables(method, start, end, index)) {
                    method.instructions.insertBefore(method.instructions.getFirst(), (AbstractInsnNode)start);
                    method.instructions.insert(method.instructions.getLast(), (AbstractInsnNode)end);
                }
                for (AbstractInsnNode insn : method.instructions.toArray()) {
                    if (this.transform(classNode, method.instructions, method, insn, obfuscated, index)) break;
                }
            }
        } else {
            this.informConsole(classNode.name, null);
        }
    }

    default public void informConsole(@Nonnull String className, @Nullable MethodNode method) {
        if (this.shouldInformConsole()) {
            if (method == null) {
                PLUGIN_LOGGER.debug(ACTIVE_PLUGIN[0] + ": transforming... " + className);
            } else {
                PLUGIN_LOGGER.debug(ACTIVE_PLUGIN[0] + ": transforming... " + className + '.' + method.name + method.desc);
            }
        }
    }

    default public void overrideMethod(@Nonnull ClassNode classNode, @Nonnull Predicate<MethodNode> searchCondition, @Nullable String hookName, @Nullable String hookDesc, @Nonnull Consumer<GeneratorAdapter> consumer) {
        for (MethodNode method : classNode.methods) {
            if (!searchCondition.test(method)) continue;
            this.overrideMethod(classNode, method, hookName, hookDesc, consumer);
        }
    }

    default public void overrideMethod(@Nonnull ClassNode classNode, @Nonnull MethodNode method, @Nullable String hookName, @Nullable String hookDesc, @Nonnull Consumer<GeneratorAdapter> consumer) {
        this.informConsole(classNode.name, method);
        method.instructions.clear();
        if (method.tryCatchBlocks != null) {
            method.tryCatchBlocks.clear();
        }
        if (method.localVariables != null) {
            method.localVariables.clear();
        }
        if (method.visibleLocalVariableAnnotations != null) {
            method.visibleLocalVariableAnnotations.clear();
        }
        if (method.invisibleLocalVariableAnnotations != null) {
            method.invisibleLocalVariableAnnotations.clear();
        }
        consumer.accept(new GeneratorAdapter((MethodVisitor)method, method.access, method.name, method.desc));
        if (hookName != null && hookDesc != null) {
            method.visitMethodInsn(184, this.getHookClass(), hookName, hookDesc, false);
        }
        method.visitInsn(Type.getReturnType((String)method.desc).getOpcode(172));
    }

    default public void addMethod(@Nonnull ClassNode classNode, @Nonnull String name, @Nonnull String desc, @Nullable String hookName, @Nullable String hookDesc, @Nonnull Consumer<GeneratorAdapter> consumer) {
        this.addMethod(classNode, name, desc, null, hookName, hookDesc, consumer);
    }

    default public void addMethod(@Nonnull ClassNode classNode, @Nonnull String name, @Nonnull String desc, @Nullable String signature, @Nullable String hookName, @Nullable String hookDesc, @Nonnull Consumer<GeneratorAdapter> consumer) {
        if (classNode.methods.stream().filter(method -> method.name.equals(name) && method.desc.equals(desc)).peek(method -> this.overrideMethod(classNode, (MethodNode)method, hookName, hookDesc, consumer)).count() != 0L) {
            return;
        }
        MethodNode method2 = new MethodNode(1, name, desc, signature, null);
        this.informConsole(classNode.name, method2);
        consumer.accept(new GeneratorAdapter((MethodVisitor)method2, method2.access, method2.name, method2.desc));
        if (hookName != null && hookDesc != null) {
            method2.visitMethodInsn(184, this.getHookClass(), hookName, hookDesc, false);
        }
        method2.visitInsn(Type.getReturnType((String)method2.desc).getOpcode(172));
        classNode.methods.add(method2);
    }

    default public void removeFrom(@Nonnull InsnList instructions, @Nonnull AbstractInsnNode insn, int n) {
        if (n > 0) {
            for (int i = 0; i < n; ++i) {
                instructions.remove(insn.getNext());
            }
        } else {
            for (int i = 0; i > n; --i) {
                instructions.remove(insn.getPrevious());
            }
        }
        instructions.remove(insn);
    }

    @Nonnull
    default public AbstractInsnNode getPrevious(@Nonnull AbstractInsnNode insn, int n) {
        AbstractInsnNode ret = insn;
        for (int i = 0; i < n && ret.getPrevious() != null; ++i) {
            ret = ret.getPrevious();
        }
        return ret;
    }

    @Nonnull
    default public AbstractInsnNode getNext(@Nonnull AbstractInsnNode insn, int n) {
        AbstractInsnNode ret = insn;
        for (int i = 0; i < n && ret.getNext() != null; ++i) {
            ret = ret.getNext();
        }
        return ret;
    }

    @Nonnull
    default public MethodInsnNode genMethodNode(@Nonnull String name, @Nonnull String desc) {
        return this.genMethodNode(this.getHookClass(), name, desc);
    }

    @Nonnull
    default public MethodInsnNode genMethodNode(@Nonnull String owner, @Nonnull String name, @Nonnull String desc) {
        return new MethodInsnNode(184, owner, name, desc, false);
    }

    @Nonnull
    default public LocalVariableNode findLocal(@Nonnull MethodNode method, @Nonnull String name, @Nonnull String desc) {
        return (method.localVariables == null ? Collections.emptyList() : method.localVariables).stream().filter(var -> var.name.equals(name) && var.desc.equals(desc)).findFirst().orElseThrow(() -> new TypeNotPresentException(String.format("Could not find local variable: {name: \"%s\", desc: \"%s\"} in method: {name: \"%s\", desc: \"%s\"}", name, desc, method.name, method.desc), null));
    }

    default public boolean checkMethod(@Nonnull MethodNode method, @Nullable String name, @Nullable String desc) {
        if (name == null && desc == null) {
            return true;
        }
        if (name == null) {
            return method.desc.equals(desc);
        }
        if (desc == null) {
            return method.name.equals(name);
        }
        return method.name.equals(name) && method.desc.equals(desc);
    }

    default public boolean checkMethod(@Nullable AbstractInsnNode insn, @Nullable String name, @Nullable String desc) {
        if (!(insn instanceof MethodInsnNode)) {
            return false;
        }
        if (name == null && desc == null) {
            return true;
        }
        if (name == null) {
            return ((MethodInsnNode)insn).desc.equals(desc);
        }
        if (desc == null) {
            return ((MethodInsnNode)insn).name.equals(name);
        }
        return ((MethodInsnNode)insn).name.equals(name) && ((MethodInsnNode)insn).desc.equals(desc);
    }

    default public boolean checkMethod(@Nullable AbstractInsnNode insn, @Nonnull String name) {
        return insn instanceof MethodInsnNode && ((MethodInsnNode)insn).name.equals(name);
    }

    default public boolean checkField(@Nullable AbstractInsnNode insn, @Nullable String name, @Nullable String desc) {
        if (!(insn instanceof FieldInsnNode)) {
            return false;
        }
        if (name == null && desc == null) {
            return true;
        }
        if (name == null) {
            return ((FieldInsnNode)insn).desc.equals(desc);
        }
        if (desc == null) {
            return ((FieldInsnNode)insn).name.equals(name);
        }
        return ((FieldInsnNode)insn).name.equals(name) && ((FieldInsnNode)insn).desc.equals(desc);
    }

    default public boolean checkField(@Nullable AbstractInsnNode insn, @Nonnull String name) {
        return insn instanceof FieldInsnNode && ((FieldInsnNode)insn).name.equals(name);
    }

    default public boolean recalcFrames(boolean obfuscated) {
        return false;
    }

    default public boolean shouldInformConsole() {
        return true;
    }

    @Nonnull
    default public String getHookClass() {
        return this.getClass().getName().replace('.', '/') + "$Hooks";
    }

    @Nonnull
    default public String getAccessorClass() {
        return this.getClass().getName().replace('.', '/') + "$Accessor";
    }

    @Nonnull
    default public String withAccessorClass(@Nonnull String format) {
        return format.replace("%s", this.getAccessorClass());
    }
}

