/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.forge;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.util.BlockSnapshot;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.TypeInsnNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBlockSnapshot
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (this.checkMethod(method, "<init>", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;Lnet/minecraft/nbt/NBTTagCompound;)V")) {
            return 1;
        }
        if (method.name.equals("readFromNBT")) {
            return 3;
        }
        if (method.name.equals("writeToNBT")) {
            return 5;
        }
        if (method.name.equals("equals")) {
            return 6;
        }
        return method.name.equals("restoreToLocation") ? 4 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && insn.getOpcode() == 177) {
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 2));
            instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("setReplacedFluid", this.withAccessorClass("(L%s;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V")));
            return true;
        }
        if (index == 3 && insn.getOpcode() == 176) {
            instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("getBlockSnapshot", "(Lnet/minecraftforge/common/util/BlockSnapshot;Lnet/minecraft/nbt/NBTTagCompound;)Lnet/minecraftforge/common/util/BlockSnapshot;"));
            return true;
        }
        if (index == 4 && this.checkMethod(insn.getPrevious(), obfuscated ? "func_180501_a" : "setBlockState")) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new VarInsnNode(25, 1));
            list.add((AbstractInsnNode)new VarInsnNode(25, 2));
            list.add((AbstractInsnNode)this.genMethodNode("restoreToLocation", "(Lnet/minecraftforge/common/util/BlockSnapshot;Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)V"));
            instructions.insert(insn, list);
        } else {
            if (index == 5 && insn.getOpcode() == 177) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("writeToNBT", this.withAccessorClass("(L%s;Lnet/minecraft/nbt/NBTTagCompound;)V")));
                return true;
            }
            if (index == 6 && insn.getOpcode() == 172) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 1));
                instructions.insertBefore(insn, (AbstractInsnNode)new TypeInsnNode(192, this.getAccessorClass()));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("equals", this.withAccessorClass("(ZL%s;L%s;)Z")));
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.fields.add(new FieldNode(1, "replacedFluid", "Lgit/jbredwards/fluidlogged_api/api/util/FluidState;", null, null));
        classNode.interfaces.add(this.getAccessorClass());
        this.addMethod(classNode, "getReplacedFluid", "()Lgit/jbredwards/fluidlogged_api/api/util/FluidState;", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitFieldInsn(180, "net/minecraftforge/common/util/BlockSnapshot", "replacedFluid", "Lgit/jbredwards/fluidlogged_api/api/util/FluidState;");
        });
        this.addMethod(classNode, "setReplacedFluid", "(Lgit/jbredwards/fluidlogged_api/api/util/FluidState;)V", null, null, generator -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitFieldInsn(181, "net/minecraftforge/common/util/BlockSnapshot", "replacedFluid", "Lgit/jbredwards/fluidlogged_api/api/util/FluidState;");
        });
        this.overrideMethod(classNode, (MethodNode method) -> this.checkMethod((MethodNode)method, "getBlockSnapshot", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraftforge/common/util/BlockSnapshot;"), "getBlockSnapshot", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;)Lnet/minecraftforge/common/util/BlockSnapshot;", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
        });
        this.overrideMethod(classNode, (MethodNode method) -> this.checkMethod((MethodNode)method, "getBlockSnapshot", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;I)Lnet/minecraftforge/common/util/BlockSnapshot;"), "getBlockSnapshot", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;I)Lnet/minecraftforge/common/util/BlockSnapshot;", (GeneratorAdapter generator) -> {
            generator.visitVarInsn(25, 0);
            generator.visitVarInsn(25, 1);
            generator.visitVarInsn(21, 2);
        });
        return true;
    }

    public static interface Accessor {
        @Nullable
        public FluidState getReplacedFluid();

        public void setReplacedFluid(@Nonnull FluidState var1);
    }

    public static final class Hooks {
        @Nonnull
        public static final ThreadLocal<Boolean> gatheringFluids = ThreadLocal.withInitial(() -> Boolean.FALSE);

        @Nonnull
        public static BlockSnapshot getBlockSnapshot(@Nonnull World world, @Nonnull BlockPos pos) {
            gatheringFluids.set(Boolean.TRUE);
            Chunk chunk = world.func_175726_f(pos);
            BlockSnapshot snapshot = new BlockSnapshot(world, pos, chunk.func_177435_g(pos));
            ((Accessor)snapshot).setReplacedFluid(FluidState.getFromProvider((ICapabilityProvider)chunk, pos));
            gatheringFluids.set(Boolean.FALSE);
            return snapshot;
        }

        @Nonnull
        public static BlockSnapshot getBlockSnapshot(@Nonnull World world, @Nonnull BlockPos pos, int flags) {
            gatheringFluids.set(Boolean.TRUE);
            Chunk chunk = world.func_175726_f(pos);
            BlockSnapshot snapshot = new BlockSnapshot(world, pos, chunk.func_177435_g(pos), flags);
            ((Accessor)snapshot).setReplacedFluid(FluidState.getFromProvider((ICapabilityProvider)chunk, pos));
            gatheringFluids.set(Boolean.FALSE);
            return snapshot;
        }

        @Nonnull
        public static BlockSnapshot getBlockSnapshot(@Nonnull BlockSnapshot snapshot, @Nonnull NBTTagCompound nbt) {
            Block fluidBlock = Block.func_149684_b((String)nbt.func_74779_i("fluidBlock"));
            if (fluidBlock != null) {
                ((Accessor)snapshot).setReplacedFluid(FluidState.of(fluidBlock.func_176203_a(nbt.func_74762_e("fluidMeta"))));
            }
            return snapshot;
        }

        public static boolean equals(boolean ret, @Nonnull Accessor snapshot, @Nonnull Accessor other) {
            if (!ret) {
                return false;
            }
            if (snapshot.getReplacedFluid() == other.getReplacedFluid()) {
                return true;
            }
            if (snapshot.getReplacedFluid() == FluidState.EMPTY && other.getReplacedFluid() == null) {
                return true;
            }
            return snapshot.getReplacedFluid() == null && other.getReplacedFluid() == FluidState.EMPTY;
        }

        public static void restoreToLocation(@Nonnull BlockSnapshot snapshot, @Nonnull World world, @Nonnull BlockPos pos) {
            FluidState replacedFluid = ((Accessor)snapshot).getReplacedFluid();
            if (replacedFluid != null) {
                FluidloggedUtils.setFluidState(world, pos, snapshot.getReplacedBlock(), replacedFluid, false, snapshot.getFlag());
            }
        }

        public static void setReplacedFluid(@Nonnull Accessor snapshot, @Nonnull World world, @Nonnull BlockPos pos) {
            if (!gatheringFluids.get().booleanValue()) {
                snapshot.setReplacedFluid(FluidState.get((IBlockAccess)world, pos));
            }
        }

        public static void writeToNBT(@Nonnull Accessor snapshot, @Nonnull NBTTagCompound nbt) {
            FluidState replacedFluid = snapshot.getReplacedFluid();
            if (replacedFluid != null) {
                nbt.func_74778_a("fluidBlock", replacedFluid.getBlock().getRegistryName().toString());
                nbt.func_74768_a("fluidMeta", replacedFluid.getMetadata());
            }
        }
    }
}

