/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.astral_sorcery;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import hellfirepvp.astralsorcery.common.block.fluid.FluidBlockLiquidStarlight;
import java.util.Collection;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.oredict.OreDictionary;
import org.apache.commons.lang3.ArrayUtils;
import org.objectweb.asm.commons.GeneratorAdapter;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodNode;

public final class PluginEntityCrystal
implements IASMPlugin {
    @Override
    public boolean isMethodValid(@Nonnull MethodNode method, boolean obfuscated) {
        return method.name.equals("increaseSize");
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (this.checkMethod(insn, obfuscated ? "func_175698_g" : "setBlockToAir")) {
            instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(1));
            instructions.insertBefore(insn, (AbstractInsnNode)new InsnNode(6));
            instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("git/jbredwards/fluidlogged_api/api/util/FluidloggedUtils", "setFluidToAir", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;I)Z"));
            instructions.remove(insn);
            return true;
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("canCraft"), "canCraft", "(Lnet/minecraft/entity/Entity;)I", (GeneratorAdapter generator) -> generator.visitVarInsn(25, 0));
        this.overrideMethod(classNode, (MethodNode method) -> method.name.equals("getCraftMode"), "getCraftMode", "(Lnet/minecraft/entity/Entity;)I", (GeneratorAdapter generator) -> generator.visitVarInsn(25, 0));
        return true;
    }

    public static final class Hooks {
        public static boolean canCraft(@Nonnull Entity crystal) {
            BlockPos pos = new BlockPos(crystal.field_70165_t, crystal.field_70163_u, crystal.field_70161_v);
            Chunk chunk = crystal.field_70170_p.func_175726_f(pos);
            if (!(FluidloggedUtils.getFluidOrReal(chunk, pos).func_177230_c() instanceof FluidBlockLiquidStarlight)) {
                return false;
            }
            AxisAlignedBB bb = new AxisAlignedBB(pos);
            return IntStream.rangeClosed(MathHelper.func_76125_a((int)MathHelper.func_76128_c((double)((bb.field_72338_b - World.MAX_ENTITY_RADIUS) / 16.0)), (int)0, (int)chunk.func_177429_s().length), MathHelper.func_76125_a((int)MathHelper.func_76128_c((double)((bb.field_72337_e + World.MAX_ENTITY_RADIUS) / 16.0)), (int)0, (int)chunk.func_177429_s().length)).mapToObj(i -> chunk.func_177429_s()[i]).flatMap(Collection::stream).noneMatch(e -> e != crystal && bb.func_72326_a(e.func_174813_aQ()));
        }

        public static int getCraftMode(@Nonnull Entity crystal) {
            BlockPos pos = new BlockPos(crystal.field_70165_t, crystal.field_70163_u, crystal.field_70161_v);
            Chunk chunk = crystal.field_70170_p.func_175726_f(pos);
            boolean foundGlowstone = false;
            AxisAlignedBB bb = new AxisAlignedBB(pos);
            for (Entity entity : (Entity[])IntStream.rangeClosed(MathHelper.func_76125_a((int)MathHelper.func_76128_c((double)((bb.field_72338_b - World.MAX_ENTITY_RADIUS) / 16.0)), (int)0, (int)chunk.func_177429_s().length), MathHelper.func_76125_a((int)MathHelper.func_76128_c((double)((bb.field_72337_e + World.MAX_ENTITY_RADIUS) / 16.0)), (int)0, (int)chunk.func_177429_s().length)).mapToObj(i -> chunk.func_177429_s()[i]).flatMap(Collection::stream).toArray(Entity[]::new)) {
                if (entity == crystal || !entity.func_174813_aQ().func_72326_a(bb)) continue;
                if (!foundGlowstone && entity instanceof EntityItem && ArrayUtils.contains((int[])OreDictionary.getOreIDs((ItemStack)((EntityItem)entity).func_92059_d()), (int)OreDictionary.getOreID((String)"dustGlowstone"))) {
                    foundGlowstone = true;
                    continue;
                }
                return -1;
            }
            if (foundGlowstone) {
                return chunk.func_177435_g(pos).func_177230_c() instanceof FluidBlockLiquidStarlight ? 1 : -1;
            }
            return FluidloggedUtils.getFluidOrReal(chunk, pos).func_177230_c() instanceof FluidBlockLiquidStarlight ? 0 : -1;
        }
    }
}

