/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.asm.plugins.modded.betweenlands;

import git.jbredwards.fluidlogged_api.api.asm.IASMPlugin;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.fluids.FluidUtil;
import net.minecraftforge.fluids.IFluidBlock;
import org.objectweb.asm.tree.AbstractInsnNode;
import org.objectweb.asm.tree.ClassNode;
import org.objectweb.asm.tree.FieldInsnNode;
import org.objectweb.asm.tree.InsnList;
import org.objectweb.asm.tree.InsnNode;
import org.objectweb.asm.tree.MethodInsnNode;
import org.objectweb.asm.tree.MethodNode;
import org.objectweb.asm.tree.VarInsnNode;

public final class PluginBetweenlands
implements IASMPlugin {
    @Override
    public int getMethodIndex(@Nonnull MethodNode method, boolean obfuscated) {
        if (method.name.equals("<init>")) {
            return 1;
        }
        if (method.name.equals(obfuscated ? "func_176200_f" : "isReplaceable")) {
            return 2;
        }
        return method.name.equals("place") ? 3 : 0;
    }

    @Override
    public boolean transform(@Nonnull InsnList instructions, @Nonnull MethodNode method, @Nonnull AbstractInsnNode insn, boolean obfuscated, int index) {
        if (index == 1 && insn.getOpcode() == 183) {
            InsnList list = new InsnList();
            list.add((AbstractInsnNode)new VarInsnNode(25, 0));
            list.add((AbstractInsnNode)new InsnNode(4));
            list.add((AbstractInsnNode)new FieldInsnNode(181, "net/minecraftforge/fluids/BlockFluidClassic", "canCreateSources", "Z"));
            instructions.insert(insn, list);
            return true;
        }
        if (index == 2 && this.checkMethod(insn, obfuscated ? "func_180495_p" : "getBlockState")) {
            instructions.insert(insn, (AbstractInsnNode)new MethodInsnNode(183, "net/minecraft/block/Block", obfuscated ? "func_176223_P" : "getDefaultState", "()Lnet/minecraft/block/state/IBlockState;", false));
            instructions.insert(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
            instructions.remove(this.getPrevious(insn, 2));
            instructions.remove(this.getPrevious(insn, 1));
            instructions.remove(insn);
            return true;
        }
        if (index == 3) {
            if (this.checkMethod(insn, "destroyBlockOnFluidPlacement")) {
                this.removeFrom(instructions, insn, -2);
            } else if (this.checkMethod(insn, obfuscated ? "func_180501_a" : "setBlockState")) {
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 0));
                instructions.insertBefore(insn, (AbstractInsnNode)new VarInsnNode(25, 5));
                instructions.insertBefore(insn, (AbstractInsnNode)this.genMethodNode("fixBetweenlandsPlace", "(Lnet/minecraft/world/World;Lnet/minecraft/util/math/BlockPos;Lnet/minecraft/block/state/IBlockState;ILnet/minecraftforge/fluids/IFluidBlock;Lnet/minecraft/block/state/IBlockState;)Z"));
                instructions.remove(insn);
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean transformClass(@Nonnull ClassNode classNode, boolean obfuscated) {
        classNode.methods.removeIf(method -> method.name.equals("canDisplace") || method.name.equals("displaceIfPossible") || method.name.equals("getFluidHeightForRender") || method.name.equals("getFlowVector") || method.name.equals("causesDownwardCurrent") || method.name.equals("getQuantaValue") || method.name.equals("canFlowInto") || method.name.equals(obfuscated ? "func_180650_b" : "updateTick") || method.name.equals(obfuscated ? "func_176225_a" : "shouldSideBeRendered"));
        return true;
    }

    public static final class Hooks {
        public static boolean fixBetweenlandsPlace(@Nonnull World world, @Nonnull BlockPos pos, @Nonnull IBlockState fluid, int flags, @Nonnull IFluidBlock block, @Nonnull IBlockState here) {
            if (FluidloggedUtils.isStateFluidloggable(here, (IBlockAccess)world, pos, FluidState.of(block.getFluid()))) {
                return FluidloggedUtils.setFluidState(world, pos, here, FluidState.of(block.getFluid()), true, flags);
            }
            FluidUtil.destroyBlockOnFluidPlacement((World)world, (BlockPos)pos);
            return world.func_180501_a(pos, fluid, flags);
        }
    }
}

