/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.client;

import com.google.common.base.Function;
import com.google.common.base.Functions;
import com.google.common.collect.Maps;
import git.jbredwards.fluidlogged_api.api.util.FluidState;
import git.jbredwards.fluidlogged_api.api.util.FluidloggedUtils;
import javax.annotation.Nonnull;
import net.minecraft.block.Block;
import net.minecraft.block.BlockLiquid;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.RayTraceResult;
import net.minecraftforge.client.event.ModelBakeEvent;
import net.minecraftforge.client.event.ModelRegistryEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.model.ModelFluid;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.relauncher.Side;

@Mod.EventBusSubscriber(modid="fluidlogged_api", value={Side.CLIENT})
public final class ClientEventHandler {
    @SubscribeEvent(priority=EventPriority.LOW)
    static void updateRenderOnConfigChange(@Nonnull ConfigChangedEvent.PostConfigChangedEvent event) {
        if (event.isWorldRunning() && "fluidlogged_api".equals(event.getModID())) {
            Minecraft.func_71410_x().field_71438_f.func_72712_a();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    static void registerLiquidStateMappers(@Nonnull ModelRegistryEvent event) {
        ForgeRegistries.BLOCKS.getEntries().forEach(entry -> {
            if (entry.getValue() instanceof BlockLiquid && FluidloggedUtils.isFluid((Block)entry.getValue())) {
                ModelLoader.setCustomStateMapper((Block)((Block)entry.getValue()), block -> Maps.toMap((Iterable)block.func_176194_O().func_177619_a(), (Function)Functions.constant((Object)new ModelResourceLocation((ResourceLocation)entry.getKey(), "fluid"))));
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void registerLiquidBakedModels(@Nonnull ModelBakeEvent event) {
        ForgeRegistries.BLOCKS.getEntries().forEach(entry -> {
            if (entry.getValue() instanceof BlockLiquid && FluidloggedUtils.isFluid((Block)entry.getValue())) {
                ModelResourceLocation location = new ModelResourceLocation((ResourceLocation)entry.getKey(), "fluid");
                IBakedModel model = new ModelFluid(FluidloggedUtils.getFluidFromBlock((Block)entry.getValue())).bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176600_a, ModelLoader.defaultTextureGetter());
                event.getModelRegistry().func_82595_a((Object)location, (Object)model);
                event.getModelManager().func_174954_c().func_178120_a().field_178449_b.remove(entry.getValue());
            }
        });
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    static void improveDebugScreen(@Nonnull RenderGameOverlayEvent.Text event) {
        FluidState fluidState;
        RayTraceResult trace = Minecraft.func_71410_x().field_71476_x;
        if (trace != null && trace.field_72313_a == RayTraceResult.Type.BLOCK && !event.getRight().isEmpty() && (fluidState = FluidState.get(trace.func_178782_a())) != FluidState.EMPTY) {
            event.getRight().add("");
            event.getRight().add(String.valueOf(fluidState.getBlock().getRegistryName()));
            event.getRight().add(I18n.func_135052_a((String)"debug.fluidlogged_api.fluid", (Object[])new Object[]{fluidState.getFluid().getName()}));
            if (!fluidState.isEmpty()) {
                event.getRight().add(I18n.func_135052_a((String)"debug.fluidlogged_api.level", (Object[])new Object[]{fluidState.getLevel()}));
            }
        }
    }
}

