/*
 * Decompiled with CFR 0.152.
 */
package git.jbredwards.fluidlogged_api.mod.common;

import git.jbredwards.fluidlogged_api.api.capability.CapabilityProvider;
import git.jbredwards.fluidlogged_api.api.capability.IFluidStateCapability;
import git.jbredwards.fluidlogged_api.api.event.FluidloggableEvent;
import git.jbredwards.fluidlogged_api.mod.FluidloggedAPI;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IConfigAccessor;
import git.jbredwards.fluidlogged_api.mod.asm.iface.IHardcodedCapability;
import git.jbredwards.fluidlogged_api.mod.asm.plugins.vanilla.world.PluginChunk;
import git.jbredwards.fluidlogged_api.mod.common.capability.FluidStateCapabilityWrapped;
import git.jbredwards.fluidlogged_api.mod.common.capability.cubicchunks.FluidStateCapabilityICube;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfig;
import git.jbredwards.fluidlogged_api.mod.common.config.FluidloggedAPIConfigs;
import git.jbredwards.fluidlogged_api.mod.common.config.util.ConfigPredicate;
import git.jbredwards.fluidlogged_api.mod.common.message.CMessageSyncGameRule;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageSyncFluidStates;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageSyncGameRule;
import git.jbredwards.fluidlogged_api.mod.common.message.SMessageSyncRuntimeConfigs;
import io.github.opencubicchunks.cubicchunks.api.util.XYZAddressable;
import io.github.opencubicchunks.cubicchunks.api.world.CubeWatchEvent;
import io.github.opencubicchunks.cubicchunks.api.world.ICube;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.ForgeModContainer;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.common.config.Config;
import net.minecraftforge.common.config.ConfigManager;
import net.minecraftforge.event.AttachCapabilitiesEvent;
import net.minecraftforge.event.GameRuleChangeEvent;
import net.minecraftforge.event.world.ChunkWatchEvent;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.fml.client.event.ConfigChangedEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.Optional;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.eventhandler.EventPriority;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.network.FMLNetworkEvent;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

@Mod.EventBusSubscriber(modid="fluidlogged_api")
public final class EventHandler {
    @SubscribeEvent
    static void configFileSync(@Nonnull ConfigChangedEvent.OnConfigChangedEvent event) {
        if ("fluidlogged_api".equals(event.getModID())) {
            ConfigManager.sync((String)"fluidlogged_api", (Config.Type)Config.Type.INSTANCE);
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void forceForgeCascadingFix(@Nonnull ConfigChangedEvent.PostConfigChangedEvent event) {
        ForgeModContainer.fixVanillaCascading = true;
    }

    @SubscribeEvent(priority=EventPriority.HIGH)
    static void handleConfigOverrides(@Nonnull FluidloggableEvent event) {
        if (!FluidloggedAPIConfig.nonSourceFluidlogging && event.fluid != null && !event.fluidState.isSource()) {
            event.setCanceled(true);
            event.setResult(Event.Result.DENY);
        } else {
            IBlockState actualState = event.state.func_185899_b((IBlockAccess)event.world, event.pos);
            ConfigPredicate blacklist = ((IConfigAccessor)actualState).getBlacklistPredicate();
            ConfigPredicate whitelist = ((IConfigAccessor)actualState).getWhitelistPredicate();
            if (blacklist != null && blacklist.test((IBlockAccess)event.world, event.pos, actualState, event.fluidState)) {
                event.setCanceled(true);
                event.setResult(Event.Result.DENY);
            } else if (whitelist != null && whitelist.test((IBlockAccess)event.world, event.pos, actualState, event.fluidState)) {
                event.setCanceled(true);
                event.setResult(Event.Result.ALLOW);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    static void handleSyncConfigs(@Nonnull FMLNetworkEvent.ServerConnectionFromClientEvent event) {
        if (event.getHandler() instanceof NetHandlerPlayServer) {
            EntityPlayerMP player = ((NetHandlerPlayServer)event.getHandler()).field_147369_b;
            if (!event.isLocal() || player.field_71133_b.func_71262_S()) {
                FluidloggedAPI.WRAPPER.sendTo((IMessage)new SMessageSyncRuntimeConfigs(FluidloggedAPIConfigs.readConfigFiles(player.field_71133_b)), player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void handleSyncDoFireTick(@Nonnull GameRuleChangeEvent event) {
        if ("doFireTick".equals(event.getRuleName())) {
            FluidloggedAPI.WRAPPER.sendToAll((IMessage)new SMessageSyncGameRule("doFireTick", event.getRules().func_82767_a("doFireTick"), true));
        }
    }

    @SideOnly(value=Side.CLIENT)
    @SubscribeEvent(priority=EventPriority.LOWEST)
    static void handleSyncDoFireTick(@Nonnull WorldEvent.Load event) {
        FluidloggedAPI.WRAPPER.sendToServer((IMessage)new CMessageSyncGameRule("doFireTick", false));
    }

    @SubscribeEvent(priority=EventPriority.LOW)
    static void attachToChunk(@Nonnull AttachCapabilitiesEvent<Chunk> event) {
        if (!event.getCapabilities().containsKey(IFluidStateCapability.CAPABILITY_ID)) {
            event.addCapability(IFluidStateCapability.CAPABILITY_ID, new CapabilityProvider<FluidStateCapabilityWrapped>(IFluidStateCapability.CAPABILITY, new FluidStateCapabilityWrapped((IHardcodedCapability)event.getObject())));
        }
    }

    @Optional.Method(modid="cubicchunks")
    @SubscribeEvent(priority=EventPriority.LOW)
    static void attachToCube(@Nonnull AttachCapabilitiesEvent<ICube> event) {
        if (!event.getCapabilities().containsKey(IFluidStateCapability.CAPABILITY_ID)) {
            event.addCapability(IFluidStateCapability.CAPABILITY_ID, new CapabilityProvider<FluidStateCapabilityICube>(IFluidStateCapability.CAPABILITY, new FluidStateCapabilityICube((XYZAddressable)event.getObject())));
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    static void syncChunk(@Nonnull ChunkWatchEvent.Watch event) {
        Chunk chunk = event.getChunkInstance();
        if (!(chunk == null || FluidloggedAPI.isCubicChunks && PluginChunk.CCHooks.isCubicWorld(chunk.func_177412_p()))) {
            FluidloggedAPI.WRAPPER.sendTo((IMessage)new SMessageSyncFluidStates(chunk, ((IHardcodedCapability)chunk).getFluidStateCapability()), event.getPlayer());
        }
    }

    @Optional.Method(modid="cubicchunks")
    @SubscribeEvent(priority=EventPriority.HIGHEST)
    static void syncCube(@Nonnull CubeWatchEvent event) {
        ICube cube = event.getCube();
        IFluidStateCapability cap = IFluidStateCapability.get((ICapabilityProvider)cube);
        if (cap != null) {
            FluidloggedAPI.WRAPPER.sendTo((IMessage)new SMessageSyncFluidStates(cube.getX(), cube.getY() << 4, cube.getZ(), cap), event.getPlayer());
        }
    }
}

